/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.module;

import com.google.common.io.ByteArrayDataInput;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.Items;
import ic2.api.reactor.IC2Reactor;
import ic2.api.recipe.Recipes;
import java.util.HashMap;
import java.util.Map;
import miscperipherals.api.IEnergyMeterData;
import miscperipherals.api.IRTGFuel;
import miscperipherals.api.MiscPeripheralsAPI;
import miscperipherals.core.MiscPeripherals;
import miscperipherals.core.Module;
import miscperipherals.peripheral.PeripheralRTG;
import miscperipherals.safe.Reflector;
import miscperipherals.tile.TileChargeStation;
import miscperipherals.upgrade.UpgradeLaser;
import miscperipherals.upgrade.UpgradeOreScanner;
import miscperipherals.upgrade.UpgradeSolar;
import miscperipherals.upgrade.UpgradeTreetap;
import miscperipherals.util.Util;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.NetHandler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.oredict.OreDictionary;

public class ModuleIC2
extends Module {
    public static boolean enableLaser = true;
    public static boolean enableSolar = true;
    public static boolean enableTreetap = true;
    public static boolean enableODScanner = true;
    public static boolean enableOVScanner = true;
    private boolean hasGT;
    private ItemStack refinedUranium = Items.getItem((String)"refinedUranium");
    private ItemStack uraniumBlock = Items.getItem((String)"uraniumBlock");
    private ItemStack reactorUraniumSimple = Items.getItem((String)"reactorUraniumSimple");
    private ItemStack reactorUraniumDual = Items.getItem((String)"reactorUraniumDual");
    private ItemStack reactorUraniumQuad = Items.getItem((String)"reactorUraniumQuad");

    @Override
    public void onPreInit() {
        MiscPeripherals instance = MiscPeripherals.instance;
        this.hasGT = false;
        enableLaser = instance.settings.get("features", "enableLaser", enableLaser, "Enable the Laser turtle upgrade").getBoolean(enableLaser);
        enableSolar = instance.settings.get("features", "enableSolar", enableSolar, "Enable the Solar turtle upgrade").getBoolean(enableSolar);
        enableTreetap = instance.settings.get("features", "enableTreetap", enableTreetap, "Enable the Treetap turtle upgrade").getBoolean(enableTreetap);
        enableODScanner = instance.settings.get("features", "enableODScanner", enableODScanner, "Enable the Ore Scanner turtle upgrade").getBoolean(enableODScanner);
        enableOVScanner = instance.settings.get("features", "enableOVScanner", enableOVScanner, "Enable the Advanced Ore Scanner turtle upgrade").getBoolean(enableOVScanner);
    }

    @Override
    public void onInit() {
    }

    @Override
    public void onPostInit() {
        if (enableLaser) {
            MiscPeripherals.registerUpgrade(new UpgradeLaser());
        }
        if (enableSolar) {
            MiscPeripherals.registerUpgrade(new UpgradeSolar());
        }
        if (enableTreetap) {
            MiscPeripherals.registerUpgrade(new UpgradeTreetap());
        }
        if (enableODScanner) {
            MiscPeripherals.registerUpgrade(new UpgradeOreScanner(false));
        }
        if (enableOVScanner) {
            MiscPeripherals.registerUpgrade(new UpgradeOreScanner(true));
        }
        if (MiscPeripherals.instance.enableChargeStation) {
            Recipes.advRecipes.addShapelessRecipe(new ItemStack((Block)MiscPeripherals.instance.blockAlpha, 1, 0), new Object[]{this.hasGT ? "crafting10kEUStore" : Items.getItem((String)"reBattery"), this.hasGT ? "craftingRawMachineTier01" : Items.getItem((String)"machine"), Item.field_77767_aC});
        }
        if (MiscPeripherals.instance.enableChargeStationT2) {
            Recipes.advRecipes.addRecipe(new ItemStack((Block)MiscPeripherals.instance.blockBeta, 1, 1), new Object[]{" # ", "C@C", " $ ", Character.valueOf('C'), Items.getItem((String)"doubleInsulatedGoldCableItem"), Character.valueOf('#'), this.hasGT ? "craftingCircuitTier02" : Items.getItem((String)"electronicCircuit"), Character.valueOf('$'), this.hasGT ? "crafting100kEUStore" : Items.getItem((String)"energyCrystal"), Character.valueOf('@'), MiscPeripherals.instance.enableChargeStation ? new ItemStack((Block)MiscPeripherals.instance.blockAlpha, 1, 0) : (this.hasGT ? "craftingRawMachineTier01" : Items.getItem((String)"machine"))});
        }
        if (MiscPeripherals.instance.enableChargeStationT3) {
            Recipes.advRecipes.addRecipe(new ItemStack((Block)MiscPeripherals.instance.blockBeta, 1, 2), new Object[]{" # ", "C@C", " $ ", Character.valueOf('C'), Items.getItem((String)"glassFiberCableItem"), Character.valueOf('#'), this.hasGT ? "craftingCircuitTier04" : Items.getItem((String)"advancedCircuit"), Character.valueOf('$'), this.hasGT ? "crafting1kkEUStore" : Items.getItem((String)"lapotronCrystal"), Character.valueOf('@'), MiscPeripherals.instance.enableChargeStationT2 ? new ItemStack((Block)MiscPeripherals.instance.blockBeta, 1, 1) : (MiscPeripherals.instance.enableChargeStation ? new ItemStack((Block)MiscPeripherals.instance.blockAlpha, 1, 0) : (this.hasGT ? "craftingRawMachineTier02" : Items.getItem((String)"advancedMachine")))});
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
        IRTGFuel.handlers.add(new IRTGFuel(){

            @Override
            public int get(ItemStack stack) {
                if (Util.areStacksEqual(stack, ModuleIC2.this.refinedUranium)) {
                    return PeripheralRTG.URANIUM_TOTAL;
                }
                if (Util.areStacksEqual(stack, ModuleIC2.this.uraniumBlock)) {
                    return PeripheralRTG.URANIUM_TOTAL * 9;
                }
                if (stack.field_77993_c == ((ModuleIC2)ModuleIC2.this).reactorUraniumSimple.field_77993_c) {
                    return (int)((float)PeripheralRTG.URANIUM_TOTAL * (1.0f - (float)stack.func_77960_j() / (float)stack.func_77958_k()));
                }
                if (stack.field_77993_c == ((ModuleIC2)ModuleIC2.this).reactorUraniumDual.field_77993_c) {
                    return (int)((float)PeripheralRTG.URANIUM_TOTAL * 2.0f * (1.0f - (float)stack.func_77960_j() / (float)stack.func_77958_k()));
                }
                if (stack.field_77993_c == ((ModuleIC2)ModuleIC2.this).reactorUraniumQuad.field_77993_c) {
                    return (int)((float)PeripheralRTG.URANIUM_TOTAL * 4.0f * (1.0f - (float)stack.func_77960_j() / (float)stack.func_77958_k()));
                }
                return 0;
            }
        });
        TileChargeStation.PLUGINS.add(new TileChargeStation.ChargeStationPlugin(){

            @Override
            public void update(TileChargeStation station) {
                IElectricItem ee;
                ItemStack battery;
                if (!station.addedToEnergyNet) {
                    MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)station));
                    station.addedToEnergyNet = true;
                }
                if ((battery = station.func_70301_a(0)) != null && battery.func_77973_b() instanceof IElectricItem && (ee = (IElectricItem)battery.func_77973_b()).canProvideEnergy(battery) && ee.getTier(battery) <= station.tier) {
                    station.energy += (double)ElectricItem.discharge((ItemStack)battery, (int)((int)Math.ceil((double)station.getMaxCharge() - station.energy)), (int)station.tier, (boolean)false, (boolean)false);
                }
            }

            @Override
            public boolean isBattery(TileChargeStation station, ItemStack item) {
                if (item.func_77973_b() instanceof IElectricItem) {
                    IElectricItem iee = (IElectricItem)item.func_77973_b();
                    return iee.canProvideEnergy(item) && iee.getTier(item) <= station.tier;
                }
                return false;
            }

            @Override
            public void unload(TileChargeStation station) {
                if (!station.field_70331_k.field_72995_K) {
                    MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)station));
                    station.addedToEnergyNet = false;
                }
            }

            @Override
            public boolean onBlockActivated(TileChargeStation station, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
                return false;
            }

            @Override
            public void readFromNBT(TileChargeStation station, NBTTagCompound compound) {
            }

            @Override
            public void writeToNBT(TileChargeStation station, NBTTagCompound compound) {
            }

            @Override
            public void initialize(TileChargeStation station) {
            }

            @Override
            public boolean isDisabled(TileChargeStation station) {
                return false;
            }
        });
        IEnergyMeterData.handlers.add(new IEnergyMeterData(){

            @Override
            public boolean canHandle(World world, int x, int y, int z, int side, Object[] arguments) {
                if (!world.func_72899_e(x, y, z)) {
                    return false;
                }
                TileEntity te = world.func_72796_p(x, y, z);
                return te instanceof IEnergyTile;
            }

            @Override
            public void start(World world, int x, int y, int z, int side, NBTTagCompound data, Object[] arguments) {
                if (!world.func_72899_e(x, y, z)) {
                    return;
                }
                TileEntity te = world.func_72796_p(x, y, z);
                if (!(te instanceof IEnergyTile)) {
                    return;
                }
                EnergyNet enet = EnergyNet.getForWorld((World)world);
                long emitted = enet.getTotalEnergyEmitted(te);
                long sunken = enet.getTotalEnergySunken(te);
                data.func_74772_a("lastTotalEnergyEmitted", emitted);
                data.func_74772_a("lastTotalEnergySunken", sunken);
                data.func_74772_a("firstTotalEnergy", emitted + sunken);
                data.func_74772_a("lastMeasureTime", world.func_82737_E());
            }

            @Override
            public void cleanup(World world, int x, int y, int z, int side, NBTTagCompound data, Object[] arguments) {
            }

            @Override
            public Map getData(World world, int x, int y, int z, int side, NBTTagCompound data, Object[] arguments) {
                if (!world.func_72899_e(x, y, z)) {
                    return null;
                }
                TileEntity te = world.func_72796_p(x, y, z);
                if (!(te instanceof IEnergyTile)) {
                    return null;
                }
                long measurePeriod = data.func_74763_f("lastMeasureTime");
                EnergyNet enet = EnergyNet.getForWorld((World)world);
                long emitted = enet.getTotalEnergyEmitted(te);
                long sunken = enet.getTotalEnergySunken(te);
                double deltaEmitted = (double)(emitted - data.func_74763_f("lastTotalEnergyEmitted")) / (double)measurePeriod;
                double deltaSunken = (double)(sunken - data.func_74763_f("lastTotalEnergySunken")) / (double)measurePeriod;
                data.func_74772_a("lastTotalEnergyEmitted", enet.getTotalEnergyEmitted(te));
                data.func_74772_a("lastTotalEnergySunken", enet.getTotalEnergySunken(te));
                data.func_74772_a("lastMeasureTime", world.func_82737_E());
                HashMap<String, Number> ret = new HashMap<String, Number>();
                ret.put("total", emitted + sunken - data.func_74763_f("firstTotalEnergy"));
                ret.put("pass", deltaEmitted + deltaSunken);
                ret.put("in", deltaSunken);
                ret.put("out", deltaEmitted);
                return ret;
            }
        });
        MiscPeripheralsAPI.instance.addFurnaceXP(Reflector.getClass("ic2.core.block.machine.tileentity.TileEntityElecFurnace"), 2);
        MiscPeripheralsAPI.instance.addFurnaceXP(Reflector.getClass("ic2.core.block.machine.tileentity.TileEntityInduction"), 3, 4);
        ItemStack uranium = Items.getItem((String)"reactorUraniumSimple");
        if (uranium != null && uranium.func_77973_b() != null) {
            int euOutput = IC2Reactor.getEUOutput();
            PeripheralRTG.URANIUM_TOTAL = uranium.func_77958_k() * PeripheralRTG.OUTPUT * euOutput * 20;
        } else {
            MiscPeripherals.log.warning("!!! IC2 URANIUM IS NULL !!! GregTech?");
        }
        OreDictionary.registerOre((String)"MiscPeripherals$rtgChamber", (ItemStack)Items.getItem((String)"reactorChamber"));
        OreDictionary.registerOre((String)"MiscPeripherals$rtgGenerator", (ItemStack)Items.getItem((String)"generator"));
        OreDictionary.registerOre((String)"MiscPeripherals$rtgCircuit", (ItemStack)Items.getItem((String)"advancedCircuit"));
        OreDictionary.registerOre((String)"MiscPeripherals$energyMeter", (ItemStack)Items.getItem((String)"ecMeter"));
    }

    @Override
    public void handleNetworkMessage(NetHandler source, boolean isClient, ByteArrayDataInput data) {
    }
}

