/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.module;

import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import forestry.api.core.ItemInterface;
import forestry.api.recipes.RecipeManagers;
import forestry.api.storage.BackpackManager;
import forestry.api.storage.EnumBackpackType;
import forestry.api.storage.IBackpackDefinition;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import miscperipherals.core.MiscPeripherals;
import miscperipherals.core.Module;
import miscperipherals.tile.TileBeeAnalyzer;
import miscperipherals.tile.TileButterflyAnalyzer;
import miscperipherals.tile.TileTreeAnalyzer;
import miscperipherals.upgrade.UpgradeGrafter;
import miscperipherals.upgrade.UpgradeScoop;
import miscperipherals.util.Util;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.network.packet.NetHandler;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ModuleForestry
extends Module {
    public static Item backpack;
    public static Item backpackT2;
    public static boolean enableBeeAnalyzer;
    public static boolean enableTreeAnalyzer;
    public static boolean enableButterflyAnalyzer;
    public static boolean enableBackpacks;
    public static boolean enableGrafter;
    public static boolean enableScoop;
    private int backpackID;
    private int backpackT2ID;

    @Override
    public void onPreInit() {
        enableBeeAnalyzer = MiscPeripherals.instance.settings.get("features", "enableBeeAnalyzer", enableBeeAnalyzer, "Enable the Bee Analyzer peripheral").getBoolean(enableBeeAnalyzer);
        enableTreeAnalyzer = MiscPeripherals.instance.settings.get("features", "enableTreeAnalyzer", enableTreeAnalyzer, "Enable the Tree Analyzer peripheral").getBoolean(enableTreeAnalyzer);
        enableButterflyAnalyzer = MiscPeripherals.instance.settings.get("features", "enableButterflyAnalyzer", enableButterflyAnalyzer, "Enable the Butterfly Analyzer peripheral").getBoolean(enableButterflyAnalyzer);
        enableBackpacks = MiscPeripherals.instance.settings.get("features", "enableBackpacks", enableBackpacks, "Enable the Computer Engineer's Backpacks").getBoolean(enableBackpacks);
        enableGrafter = MiscPeripherals.instance.settings.get("features", "enableGrafter", enableGrafter, "Enable the Grafter turtle upgrade").getBoolean(enableGrafter);
        enableScoop = MiscPeripherals.instance.settings.get("features", "enableScoop", enableScoop, "Enable the Scoop turtle upgrade").getBoolean(enableScoop);
        this.backpackID = MiscPeripherals.instance.settings.getItem("backpack", 26455, "ID for the Computer Engineer's Backpack").getInt();
        this.backpackT2ID = MiscPeripherals.instance.settings.getItem("backpackT2", 26456, "ID for the Woven Computer Engineer's Backpack").getInt();
    }

    @Override
    public void onInit() {
        LanguageRegistry lang = LanguageRegistry.instance();
        if (enableBeeAnalyzer) {
            MiscPeripherals.instance.blockAlpha.registerTile(4).setClass(TileBeeAnalyzer.class).setSprites("analyzer_bee").setName("beeAnalyzer").setInfoText(MiscPeripherals.instance.descriptive ? "This block is computer powered!" : null);
            GameRegistry.registerTileEntity(TileBeeAnalyzer.class, (String)"MiscPeripherals Bee Analyzer");
            lang.addStringLocalization("miscperipherals.beeAnalyzer.name", "Bee Analyzer");
            GameRegistry.registerCustomItemStack((String)"beeAnalyzer", (ItemStack)new ItemStack((Block)MiscPeripherals.instance.blockAlpha, 1, 4));
        }
        if (enableTreeAnalyzer) {
            MiscPeripherals.instance.blockAlpha.registerTile(11).setClass(TileTreeAnalyzer.class).setSprites("analyzer_tree").setName("treeAnalyzer").setInfoText(MiscPeripherals.instance.descriptive ? "This block is computer powered!" : null);
            GameRegistry.registerTileEntity(TileTreeAnalyzer.class, (String)"MiscPeripherals Tree Analyzer");
            lang.addStringLocalization("miscperipherals.treeAnalyzer.name", "Tree Analyzer");
            GameRegistry.registerCustomItemStack((String)"treeAnalyzer", (ItemStack)new ItemStack((Block)MiscPeripherals.instance.blockAlpha, 1, 11));
        }
        if (enableButterflyAnalyzer) {
            MiscPeripherals.instance.blockBeta.registerTile(9).setClass(TileButterflyAnalyzer.class).setSprites("analyzer_butterfly").setName("butterflyAnalyzer").setInfoText(MiscPeripherals.instance.descriptive ? "This block is computer powered!" : null);
            GameRegistry.registerTileEntity(TileButterflyAnalyzer.class, (String)"MiscPeripherals Butterfly Analyzer");
            lang.addStringLocalization("miscperipherals.butterflyAnalyzer.name", "Butterfly Analyzer");
            GameRegistry.registerCustomItemStack((String)"butterflyAnalyzer", (ItemStack)new ItemStack((Block)MiscPeripherals.instance.blockBeta, 1, 9));
        }
    }

    @Override
    public void onPostInit() {
        if (enableBeeAnalyzer) {
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)MiscPeripherals.instance.blockAlpha, 1, 4), (Object[])new Object[]{"GRG", "R@R", "GRG", Character.valueOf('G'), Item.field_77717_p, Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('@'), ItemInterface.getItem((String)"beealyzer")});
        }
        if (enableTreeAnalyzer) {
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)MiscPeripherals.instance.blockAlpha, 1, 11), (Object[])new Object[]{"GRG", "R@R", "GRG", Character.valueOf('G'), Item.field_77717_p, Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('@'), ItemInterface.getItem((String)"treealyzer")});
        }
        if (enableButterflyAnalyzer) {
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)MiscPeripherals.instance.blockBeta, 1, 9), (Object[])new Object[]{"GRG", "R@R", "GRG", Character.valueOf('G'), Item.field_77717_p, Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('@'), ItemInterface.getItem((String)"flutterlyzer")});
        }
        if (enableBackpacks) {
            ComputerBackpackDefinition def = new ComputerBackpackDefinition();
            backpack = BackpackManager.backpackInterface.addBackpack(this.backpackID, (IBackpackDefinition)def, EnumBackpackType.T1).func_77637_a(MiscPeripherals.instance.tabMiscPeripherals);
            GameRegistry.registerCustomItemStack((String)"backpack", (ItemStack)new ItemStack(backpack, 1, 0));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(backpack), new Object[]{"SWS", "D@D", "SWS", Character.valueOf('S'), Item.field_77683_K, Character.valueOf('W'), new ItemStack(Block.field_72101_ab, 1, Short.MAX_VALUE), Character.valueOf('@'), Block.field_72077_au, Character.valueOf('D'), "MiscPeripherals$disk"}));
            backpackT2 = BackpackManager.backpackInterface.addBackpack(this.backpackT2ID, (IBackpackDefinition)def, EnumBackpackType.T2).func_77637_a(MiscPeripherals.instance.tabMiscPeripherals);
            GameRegistry.registerCustomItemStack((String)"backpackT2", (ItemStack)new ItemStack(backpackT2, 1, 0));
            ItemStack wovenSilk = ItemInterface.getItem((String)"craftingMaterial");
            if (wovenSilk != null) {
                wovenSilk.func_77964_b(3);
                RecipeManagers.carpenterManager.addRecipe(200, new LiquidStack(Block.field_71943_B.field_71990_ca, 1000), null, new ItemStack(backpackT2), new Object[]{"SDS", "S@S", "SSS", Character.valueOf('D'), Item.field_77702_n, Character.valueOf('@'), backpack, Character.valueOf('S'), wovenSilk});
            }
        }
        if (enableGrafter) {
            MiscPeripherals.registerUpgrade(new UpgradeGrafter());
        }
        if (enableScoop) {
            MiscPeripherals.registerUpgrade(new UpgradeScoop());
        }
        UpgradeGrafter.registerGrafter(ItemInterface.getItem((String)"grafter"));
        UpgradeGrafter.registerGrafter(ItemInterface.getItem((String)"grafterProven"));
        UpgradeScoop.registerScoop(ItemInterface.getItem((String)"scoop"));
    }

    @Override
    public void handleNetworkMessage(NetHandler source, boolean isClient, ByteArrayDataInput data) {
    }

    static {
        enableBeeAnalyzer = true;
        enableTreeAnalyzer = true;
        enableButterflyAnalyzer = true;
        enableBackpacks = true;
        enableGrafter = true;
        enableScoop = true;
    }

    public static class ComputerBackpackDefinition
    implements IBackpackDefinition {
        private final List items;

        public ComputerBackpackDefinition() {
            this.items = new LinkedList<ItemStack>(Arrays.asList(new ItemStack((Block)MiscPeripherals.instance.blockAlpha, 1, Short.MAX_VALUE), new ItemStack((Block)MiscPeripherals.instance.blockBeta, 1, Short.MAX_VALUE), new ItemStack((Item)MiscPeripherals.instance.itemAlpha, 1, Short.MAX_VALUE), new ItemStack((Item)MiscPeripherals.instance.itemSmartHelmet, 1, Short.MAX_VALUE)));
            this.addCCItem("ComputerCraft", "CC-Computer");
            this.addCCItem("ComputerCraft", "CC-Peripheral");
            this.addCCItem("ComputerCraft", "CC-Cable");
            this.addCCItem("CCTurtle", "CC-Turtle");
            this.addCCItem("CCTurtle", "CC-TurtleExpanded");
        }

        public String getKey() {
            return "computer";
        }

        public String getName() {
            return "Computer Engineer's Backpack";
        }

        public int getPrimaryColour() {
            return 0xC0C0C0;
        }

        public int getSecondaryColour() {
            return 0xFFFFFF;
        }

        public void addValidItem(ItemStack validItem) {
            this.items.add(validItem);
        }

        public Collection getValidItems(EntityPlayer player) {
            return this.items;
        }

        public boolean isValidItem(EntityPlayer player, ItemStack itemstack) {
            for (ItemStack entry : this.items) {
                if (!Util.areStacksEqual(entry, itemstack)) continue;
                return true;
            }
            return false;
        }

        private void addCCItem(String mod, String name) {
            ItemStack stack = GameRegistry.findItemStack((String)mod, (String)name, (int)1);
            if (stack != null) {
                stack.func_77964_b(Short.MAX_VALUE);
                this.items.add(stack);
            }
        }
    }
}

