/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.external;

import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IHostedPeripheral;
import miscperipherals.core.LuaManager;
import miscperipherals.safe.Reflector;
import miscperipherals.util.Util;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import thermalexpansion.api.tileentity.ITesseract;

public class ExtTesseract
implements IHostedPeripheral {
    private final ITesseract tesseract;

    public ExtTesseract(TileEntity tesseract) {
        this.tesseract = (ITesseract)tesseract;
    }

    public String getType() {
        return "tesseract";
    }

    public String[] getMethodNames() {
        return new String[]{"getFrequency", "getFreq", "setFrequency", "setFreq", "getType", "getOwner", "getMode"};
    }

    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: 
            case 1: {
                return new Object[]{((Byte)Reflector.getField(this.tesseract, "access", Byte.class)).equals(0) ? (Integer)Reflector.getField(this.tesseract, "frequency", Integer.class) : null};
            }
            case 2: 
            case 3: {
                if (arguments.length < 1) {
                    throw new Exception("too few arguments");
                }
                if (!(arguments[0] instanceof Double)) {
                    throw new Exception("bad argument #1 (expected number)");
                }
                int freq = (int)Math.floor((Double)arguments[0]);
                if (freq < -1 || freq > 999) {
                    throw new Exception("bad frequency " + freq + " (expected -1..999)");
                }
                if (!((Byte)Reflector.getField(this.tesseract, "access", Byte.class)).equals(0)) {
                    return new Object[]{false};
                }
                Reflector.setField(this.tesseract, "frequency", freq);
                return new Object[]{true};
            }
            case 4: {
                return new Object[]{Util.camelCase(((String)Reflector.getField(this.tesseract, "type", String.class)).replace('_', ' '))};
            }
            case 5: {
                return new Object[]{Reflector.getField(this.tesseract, "owner", String.class)};
            }
            case 6: {
                Object[] objectArray;
                if (((Byte)Reflector.getField(this.tesseract, "access", Byte.class)).equals(0)) {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = Reflector.getField(this.tesseract, "mode", Byte.class);
                } else {
                    objectArray = new Object[]{};
                }
                return objectArray;
            }
        }
        return new Object[0];
    }

    public boolean canAttachToSide(int side) {
        return true;
    }

    public void attach(IComputerAccess computer) {
        LuaManager.mount(computer);
    }

    public void detach(IComputerAccess computer) {
    }

    public void update() {
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
    }
}

