/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.external;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IHostedPeripheral;
import miscperipherals.core.LuaManager;
import miscperipherals.module.ModulePortalGun;
import miscperipherals.safe.Reflector;
import miscperipherals.util.Util;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class ExtPortalSpawner
implements IHostedPeripheral {
    private static final BiMap GUNS = HashBiMap.create();
    private final TileEntity spawner;

    public ExtPortalSpawner(TileEntity spawner) {
        this.spawner = spawner;
    }

    public String getType() {
        return "portalSpawner";
    }

    public String[] getMethodNames() {
        return new String[]{"setGun", "setColor", "getPortal", "setPowered", "getPowered"};
    }

    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                if (arguments.length < 1) {
                    throw new Exception("too few arguments");
                }
                if (!(arguments[0] instanceof String)) {
                    throw new Exception("bad argument #1 (expected string)");
                }
                String gun = ((String)arguments[0]).toLowerCase();
                if (!GUNS.containsKey((Object)gun)) {
                    throw new Exception("unknown gun " + gun + " (expected " + Util.join("/", GUNS.keySet()) + ")");
                }
                ModulePortalGun.setValueWithPair(this.spawner, "spOwner", GUNS.get((Object)gun));
                return this.callMethod(computer, 2, arguments);
            }
            case 1: {
                if (arguments.length < 1) {
                    throw new Exception("too few arguments");
                }
                if (!(arguments[0] instanceof Boolean)) {
                    throw new Exception("bad argument #1 (expected boolean)");
                }
                boolean secondary = (Boolean)arguments[0];
                ModulePortalGun.setValueWithPair(this.spawner, "spColour", secondary ? 2 : 1, "spPair");
                return this.callMethod(computer, 2, arguments);
            }
            case 2: {
                return new Object[]{GUNS.inverse().get(Reflector.getField(this.spawner, "spOwner", Object.class)), (Integer)Reflector.getField(this.spawner, "spColour", Integer.class) == 2};
            }
            case 3: {
                if (arguments.length < 1) {
                    throw new Exception("too few arguments");
                }
                if (!(arguments[0] instanceof Boolean)) {
                    throw new Exception("bad argument #1 (expected boolean)");
                }
                boolean powered = (Boolean)arguments[0];
                ModulePortalGun.setValueWithPair(this.spawner, "spawnerPowered", powered, "spPair");
                return new Object[0];
            }
            case 4: {
                return new Object[]{Reflector.getField(this.spawner, "spawnerPowered", Object.class)};
            }
        }
        return new Object[0];
    }

    public boolean canAttachToSide(int side) {
        return true;
    }

    public void attach(IComputerAccess computer) {
        LuaManager.mount(computer);
    }

    public void detach(IComputerAccess computer) {
    }

    public void update() {
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
    }

    static {
        GUNS.put((Object)"normal", (Object)"def");
        GUNS.put((Object)"atlas", (Object)"coopA");
        GUNS.put((Object)"pbody", (Object)"coopB");
        GUNS.put((Object)"bacon", (Object)"_A");
        GUNS.put((Object)"potato", (Object)"_B");
    }
}

