/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.core;

import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import miscperipherals.core.MiscPeripherals;
import net.minecraft.world.World;

public class TickHandler
implements ITickHandler {
    private static Map callbacks = Collections.synchronizedMap(new HashMap());

    public void tickStart(EnumSet type, Object ... tickData) {
        if (type.contains(TickType.WORLD)) {
            World world = (World)tickData[0];
            if (callbacks.containsKey(world.field_73011_w.field_76574_g)) {
                Queue callbackList = (Queue)callbacks.get(world.field_73011_w.field_76574_g);
                FutureTask callback = (FutureTask)callbackList.poll();
                while (callback != null) {
                    callback.run();
                    callback = (FutureTask)callbackList.poll();
                }
            }
        }
    }

    public void tickEnd(EnumSet type, Object ... tickData) {
    }

    public EnumSet ticks() {
        return EnumSet.of(TickType.WORLD);
    }

    public String getLabel() {
        return "MiscPeripherals";
    }

    public static Future addTickCallback(World world, Callable callback) throws InterruptedException {
        if (!callbacks.containsKey(world.field_73011_w.field_76574_g)) {
            callbacks.put(world.field_73011_w.field_76574_g, new LinkedBlockingQueue());
        }
        FutureTask task = new FutureTask(callback){

            @Override
            protected void done() {
                try {
                    if (!this.isCancelled()) {
                        this.get();
                    }
                }
                catch (Throwable e) {
                    MiscPeripherals.log.warning("Exception while executing tick callback! " + this);
                    e.printStackTrace();
                }
            }
        };
        ((LinkedBlockingQueue)callbacks.get(world.field_73011_w.field_76574_g)).put(task);
        return task;
    }
}

