/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.core;

import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLFingerprintViolationEvent;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.VersionParser;
import cpw.mods.fml.relauncher.RelaunchClassLoader;
import cpw.mods.fml.relauncher.Side;
import dan200.turtle.api.ITurtleUpgrade;
import dan200.turtle.api.TurtleAPI;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import miscperipherals.api.MiscPeripheralsAPI;
import miscperipherals.block.BlockLanCable;
import miscperipherals.block.BlockMultiTile;
import miscperipherals.block.ItemBlockMultiTile;
import miscperipherals.core.APICallHandler;
import miscperipherals.core.ChunkLoadingCallback;
import miscperipherals.core.CreativeTabMiscPeripherals;
import miscperipherals.core.EventHandler;
import miscperipherals.core.LuaManager;
import miscperipherals.core.Module;
import miscperipherals.core.Proxy;
import miscperipherals.core.TickHandler;
import miscperipherals.item.ItemMulti;
import miscperipherals.item.ItemSmartHelmet;
import miscperipherals.network.GuiHandler;
import miscperipherals.network.TinyPacketHandler;
import miscperipherals.render.Icons;
import miscperipherals.tile.TileAccelerator;
import miscperipherals.tile.TileChargeStation;
import miscperipherals.tile.TileChargeStationT2;
import miscperipherals.tile.TileChargeStationT3;
import miscperipherals.tile.TileChargeStationT4;
import miscperipherals.tile.TileChatBox;
import miscperipherals.tile.TileCrafter;
import miscperipherals.tile.TileEnergyMeter;
import miscperipherals.tile.TileFireworks;
import miscperipherals.tile.TileInteractiveSorter;
import miscperipherals.tile.TileNote;
import miscperipherals.tile.TilePlayerDetector;
import miscperipherals.tile.TileRailReader;
import miscperipherals.tile.TileResupplyStation;
import miscperipherals.tile.TileSmSender;
import miscperipherals.tile.TileSpeaker;
import miscperipherals.tile.TileTeleporter;
import miscperipherals.tile.TileTeleporterT2;
import miscperipherals.upgrade.UpgradeAccelerator;
import miscperipherals.upgrade.UpgradeAnvil;
import miscperipherals.upgrade.UpgradeChatBox;
import miscperipherals.upgrade.UpgradeChest;
import miscperipherals.upgrade.UpgradeChunkLoader;
import miscperipherals.upgrade.UpgradeCompass;
import miscperipherals.upgrade.UpgradeEnergyMeter;
import miscperipherals.upgrade.UpgradeFeeder;
import miscperipherals.upgrade.UpgradeFireworks;
import miscperipherals.upgrade.UpgradeInventory;
import miscperipherals.upgrade.UpgradeNote;
import miscperipherals.upgrade.UpgradeRTG;
import miscperipherals.upgrade.UpgradeResupply;
import miscperipherals.upgrade.UpgradeShears;
import miscperipherals.upgrade.UpgradeSignReader;
import miscperipherals.upgrade.UpgradeSpeaker;
import miscperipherals.upgrade.UpgradeTank;
import miscperipherals.upgrade.UpgradeXP;
import miscperipherals.util.CCItems;
import miscperipherals.util.ShapedRecipesExt;
import miscperipherals.util.SmallNetHelper;
import miscperipherals.util.Util;
import net.minecraft.block.Block;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumMovingObjectType;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

@Mod(modid="MiscPeripherals", name="MiscPeripherals", version="3.3", dependencies="required-after:ComputerCraft;required-after:CCTurtle;after:GregTech_Addon")
@NetworkMod(clientSideRequired=true, tinyPacketHandler=TinyPacketHandler.class)
public class MiscPeripherals {
    @Mod.Instance(value="MiscPeripherals")
    public static MiscPeripherals instance;
    @SidedProxy(clientSide="miscperipherals.core.ProxyClient", serverSide="miscperipherals.core.Proxy")
    public static Proxy proxy;
    @SidedProxy(clientSide="miscperipherals.network.GuiHandlerClient", serverSide="miscperipherals.network.GuiHandler")
    public static GuiHandler guiHandler;
    public static Logger log;
    public static String ccVersion;
    public Configuration settings;
    public CreativeTabs tabMiscPeripherals = new CreativeTabMiscPeripherals();
    public Map modules = new HashMap();
    public BlockMultiTile blockAlpha;
    public BlockMultiTile blockBeta;
    public BlockLanCable blockLanCable;
    public ItemMulti itemAlpha;
    public ItemSmartHelmet itemSmartHelmet;
    public boolean enableChargeStation = true;
    public boolean enableChargeStationT2 = true;
    public boolean enableChargeStationT3 = true;
    public boolean enableChargeStationT4 = true;
    public boolean enableNote = true;
    public boolean enableChunkLoader = true;
    public boolean enableFeeder = true;
    public boolean enableResupply = true;
    public boolean enableShears = true;
    public boolean enableCompass = true;
    public boolean enableXP = true;
    public boolean enableInventory = true;
    public boolean enableInteractiveSorter = true;
    public boolean enableSignReader = true;
    public boolean enableRailReader = true;
    public boolean enableRTG = true;
    public boolean enableTank = true;
    public boolean enableTeleporter = true;
    public boolean enableTeleporterT2 = true;
    public boolean enablePlayerDetector = true;
    public boolean enableCrafter = true;
    public boolean enableAccelerator = true;
    public boolean enableFireworkLauncher = true;
    public boolean enableChatBox = true;
    public boolean enableSpeaker = true;
    public boolean enableChest = true;
    public boolean enableSmSender = true;
    public boolean enableEnergyMeter = true;
    public int fuelMJ = 20;
    public int fuelEU = 50;
    public int itemIDSeed = 0;
    public boolean sideSensitive = false;
    public int chunkLoaderRadius = 0;
    public double teleporterPenalty = 2.0;
    public boolean descriptive = false;
    public boolean chargeStationMultiCharge = true;
    public String speechProvider = "";
    public int chatSayRange = 64;
    public boolean chatSayUnlimitedVertical = true;
    public int chatSayRate = 1;
    public double chatReadRange = -1.0;
    public boolean chatColorCodes = false;
    public boolean chatLogCoords = true;
    public static final boolean DEBUG = false;

    public MiscPeripherals() {
        instance = this;
    }

    @Mod.PreInit
    public void onLoad(FMLPreInitializationEvent event) {
        log = event.getModLog();
        ModContainer cc = (ModContainer)Loader.instance().getIndexedModList().get("ComputerCraft");
        if (cc != null) {
            ccVersion = cc.getDisplayVersion();
        }
        ((RelaunchClassLoader)this.getClass().getClassLoader()).registerTransformer("miscperipherals.asm.ImplementIfLoadedTransformer");
        new EventHandler();
        MiscPeripheralsAPI.instance = new APICallHandler();
        LanguageRegistry lang = LanguageRegistry.instance();
        this.settings = new Configuration(new File(new File(proxy.getMinecraftFolder(), "config"), "MiscPeripherals.cfg"));
        int blockAlphaId = this.settings.getBlock("alpha", 2671, "ID for the first block").getInt();
        int blockBetaId = this.settings.getBlock("beta", blockAlphaId + 1, "ID for the second block").getInt();
        int itemAlphaId = this.settings.getItem("alpha", 26454, "ID for the first item").getInt();
        int itemSmartHelmetId = this.settings.getItem("smartHelmet", itemAlphaId + 3, "ID for the Smart Helmet item (set to 0 to disable)").getInt();
        this.enableChargeStation = this.settings.get("features", "enableChargeStation", this.enableChargeStation, "Enable the Charge Station block").getBoolean(this.enableChargeStation);
        this.enableChargeStationT2 = this.settings.get("features", "enableChargeStationT2", this.enableChargeStationT2, "Enable the Advanced Charge Station").getBoolean(this.enableChargeStationT2);
        this.enableChargeStationT3 = this.settings.get("features", "enableChargeStationT3", this.enableChargeStationT3, "Enable the Lapotronic Charge Station").getBoolean(this.enableChargeStationT3);
        this.enableChargeStationT4 = this.settings.get("features", "enableChargeStationT4", this.enableChargeStationT4, "Enable the Ultimate Charge Station").getBoolean(this.enableChargeStationT4);
        this.enableNote = this.settings.get("features", "enableNote", this.enableNote, "Enable the Iron Note Block peripheral and turtle upgrade").getBoolean(this.enableNote);
        this.enableChunkLoader = this.settings.get("features", "enableChunkLoader", this.enableNote, "Enable the Chunk Loader turtle upgrade").getBoolean(this.enableChunkLoader);
        this.enableFeeder = this.settings.get("features", "enableFeeder", this.enableFeeder, "Enable the Feeder turtle upgrade").getBoolean(this.enableFeeder);
        this.enableResupply = this.settings.get("features", "enableResupply", this.enableResupply, "Enable the Resupply Station and Resupply turtle upgrade").getBoolean(this.enableResupply);
        this.enableShears = this.settings.get("features", "enableShears", this.enableShears, "Enable the Shears turtle upgrade").getBoolean(this.enableShears);
        this.enableCompass = this.settings.get("features", "enableCompass", this.enableCompass, "Enable the Compass turtle upgrade").getBoolean(this.enableCompass);
        this.enableXP = this.settings.get("features", "enableXP", this.enableXP, "Enable the XP and Anvil turtle upgrades").getBoolean(this.enableXP);
        this.enableInventory = this.settings.get("features", "enableInventory", this.enableInventory, "Enable the Inventory turtle upgrade").getBoolean(this.enableInventory);
        this.enableInteractiveSorter = this.settings.get("features", "enableInteractiveSorter", this.enableInteractiveSorter, "Enable the Interactive Sorter peripheral").getBoolean(this.enableInteractiveSorter);
        this.enableSignReader = this.settings.get("features", "enableSignReader", this.enableSignReader, "Enable the Sign Reader turtle upgrade").getBoolean(this.enableSignReader);
        this.enableRailReader = this.settings.get("features", "enableRailReader", this.enableRailReader, "Enable the Rail Reader peripheral").getBoolean(this.enableRailReader);
        this.enableTank = this.settings.get("features", "enableTank", this.enableTank, "Enable the Tank turtle upgrade").getBoolean(this.enableTank);
        this.enableRTG = this.settings.get("features", "enableRTG", this.enableRTG, "Enable the RTG turtle upgrade").getBoolean(this.enableRTG);
        this.enableTeleporter = this.settings.get("features", "enableTeleporter", this.enableTeleporter, "Enable the Turtle Teleporter").getBoolean(this.enableTeleporter);
        this.enableTeleporterT2 = this.settings.get("features", "enableTeleporterT2", this.enableTeleporterT2, "Enable the Advanced Turtle Teleporter").getBoolean(this.enableTeleporterT2);
        this.enablePlayerDetector = this.settings.get("features", "enablePlayerDetector", this.enablePlayerDetector, "Enable the Player Detector peripheral").getBoolean(this.enablePlayerDetector);
        this.enableCrafter = this.settings.get("features", "enableCrafter", this.enableCrafter, "Enable the Computer Controlled Crafter peripheral").getBoolean(this.enableCrafter);
        this.enableAccelerator = this.settings.get("features", "enableAccelerator", this.enableAccelerator, "Enable the Hardware Accelerator peripheral").getBoolean(this.enableAccelerator);
        this.enableFireworkLauncher = this.settings.get("features", "enableFireworkLauncher", this.enableFireworkLauncher, "Enable the Firework Launcher peripheral").getBoolean(this.enableFireworkLauncher);
        this.enableChatBox = this.settings.get("features", "enableChatBox", this.enableChatBox, "Enable the Chat Box peripheral and turtle upgrade").getBoolean(this.enableChatBox);
        this.enableSpeaker = this.settings.get("features", "enableSpeaker", this.enableSpeaker, "Enable the Speaker peripheral and turtle upgrade").getBoolean(this.enableSpeaker);
        this.enableChest = this.settings.get("features", "enableChest", this.enableChest, "Enable the Chest turtle upgrade").getBoolean(this.enableChest);
        this.enableSmSender = this.settings.get("features", "enableSmSender", this.enableSmSender, "Enable the Smallnet Sender peripheral").getBoolean(this.enableSmSender);
        this.enableEnergyMeter = this.settings.get("features", "enableEnergyMeter", this.enableEnergyMeter, "Enable the Energy Meter peripheral and turtle upgrade").getBoolean(this.enableEnergyMeter);
        this.fuelEU = this.settings.get("general", "fuelEU", this.fuelEU, "Amount of EU per turtle fuel value. Coal burned in a generator gives 50 EU per fuel value").getInt();
        this.fuelMJ = this.settings.get("general", "fuelMJ", this.fuelMJ, "Amount of MJ per turtle fuel value. Coal burned in a stirling engine gives 20 MJ per fuel value").getInt();
        String seed = this.settings.get("general", "itemIDSeed", "", "Seed used to encode item IDs given by peripherals, works similarly to a regular map seed. Item IDs are not encoded if empty").getString().trim();
        if (seed.isEmpty()) {
            this.itemIDSeed = 0;
        } else {
            try {
                this.itemIDSeed = Integer.parseInt(seed);
            }
            catch (NumberFormatException e) {
                this.itemIDSeed = seed.hashCode();
            }
        }
        this.sideSensitive = this.settings.get("general", "sideSensitive", this.sideSensitive, "EXPERIMENTAL: If set to true, some turtle upgrades get more picky about the side they are placed on, for example, Solar Turtles needing the block the solar panel is facing to see the sun, instead of the turtle itself").getBoolean(this.sideSensitive);
        this.chunkLoaderRadius = this.settings.get("general", "chunkLoaderRadius", this.chunkLoaderRadius, "Radius of chunks the Chunk Loader peripheral will keep loaded. 0 for 1x1, 1 for 3x3, 2 for 5x5, etc. The maximum allowed by the default chunkloading settings is 5x5, edit config/forgeChunkLoading.cfg to change those.").getInt();
        this.teleporterPenalty = this.settings.get("general", "teleporterPenalty", this.teleporterPenalty, "Fuel penalty for using a Turtle Teleporter. For example, 1.0 is a 0% penalty, or 2.0 (default) is a 100% penalty").getDouble(this.teleporterPenalty);
        this.descriptive = this.settings.get("general", "descriptive", this.descriptive, "Make stuff a little bit more descriptive, prevents confusion").getBoolean(this.descriptive);
        this.chargeStationMultiCharge = this.settings.get("general", "chargeStationMultiCharge", this.chargeStationMultiCharge, "Allow advanced charge stations to charge multiple turtles").getBoolean(this.chargeStationMultiCharge);
        this.speechProvider = this.settings.get("general", "speechProvider", this.speechProvider, "Preferred speech provider for the Speaker peripheral, leave blank for automatic. Supported: windows osx espeak festival pico2wave").getString().trim();
        this.chatSayRange = this.settings.get("chatBox", "sayRange", this.chatSayRange, "Range for the Chat Box peripheral's say function. Negative values indicate infinite, always infinite on singleplayer").getInt();
        this.chatReadRange = this.settings.get("chatBox", "readRange", this.chatReadRange, "Range for the Chat Box peripheral's reading. Negative values indicate infinite, always infinite on singleplayer").getInt();
        this.chatColorCodes = this.settings.get("chatBox", "colorCodes", this.chatColorCodes, "Enable color codes on the Chat Box peripheral's say function").getBoolean(this.chatColorCodes);
        this.chatSayUnlimitedVertical = this.settings.get("chatBox", "sayUnlimitedVertical", this.chatSayUnlimitedVertical, "Allow the Chat Box peripheral to send messages with unlimited vertical distance, but only if so the program chooses").getBoolean(this.chatColorCodes);
        this.chatSayRate = this.settings.get("chatBox", "sayRate", this.chatSayRate, "Maximum number of messages per second a Chat Box peripheral can say").getInt();
        this.chatLogCoords = this.settings.get("chatBox", "logCoords", this.chatLogCoords, "Log the Chat Box peripheral's coordinates when it says a message").getBoolean(this.chatLogCoords);
        this.settings.save();
        this.blockAlpha = new BlockMultiTile(blockAlphaId);
        GameRegistry.registerBlock((Block)this.blockAlpha, ItemBlockMultiTile.class, (String)"miscperipherals.blockAlpha");
        this.blockBeta = new BlockMultiTile(blockBetaId);
        GameRegistry.registerBlock((Block)this.blockBeta, ItemBlockMultiTile.class, (String)"miscperipherals.blockBeta");
        this.itemAlpha = new ItemMulti(itemAlphaId);
        GameRegistry.registerItem((Item)this.itemAlpha, (String)"miscperipherals.itemAlpha");
        if (itemSmartHelmetId > 0) {
            this.itemSmartHelmet = new ItemSmartHelmet(itemSmartHelmetId);
            GameRegistry.registerItem((Item)this.itemSmartHelmet, (String)"miscperipherals.itemSmartHelmet");
        }
        this.loadModule("MiscPeripheralsASM", "ASM");
        this.loadModule("IC2@[1.112,)", "IC2");
        this.loadModule("IC2NuclearControl", "NuclearControl");
        this.loadModule("ModularForceFieldSystem@[2.0.0.0.0,3.0.0)", "MFFS");
        this.loadModule("GregTech_Addon", "GregTech");
        this.loadModule("AdvancedSolarPanel", "AdvancedSolarPanel");
        this.loadModule("CompactSolars", "CompactSolars");
        this.loadModule("Forestry@[2.2.4.0,)", "Forestry");
        this.loadModule("AdditionalPipes", "AdditionalPipes");
        this.loadModule("APUnofficial", "APUnofficial");
        this.loadModule("Railcraft", "Railcraft");
        this.loadModule("StevesCarts", "StevesCarts");
        this.loadModule("ChickenChunks", "ChickenChunks");
        this.loadModule("BuildCraft|Core", "BuildCraftCore");
        this.loadModule("BuildCraft|Factory", "BuildCraftFactory");
        this.loadModule("BuildCraft|Transport", "BuildCraftTransport");
        this.loadModule("EnderStorage", "EnderStorage");
        this.loadModule("EE3", "EE3");
        this.loadModule("WR-CBE|Core", "WRCBE");
        this.loadModule("factorization", "Factorization");
        this.loadModule("Thaumcraft", "Thaumcraft");
        this.loadModule("ThermalExpansion", "ThermalExpansion");
        this.loadModule("PortalGun", "PortalGun");
        this.loadModule("AppliedEnergistics", "AppEng");
        this.loadModule("OmniTools", "OmniTools");
        this.loadModule("MultiPageChest", "MultiPageChest");
        this.loadModule("TConstruct", "TConstruct");
        for (Module module : this.modules.values()) {
            module.onPreInit();
        }
    }

    @Mod.Init
    public void onLoading(FMLInitializationEvent event) {
        BlockMultiTile.TileData data;
        LanguageRegistry lang = LanguageRegistry.instance();
        if (Loader.isModLoaded((String)new String(new byte[]{71, 114, 101, 103, 84, 101, 99, 104, 95, 65, 100, 100, 111, 110}))) {
            this.itemAlpha.registerItem(1337, new String(new byte[]{103, 114, 101, 103, 111, 114, 105, 117, 109}), new String(new byte[]{103, 114, 101, 103, 111, 114, 105, 117, 109}));
            LanguageRegistry.instance().addStringLocalization(new String(new byte[]{109, 105, 115, 99, 112, 101, 114, 105, 112, 104, 101, 114, 97, 108, 115, 46, 103, 114, 101, 103, 111, 114, 105, 117, 109, 46, 110, 97, 109, 101}), new String(new byte[]{71, 114, 101, 103, 111, 114, 105, 117, 109, 32, 73, 110, 103, 111, 116}));
            GameRegistry.addRecipe((IRecipe)new ShapedRecipesExt(3, 3, new ItemStack[]{new ItemStack(Item.field_77703_o), new ItemStack(Item.field_77703_o), new ItemStack(Item.field_77703_o), new ItemStack(Item.field_77703_o), new ItemStack(Item.field_77711_v, 1, -1), new ItemStack(Item.field_77703_o), new ItemStack(Item.field_77703_o), new ItemStack(Item.field_77703_o), new ItemStack(Item.field_77703_o)}, new ItemStack((Item)this.itemAlpha, 8, 1337)));
            GameRegistry.addRecipe((IRecipe)new ShapedRecipesExt(2, 2, new ItemStack[]{new ItemStack((Item)this.itemAlpha, 1, 1337), null, null, new ItemStack(Item.field_77804_ap)}, new ItemStack(Item.field_77709_i)));
            GameRegistry.addRecipe((IRecipe)new ShapedRecipesExt(3, 3, new ItemStack[]{new ItemStack((Item)this.itemAlpha, 1, 1337), new ItemStack(Item.field_77760_aL), new ItemStack((Item)this.itemAlpha, 1, 1337), new ItemStack(Item.field_77702_n), new ItemStack(Block.field_72089_ap), new ItemStack(Item.field_77702_n), new ItemStack(Block.field_72089_ap), new ItemStack(Block.field_72089_ap), new ItemStack(Block.field_72089_ap)}, new ItemStack(Block.field_72096_bE)));
        }
        if (this.enableChargeStation) {
            this.blockAlpha.registerTile(0).setClass(TileChargeStation.class).setSprites("generic", "generic", "generic", "charge", "generic", "generic").setName("chargeStation").setFacingMode(BlockMultiTile.TileData.FacingMode.All).setInfoText(MiscPeripherals.instance.descriptive ? "This block is used by turtles!" : null);
            GameRegistry.registerTileEntity(TileChargeStation.class, (String)"MiscPeripherals Charge Station");
            LanguageRegistry.instance().addStringLocalization("miscperipherals.chargeStation.name", "Charge Station");
            GameRegistry.registerCustomItemStack((String)"chargeStation", (ItemStack)new ItemStack((Block)this.blockAlpha, 1, 0));
        }
        if (this.enableChargeStationT2) {
            data = this.blockBeta.registerTile(1).setClass(TileChargeStationT2.class).setName("chargeStationT2").setFacingMode(BlockMultiTile.TileData.FacingMode.All).setInfoText(MiscPeripherals.instance.descriptive ? "This block is used by turtles!" : null);
            if (this.chargeStationMultiCharge) {
                data.setSprites("charge_t2_side", "charge_t2_side", "charge_t2", "charge_t2", "charge_t2_side", "charge_t2_side");
            } else {
                data.setSprites("charge_t2_side", "charge_t2_side", "charge_t2_side", "charge_t2", "charge_t2_side", "charge_t2_side");
            }
            GameRegistry.registerTileEntity(TileChargeStationT2.class, (String)"MiscPeripherals Charge Station T2");
            LanguageRegistry.instance().addStringLocalization("miscperipherals.chargeStationT2.name", "Advanced Charge Station");
            GameRegistry.registerCustomItemStack((String)"chargeStationT2", (ItemStack)new ItemStack((Block)this.blockBeta, 1, 1));
        }
        if (this.enableChargeStationT3) {
            data = this.blockBeta.registerTile(2).setClass(TileChargeStationT3.class).setName("chargeStationT3").setFacingMode(BlockMultiTile.TileData.FacingMode.All).setInfoText(MiscPeripherals.instance.descriptive ? "This block is used by turtles!" : null);
            if (this.chargeStationMultiCharge) {
                data.setSprites("charge_t3_side", "charge_t3_side", "charge_t3", "charge_t3", "charge_t3", "charge_t3");
            } else {
                data.setSprites("charge_t3_side", "charge_t3_side", "charge_t3_side", "charge_t3", "charge_t3_side", "charge_t3_side");
            }
            GameRegistry.registerTileEntity(TileChargeStationT3.class, (String)"MiscPeripherals Charge Station T3");
            LanguageRegistry.instance().addStringLocalization("miscperipherals.chargeStationT3.name", "Lapotronic Charge Station");
            GameRegistry.registerCustomItemStack((String)"chargeStationT3", (ItemStack)new ItemStack((Block)this.blockBeta, 1, 2));
        }
        if (this.enableChargeStationT4) {
            data = this.blockBeta.registerTile(3).setClass(TileChargeStationT4.class).setName("chargeStationT4").setFacingMode(BlockMultiTile.TileData.FacingMode.All).setInfoText(MiscPeripherals.instance.descriptive ? "This block is used by turtles!" : null);
            if (this.chargeStationMultiCharge) {
                data.setSprites("charge_t4");
            } else {
                data.setSprites("charge_t4_side", "charge_t4_side", "charge_t4_side", "charge_t4", "charge_t4_side", "charge_t4_side");
            }
            GameRegistry.registerTileEntity(TileChargeStationT4.class, (String)"MiscPeripherals Charge Station T4");
            LanguageRegistry.instance().addStringLocalization("miscperipherals.chargeStationT4.name", "Ultimate Charge Station");
            GameRegistry.registerCustomItemStack((String)"chargeStationT4", (ItemStack)new ItemStack((Block)this.blockBeta, 1, 3));
        }
        if (this.enableNote) {
            this.blockAlpha.registerTile(1).setClass(TileNote.class).setSprites("note").setName("ironNoteBlock").setInfoText(this.descriptive ? "This block is computer powered!" : null);
            GameRegistry.registerTileEntity(TileNote.class, (String)"MiscPeripherals Iron Note Block");
            lang.addStringLocalization("miscperipherals.ironNoteBlock.name", "Iron Note Block");
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)this.blockAlpha, 1, 1), (Object[])new Object[]{"IGI", "RNR", "IGI", Character.valueOf('I'), Item.field_77703_o, Character.valueOf('G'), Item.field_77717_p, Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('N'), Block.field_71960_R});
            GameRegistry.registerCustomItemStack((String)"ironNoteBlock", (ItemStack)new ItemStack((Block)this.blockAlpha, 1, 1));
        }
        if (this.enableChunkLoader) {
            this.itemAlpha.registerItem(4, "chunkLoader", "chunkLoaderModule");
            lang.addStringLocalization("miscperipherals.chunkLoaderModule.name", "Chunk Loader Module");
        }
        if (this.enableFeeder) {
            this.itemAlpha.registerItem(0, "feeder", "feedingModule");
            lang.addStringLocalization("miscperipherals.feedingModule.name", "Feeding Module");
            GameRegistry.addRecipe((ItemStack)new ItemStack((Item)this.itemAlpha, 1, 0), (Object[])new Object[]{"IWI", "WEW", "IWI", Character.valueOf('I'), Item.field_77703_o, Character.valueOf('W'), Item.field_77685_T, Character.valueOf('E'), Item.field_77748_bA});
            GameRegistry.registerCustomItemStack((String)"feedingModule", (ItemStack)new ItemStack((Item)this.itemAlpha, 1, 0));
        }
        if (this.enableResupply) {
            this.itemAlpha.registerItem(1, "resupply", "resupplyModule");
            lang.addStringLocalization("miscperipherals.resupplyModule.name", "Resupply Module");
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)this.itemAlpha, 1, 1), new Object[]{"GRG", "RCR", "GRG", Character.valueOf('G'), Item.field_77717_p, Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('C'), "MiscPeripherals$enderChest"}));
            GameRegistry.registerCustomItemStack((String)"resupplyModule", (ItemStack)new ItemStack((Item)this.itemAlpha, 1, 1));
            this.blockAlpha.registerTile(2).setClass(TileResupplyStation.class).setSprites("resupply").setName("resupplyStation").setInfoText(this.descriptive ? "This block is used by turtles!" : null);
            GameRegistry.registerTileEntity(TileResupplyStation.class, (String)"MiscPeripherals Resupply Station");
            lang.addStringLocalization("miscperipherals.resupplyStation.name", "Resupply Station");
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)this.blockAlpha, 1, 2), (Object[])new Object[]{"IRI", "CMC", "IRI", Character.valueOf('I'), Item.field_77703_o, Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('C'), Block.field_72077_au, Character.valueOf('M'), new ItemStack((Item)this.itemAlpha, 1, 1)});
            GameRegistry.registerCustomItemStack((String)"resupplyStation", (ItemStack)new ItemStack((Block)this.blockAlpha, 1, 2));
        }
        if (this.enableInteractiveSorter) {
            this.blockAlpha.registerTile(5).setClass(TileInteractiveSorter.class).setSprites("isorter", "isorter_active").setName("interactiveSorter").setInfoText(this.descriptive ? "This block is computer powered!" : null);
            GameRegistry.registerTileEntity(TileInteractiveSorter.class, (String)"MiscPeripherals Interactive Sorter");
            lang.addStringLocalization("miscperipherals.interactiveSorter.name", "Interactive Sorter");
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)this.blockAlpha, 1, 5), (Object[])new Object[]{"DPD", "PEP", "DPD", Character.valueOf('D'), Item.field_77702_n, Character.valueOf('P'), Block.field_71963_Z, Character.valueOf('E'), Item.field_77748_bA});
            GameRegistry.registerCustomItemStack((String)"interactiveSorter", (ItemStack)new ItemStack((Block)this.blockAlpha, 1, 5));
        }
        if (this.enableRailReader) {
            this.blockAlpha.registerTile(7).setClass(TileRailReader.class).setSprites("railReader").setName("railReader").setInfoText(this.descriptive ? "This block is computer powered!" : null);
            GameRegistry.registerTileEntity(TileRailReader.class, (String)"MiscPeripherals Rail Reader");
            lang.addStringLocalization("miscperipherals.railReader.name", "Rail Reader");
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)this.blockAlpha, 1, 7), new Object[]{"GRG", "RER", "GRG", Character.valueOf('G'), Item.field_77717_p, Character.valueOf('R'), "MiscPeripherals$cartDetectorRail", Character.valueOf('E'), "MiscPeripherals$cartDetector"}));
            GameRegistry.registerCustomItemStack((String)"railReader", (ItemStack)new ItemStack((Block)this.blockAlpha, 1, 7));
        }
        if (this.enableInventory) {
            this.itemAlpha.registerItem(3, "inventory", "inventoryModule");
            lang.addStringLocalization("miscperipherals.inventoryModule.name", "Inventory Module");
            GameRegistry.addRecipe((ItemStack)new ItemStack((Item)this.itemAlpha, 1, 3), (Object[])new Object[]{"GEG", "E@E", "GEG", Character.valueOf('G'), Item.field_77717_p, Character.valueOf('E'), Item.field_77748_bA, Character.valueOf('@'), this.enableInteractiveSorter ? new ItemStack((Block)this.blockAlpha, 1, 5) : Item.field_82792_bS});
            GameRegistry.registerCustomItemStack((String)"inventoryModule", (ItemStack)new ItemStack((Item)this.itemAlpha, 1, 3));
        }
        if (this.enableTeleporter) {
            this.blockAlpha.registerTile(10).setClass(TileTeleporter.class).setSprites("teleporter_side", "teleporter_side", "teleporter_side", "teleporter", "teleporter_side", "teleporter_side").setName("teleporter").setFacingMode(BlockMultiTile.TileData.FacingMode.All);
            GameRegistry.registerTileEntity(TileTeleporter.class, (String)"MiscPeripherals Teleporter");
            lang.addStringLocalization("miscperipherals.teleporter.name", "Turtle Teleporter");
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)this.blockAlpha, 1, 10), (Object[])new Object[]{"PEP", "POP", "PEP", Character.valueOf('P'), Item.field_77730_bn, Character.valueOf('E'), Item.field_77748_bA, Character.valueOf('O'), Block.field_72089_ap});
            GameRegistry.registerCustomItemStack((String)"teleporter", (ItemStack)new ItemStack((Block)this.blockAlpha, 1, 10));
        }
        if (this.enableTeleporterT2) {
            this.blockBeta.registerTile(0).setClass(TileTeleporterT2.class).setSprites("teleporter_side", "teleporter_side", "teleporter_side", "teleporter_t2", "teleporter_side", "teleporter_side").setName("teleporterT2").setFacingMode(BlockMultiTile.TileData.FacingMode.All);
            GameRegistry.registerTileEntity(TileTeleporterT2.class, (String)"MiscPeripherals Teleporter T2");
            lang.addStringLocalization("miscperipherals.teleporterT2.name", "Advanced Turtle Teleporter");
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)this.blockBeta, 1, 0), (Object[])new Object[]{"ERE", "M@M", "ERE", Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('E'), Item.field_77748_bA, Character.valueOf('M'), Item.field_77817_bH, Character.valueOf('@'), this.enableTeleporter ? new ItemStack((Block)this.blockAlpha, 1, 10) : Block.field_72105_ah});
            GameRegistry.registerCustomItemStack((String)"teleporterT2", (ItemStack)new ItemStack((Block)this.blockBeta, 1, 0));
        }
        if (this.enablePlayerDetector) {
            this.blockAlpha.registerTile(12).setClass(TilePlayerDetector.class).setSprites("playerDetector").setName("playerDetector").setInfoText(this.descriptive ? "This block is computer powered!" : null);
            GameRegistry.registerTileEntity(TilePlayerDetector.class, (String)"MiscPeripherals Player Detector");
            lang.addStringLocalization("miscperipherals.playerDetector.name", "Player Detector");
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)this.blockAlpha, 1, 12), (Object[])new Object[]{"GRG", "EDE", "GRG", Character.valueOf('G'), Item.field_77717_p, Character.valueOf('E'), Item.field_77748_bA, Character.valueOf('D'), Item.field_77702_n, Character.valueOf('R'), Item.field_77767_aC});
            GameRegistry.registerCustomItemStack((String)"playerDetector", (ItemStack)new ItemStack((Block)this.blockAlpha, 1, 12));
        }
        if (this.enableCrafter) {
            this.blockAlpha.registerTile(13).setClass(TileCrafter.class).setSprites("crafter").setName("crafter");
            GameRegistry.registerTileEntity(TileCrafter.class, (String)"MiscPeripherals Crafter");
            lang.addStringLocalization("miscperipherals.crafter.name", "Computer Controlled Crafter");
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)this.blockAlpha, 1, 13), (Object[])new Object[]{"RWR", "W@W", "RWR", Character.valueOf('W'), Block.field_72060_ay, Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('@'), this.enableInteractiveSorter ? new ItemStack((Block)this.blockAlpha, 1, 5) : Block.field_72071_ax});
            GameRegistry.registerCustomItemStack((String)"crafter", (ItemStack)new ItemStack((Block)this.blockAlpha, 1, 13));
        }
        if (this.enableAccelerator) {
            this.blockAlpha.registerTile(15).setClass(TileAccelerator.class).setSprites("accelerator").setName("accelerator").setInfoText(this.descriptive ? "This block is computer powered!" : null);
            GameRegistry.registerTileEntity(TileAccelerator.class, (String)"MiscPeripherals Accelerator");
            lang.addStringLocalization("miscperipherals.accelerator.name", "Hardware Accelerator");
            GameRegistry.registerCustomItemStack((String)"accelerator", (ItemStack)new ItemStack((Block)this.blockAlpha, 1, 15));
        }
        if (this.enableFireworkLauncher) {
            this.blockBeta.registerTile(4).setClass(TileFireworks.class).setSprites("fireworks").setName("fireworks").setInfoText(this.descriptive ? "This block is computer powered!" : null);
            GameRegistry.registerTileEntity(TileFireworks.class, (String)"MiscPeripherals Firework Launcher");
            lang.addStringLocalization("miscperipherals.fireworks.name", "Firework Launcher");
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)this.blockBeta, 1, 4), (Object[])new Object[]{"IGI", "#@#", "IGI", Character.valueOf('I'), Item.field_77703_o, Character.valueOf('G'), Item.field_77677_M, Character.valueOf('#'), Block.field_72077_au, Character.valueOf('@'), Block.field_71958_P});
            GameRegistry.registerCustomItemStack((String)"fireworks", (ItemStack)new ItemStack((Block)this.blockBeta, 1, 4));
        }
        if (this.enableChatBox) {
            this.blockBeta.registerTile(5).setClass(TileChatBox.class).setSprites("chat").setName("chatBox").setInfoText(this.descriptive ? "This block is computer powered!" : null);
            GameRegistry.registerTileEntity(TileChatBox.class, (String)"MiscPeripherals Chat Box");
            lang.addStringLocalization("miscperipherals.chatBox.name", "Chat Box");
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)this.blockBeta, 1, 5), (Object[])new Object[]{"G@G", "@*@", "G@G", Character.valueOf('G'), Item.field_77717_p, Character.valueOf('*'), Item.field_77702_n, Character.valueOf('@'), Block.field_71960_R});
            GameRegistry.registerCustomItemStack((String)"chatBox", (ItemStack)new ItemStack((Block)this.blockBeta, 1, 5));
        }
        if (this.enableSpeaker) {
            this.blockBeta.registerTile(7).setClass(TileSpeaker.class).setSprites("chat", "chat", "speaker", "speaker", "speaker", "speaker").setName("speaker").setInfoText(this.descriptive ? "This block is computer powered!" : null);
            GameRegistry.registerTileEntity(TileSpeaker.class, (String)"MiscPeripherals Speaker");
            lang.addStringLocalization("miscperipherals.speaker.name", "Speaker");
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)this.blockBeta, 1, 7), (Object[])new Object[]{"G@G", "@*@", "G@G", Character.valueOf('G'), Item.field_77717_p, Character.valueOf('*'), Block.field_94341_cq, Character.valueOf('@'), Block.field_71960_R});
            GameRegistry.registerCustomItemStack((String)"speaker", (ItemStack)new ItemStack((Block)this.blockBeta, 1, 7));
        }
        if (this.enableSmSender) {
            this.blockBeta.registerTile(8).setClass(TileSmSender.class).setSprites("smSender").setName("smSender");
            GameRegistry.registerTileEntity(TileSmSender.class, (String)"MiscPeripherals Smallnet Sender");
            lang.addStringLocalization("miscperipherals.smSender.name", "Smallnet Sender");
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)this.blockBeta, 1, 8), (Object[])new Object[]{"@I@", "IGI", "@I@", Character.valueOf('I'), Item.field_77703_o, Character.valueOf('@'), Block.field_72035_aQ, Character.valueOf('G'), Item.field_77717_p});
            GameRegistry.registerCustomItemStack((String)"smSender", (ItemStack)new ItemStack((Block)this.blockBeta, 1, 8));
        }
        if (this.enableEnergyMeter) {
            this.blockBeta.registerTile(10).setClass(TileEnergyMeter.class).setSprites("energyMeter", "energyMeter", "energyMeter", "energyMeter_active", "energyMeter", "energyMeter").setName("energyMeter").setFacingMode(BlockMultiTile.TileData.FacingMode.All).setInfoText(this.descriptive ? "This block is computer powered!" : null);
            GameRegistry.registerTileEntity(TileEnergyMeter.class, (String)"MiscPeripherals Energy Meter");
            lang.addStringLocalization("miscperipherals.energyMeter.name", "Energy Meter");
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)this.blockBeta, 1, 10), new Object[]{"IRI", "I@I", "IRI", Character.valueOf('I'), Item.field_77703_o, Character.valueOf('R'), Block.field_94341_cq, Character.valueOf('@'), "MiscPeripherals$energyMeter"}));
            GameRegistry.registerCustomItemStack((String)"energyMeter", (ItemStack)new ItemStack((Block)this.blockBeta, 1, 10));
        }
        for (Module module : this.modules.values()) {
            module.onInit();
        }
        TickRegistry.registerTickHandler((ITickHandler)new TickHandler(), (Side)Side.SERVER);
        NetworkRegistry.instance().registerGuiHandler((Object)this, (IGuiHandler)guiHandler);
    }

    @Mod.PostInit
    public void onLoaded(FMLPostInitializationEvent event) {
        LanguageRegistry lang = LanguageRegistry.instance();
        lang.addStringLocalization("itemGroup.miscperipherals", "MiscPeripherals");
        if (this.itemSmartHelmet != null) {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)this.itemSmartHelmet), (Object[])new Object[]{Item.field_77812_ad, CCItems.getModem(), CCItems.getMonitor()});
        }
        if (this.enableNote) {
            MiscPeripherals.registerUpgrade(new UpgradeNote());
        }
        if (this.enableChunkLoader) {
            MiscPeripherals.registerUpgrade(new UpgradeChunkLoader());
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Item)this.itemAlpha, 1, 4), new Object[]{CCItems.getModem(), "MiscPeripherals$chunkLoader"}));
            ForgeChunkManager.setForcedChunkLoadingCallback((Object)this, (ForgeChunkManager.LoadingCallback)new ChunkLoadingCallback());
        }
        if (this.enableFeeder) {
            MiscPeripherals.registerUpgrade(new UpgradeFeeder());
        }
        if (this.enableResupply) {
            MiscPeripherals.registerUpgrade(new UpgradeResupply());
        }
        if (this.enableShears) {
            MiscPeripherals.registerUpgrade(new UpgradeShears());
        }
        if (this.enableCompass) {
            MiscPeripherals.registerUpgrade(new UpgradeCompass());
        }
        if (this.enableInventory) {
            MiscPeripherals.registerUpgrade(new UpgradeInventory());
        }
        if (this.enableSignReader) {
            MiscPeripherals.registerUpgrade(new UpgradeSignReader());
        }
        if (this.enableXP) {
            MiscPeripherals.registerUpgrade(new UpgradeXP());
            MiscPeripherals.registerUpgrade(new UpgradeAnvil());
        }
        if (this.enableInventory) {
            MiscPeripherals.registerUpgrade(new UpgradeInventory());
        }
        if (this.enableTank) {
            MiscPeripherals.registerUpgrade(new UpgradeTank());
        }
        if (!OreDictionary.getOres((String)"dropUranium").isEmpty() && this.enableRTG) {
            this.itemAlpha.registerItem(5, "rtg", "rtgModule");
            lang.addStringLocalization("miscperipherals.rtgModule.name", "RTG Module");
            Object copper = OreDictionary.getOres((String)"ingotCopper").isEmpty() ? Item.field_77717_p : "ingotCopper";
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)this.itemAlpha, 1, 5), new Object[]{true, "CIC", "@G#", "CIC", Character.valueOf('C'), copper, Character.valueOf('I'), Item.field_77703_o, Character.valueOf('@'), "MiscPeripherals$rtgChamber", Character.valueOf('G'), "MiscPeripherals$rtgGenerator", Character.valueOf('#'), "MiscPeripherals$rtgCircuit"}));
            MiscPeripherals.registerUpgrade(new UpgradeRTG());
        }
        if (this.enableAccelerator) {
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)this.blockAlpha, 1, 15), (Object[])new Object[]{"GRG", "R@R", "GRG", Character.valueOf('G'), Item.field_77717_p, Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('@'), CCItems.getComputer()});
            MiscPeripherals.registerUpgrade(new UpgradeAccelerator());
        }
        if (this.enableFireworkLauncher) {
            MiscPeripherals.registerUpgrade(new UpgradeFireworks());
        }
        if (this.enableChatBox) {
            MiscPeripherals.registerUpgrade(new UpgradeChatBox());
        }
        if (this.enableSpeaker) {
            MiscPeripherals.registerUpgrade(new UpgradeSpeaker());
        }
        if (this.enableChest) {
            MiscPeripherals.registerUpgrade(new UpgradeChest());
        }
        if (this.enableEnergyMeter) {
            MiscPeripherals.registerUpgrade(new UpgradeEnergyMeter());
        }
        for (Module module : this.modules.values()) {
            module.onPostInit();
        }
        this.settings.save();
        OreDictionary.registerOre((String)"MiscPeripherals$enderChest", (ItemStack)new ItemStack(Block.field_72066_bS, 1, Short.MAX_VALUE));
        for (ItemStack stack : CCItems.getDisks()) {
            if (stack == null) continue;
            OreDictionary.registerOre((String)"MiscPeripherals$disk", (ItemStack)stack);
        }
        MiscPeripherals.addOreDictFallback("MiscPeripherals$cartDetector", new ItemStack(Item.field_77748_bA));
        MiscPeripherals.addOreDictFallback("MiscPeripherals$cartDetectorRail", new ItemStack(Block.field_71953_U));
        MiscPeripherals.addOreDictFallback("MiscPeripherals$rtgChamber", new ItemStack(Item.field_82792_bS));
        MiscPeripherals.addOreDictFallback("MiscPeripherals$rtgGenerator", new ItemStack(Block.field_72051_aB));
        MiscPeripherals.addOreDictFallback("MiscPeripherals$rtgCircuit", new ItemStack(Item.field_77742_bb));
        MiscPeripherals.addOreDictFallback("MiscPeripherals$energyMeter", new ItemStack(Item.field_94585_bY));
        MiscPeripherals.addOreDictFallback("MiscPeripherals$disk", new ItemStack(Item.field_77767_aC));
        if (this.blockLanCable != null) {
            BlockLanCable.registerType(0, "Wood", Block.field_71988_x, 8.0, true, false).addRecipe("plankWood");
            BlockLanCable.registerType(1, "Tin", Block.field_71988_x, 16.0, true, false).addRecipe("ingotTin").setOreDictTexture("blockTin", new ItemStack(Block.field_72101_ab, 1, 0));
            BlockLanCable.registerType(2, "Copper", Block.field_71988_x, 32.0, true, false).addRecipe("ingotCopper").setOreDictTexture("blockCopper", new ItemStack(Block.field_72101_ab, 1, 1));
            BlockLanCable.registerType(3, "Bronze", Block.field_71988_x, 64.0, true, false).addRecipe("ingotBronze").setOreDictTexture("blockBronze", new ItemStack(Block.field_72101_ab, 1, 12));
            BlockLanCable.registerType(4, "Iron", Block.field_72083_ai, 128.0, true, false).addRecipe("ingotIron");
            BlockLanCable.registerType(5, "Gold", Block.field_72105_ah, 256.0, true, false).addRecipe("ingotGold");
            BlockLanCable.registerType(6, "Silver", Block.field_71988_x, 512.0, true, false).addRecipe("ingotSilver").setOreDictTexture("blockSilver", new ItemStack(Block.field_72101_ab, 1, 7));
            BlockLanCable.registerType(7, "Nickel", Block.field_71988_x, 1024.0, true, false).addRecipe("ingotNickel").setOreDictTexture("blockNickel", new ItemStack(Block.field_72101_ab, 1, 4));
            BlockLanCable.registerType(8, "Platinum", Block.field_71988_x, 2048.0, true, false).addRecipe("ingotPlatinum").setOreDictTexture("blockPlatinum", new ItemStack(Block.field_72101_ab, 1, 9));
            BlockLanCable.registerType(9, "Tungsten", Block.field_71988_x, 4096.0, true, false).addRecipe("ingotTungsten").setOreDictTexture("blockTungsten", new ItemStack(Block.field_72101_ab, 1, 15));
            BlockLanCable.registerType(10, "Iridium", Block.field_71988_x, 8192.0, true, false).addRecipe("ingotIridium").setOreDictTexture("blockIridium", new ItemStack(Block.field_72101_ab, 1, 8));
        }
        LuaManager.init();
        SmallNetHelper.init();
        proxy.onPostInit();
        GameRegistry.addShapelessRecipe((ItemStack)this.name(new ItemStack(Item.field_82792_bS), "The Nether Star of Justice"), (Object[])new Object[]{this.behead("SOTMead"), this.behead("Nebris"), new ItemStack(Item.field_82792_bS)});
    }

    @Mod.ServerStarting
    public void onServerStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandBase(){

            public void func_71515_b(ICommandSender icommandsender, String[] astring) {
                TileEntity te;
                EntityPlayerMP player = 1.func_71521_c((ICommandSender)icommandsender);
                MovingObjectPosition mop = Util.rayTrace((EntityLiving)player, 4.5);
                if (mop.field_72313_a == EnumMovingObjectType.TILE && (te = player.field_70170_p.func_72796_p(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d)) instanceof TileChargeStation) {
                    if (astring.length < 1) {
                        icommandsender.func_70006_a("Turtle fuel limit: " + ((TileChargeStation)te).limit);
                    } else {
                        ((TileChargeStation)te).limit = 1.func_71528_a((ICommandSender)icommandsender, (String)astring[0], (int)0);
                        icommandsender.func_70006_a("Turtle fuel limit set to " + astring[0]);
                    }
                }
                throw new WrongUsageException(this.func_71518_a(icommandsender), new Object[0]);
            }

            public String func_71517_b() {
                return "chargestationlimit";
            }

            public String func_71518_a(ICommandSender par1ICommandSender) {
                return "/" + this.func_71517_b() + " <limit> - while looking at a charge station";
            }

            public boolean func_71519_b(ICommandSender par1ICommandSender) {
                return par1ICommandSender instanceof EntityPlayer && ((EntityPlayer)par1ICommandSender).field_71075_bZ.field_75099_e;
            }
        });
    }

    @Mod.FingerprintWarning
    public void onFingerprintWarning(FMLFingerprintViolationEvent event) {
    }

    public static void debug(String message) {
    }

    public static boolean addOreDictFallback(String id, ItemStack ore) {
        ArrayList ores = OreDictionary.getOres((String)id);
        if (ores.isEmpty()) {
            ores.add(ore);
            return true;
        }
        return false;
    }

    public static void registerUpgrade(ITurtleUpgrade upgrade) {
        if (upgrade.getUpgradeID() > 255 && ccVersion != null && (ccVersion.contains("1.52") || ccVersion.contains("1.51"))) {
            log.warning("Not registering upgrade [" + upgrade.getAdjective() + "] due to high ID and old CC (" + ccVersion + ")");
            return;
        }
        TurtleAPI.registerUpgrade((ITurtleUpgrade)upgrade);
        Icons.registerUpgrade(upgrade);
        CreativeTabMiscPeripherals.registerUpgrade(upgrade);
    }

    public boolean loadModule(String mod, String name) {
        if (MiscPeripherals.hasMod(mod)) {
            try {
                Object module = Class.forName("miscperipherals.module.Module" + name).newInstance();
                if (!(module instanceof Module)) {
                    throw new IllegalArgumentException("Not a valid module");
                }
                this.modules.put(name, (Module)module);
            }
            catch (Throwable e) {
                log.warning("Could not load module " + name + " for mod " + mod);
                e.printStackTrace();
                return false;
            }
            log.info("Loaded module: " + name);
            return true;
        }
        return false;
    }

    public static boolean hasMod(String mod) {
        ArtifactVersion ver = VersionParser.parseVersionReference((String)mod);
        return Loader.isModLoaded((String)ver.getLabel()) && ver.containsVersion(((ModContainer)Loader.instance().getIndexedModList().get(ver.getLabel())).getProcessedVersion());
    }

    private ItemStack behead(String a) {
        ItemStack b = new ItemStack(Item.field_82799_bQ, 1, 3);
        b.field_77990_d = new NBTTagCompound();
        b.field_77990_d.func_74778_a("SkullOwner", a);
        return b;
    }

    private ItemStack name(ItemStack a, String b) {
        a.func_82834_c(b);
        return a;
    }

    static {
        log = Logger.getLogger("MiscPeripherals");
        ccVersion = null;
    }
}

