/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.core;

import dan200.turtle.api.ITurtleAccess;
import java.util.LinkedList;
import java.util.List;
import miscperipherals.core.MiscPeripherals;
import miscperipherals.peripheral.PeripheralChunkLoader;
import miscperipherals.util.Util;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class ChunkLoadingCallback
implements ForgeChunkManager.OrderedLoadingCallback {
    public void ticketsLoaded(List tickets, World world) {
        for (ForgeChunkManager.Ticket ticket : tickets) {
            int z;
            int y;
            int x = ticket.getModData().func_74762_e("turtleX");
            TileEntity te = world.func_72796_p(x, y = ticket.getModData().func_74762_e("turtleY"), z = ticket.getModData().func_74762_e("turtleZ"));
            if (!(te instanceof ITurtleAccess)) continue;
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)new ChunkCoordIntPair(x >> 4, z >> 4));
            PeripheralChunkLoader loader = (PeripheralChunkLoader)Util.getPeripheral((ITurtleAccess)te, PeripheralChunkLoader.class);
            if (loader == null) continue;
            loader.ticketCreated = true;
        }
    }

    public List ticketsLoaded(List tickets, World world, int maxTicketCount) {
        LinkedList<ForgeChunkManager.Ticket> ret = new LinkedList<ForgeChunkManager.Ticket>();
        LinkedList<ChunkCoordinates> known = new LinkedList<ChunkCoordinates>();
        for (ForgeChunkManager.Ticket ticket : tickets) {
            int z;
            int y;
            int x = ticket.getModData().func_74762_e("turtleX");
            ChunkCoordinates coords = new ChunkCoordinates(x, y = ticket.getModData().func_74762_e("turtleY"), z = ticket.getModData().func_74762_e("turtleZ"));
            if (known.contains(coords)) continue;
            known.add(coords);
            TileEntity te = world.func_72796_p(x, y, z);
            if (!(te instanceof ITurtleAccess) || Util.getPeripheral((ITurtleAccess)te, PeripheralChunkLoader.class) == null) continue;
            ret.add(ticket);
        }
        int removed = tickets.size() - known.size();
        if (removed > 0) {
            MiscPeripherals.log.info("Removed " + removed + " bugged duplicate chunk loading tickets from world " + world.field_73011_w.field_76574_g);
        }
        return ret;
    }
}

