/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.block;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.List;
import miscperipherals.core.MiscPeripherals;
import miscperipherals.tile.Tile;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class BlockMultiTile
extends BlockContainer {
    private static final int META_VALUES = 16;
    private static final int FACING_VALUES = 6;
    private static final int[][] SIDE_OFFSETS = new int[][]{{3, 2, 0, 1, 5, 4}, {2, 3, 0, 1, 5, 4}, {0, 1, 3, 2, 5, 4}, {0, 1, 2, 3, 4, 5}, {0, 1, 4, 5, 3, 2}, {0, 1, 5, 4, 2, 3}};
    public static Icon GENERIC = null;
    public TileData[] data = new TileData[16];

    public BlockMultiTile(int id) {
        super(id, Material.field_76246_e);
        this.func_71848_c(3.0f);
        this.func_71894_b(10.0f);
        this.func_71849_a(MiscPeripherals.instance.tabMiscPeripherals);
    }

    public TileEntity func_72274_a(World world) {
        return null;
    }

    public TileEntity createTileEntity(World world, int meta) {
        if (this.data[meta] == null || this.data[meta].clazz == null) {
            return null;
        }
        try {
            return (TileEntity)this.data[meta].clazz.newInstance();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public Icon func_71895_b(IBlockAccess world, int x, int y, int z, int side) {
        int meta = world.func_72805_g(x, y, z);
        if (this.data[meta] == null) {
            return GENERIC;
        }
        TileEntity te = world.func_72796_p(x, y, z);
        if (!(te instanceof Tile)) {
            return this.data[meta].sprites[SIDE_OFFSETS[3][side]];
        }
        Tile tile = (Tile)te;
        int sideOff = SIDE_OFFSETS[tile.getFacing()][side];
        return tile.isActive() ? this.data[meta].activeSprites[sideOff] : this.data[meta].sprites[sideOff];
    }

    public Icon func_71858_a(int side, int meta) {
        return meta >= 0 && meta < this.data.length && this.data[meta] != null ? this.data[meta].sprites[SIDE_OFFSETS[3][side >= 0 && side < 6 ? side : 0]] : GENERIC;
    }

    public void func_71860_a(World world, int x, int y, int z, EntityLiving entity, ItemStack stack) {
        int meta;
        TileEntity te;
        if (!world.field_72995_K && entity != null && (te = world.func_72796_p(x, y, z)) instanceof Tile && this.data[meta = world.func_72805_g(x, y, z)] != null && this.data[meta].facingMode != TileData.FacingMode.None) {
            int pitch;
            Tile tile = (Tile)te;
            int yaw = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            int n = pitch = this.data[meta].facingMode == TileData.FacingMode.All ? Math.round(entity.field_70125_A) : 0;
            if (pitch >= 65) {
                tile.setFacing(1);
            } else if (pitch <= -65) {
                tile.setFacing(0);
            } else if (yaw == 0) {
                tile.setFacing(2);
            } else if (yaw == 1) {
                tile.setFacing(5);
            } else if (yaw == 2) {
                tile.setFacing(3);
            }
        }
    }

    public void func_71879_a(int id, CreativeTabs tabs, List list) {
        for (int meta = 0; meta < this.data.length; ++meta) {
            if (this.data[meta] == null) continue;
            list.add(new ItemStack((Block)this, 1, meta));
        }
    }

    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (player.func_70093_af()) {
            return false;
        }
        TileEntity te = world.func_72796_p(x, y, z);
        if (!(te instanceof Tile)) {
            return false;
        }
        Tile tile = (Tile)te;
        return tile.onBlockActivated(player, side, hitX, hitY, hitZ);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return new ItemStack((Block)this, 1, world.func_72805_g(x, y, z));
    }

    public ArrayList getBlockDropped(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(new ItemStack((Block)this, 1, metadata));
        return ret;
    }

    public int func_71899_b(int meta) {
        return meta;
    }

    public void func_71852_a(World world, int x, int y, int z, int a, int b) {
        TileEntity te = world.func_72796_p(x, y, z);
        if (te instanceof IInventory) {
            IInventory inv = (IInventory)te;
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (stack == null) continue;
                float var10 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                float var11 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                float var12 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                while (stack.field_77994_a > 0) {
                    int var13 = world.field_73012_v.nextInt(21) + 10;
                    if (var13 > stack.field_77994_a) {
                        var13 = stack.field_77994_a;
                    }
                    stack.field_77994_a -= var13;
                    EntityItem var14 = new EntityItem(world, (double)((float)x + var10), (double)((float)y + var11), (double)((float)z + var12), new ItemStack(stack.field_77993_c, var13, stack.func_77960_j()));
                    float var15 = 0.05f;
                    var14.field_70159_w = (float)world.field_73012_v.nextGaussian() * var15;
                    var14.field_70181_x = (float)world.field_73012_v.nextGaussian() * var15 + 0.2f;
                    var14.field_70179_y = (float)world.field_73012_v.nextGaussian() * var15;
                    if (stack.func_77942_o()) {
                        var14.func_92059_d().func_77982_d((NBTTagCompound)stack.func_77978_p().func_74737_b());
                    }
                    world.func_72838_d((Entity)var14);
                }
            }
        }
        world.func_72932_q(x, y, z);
    }

    public void func_71867_k(World world, int x, int y, int z, Explosion explosion) {
        super.func_71867_k(world, x, y, z, explosion);
        world.func_72932_q(x, y, z);
    }

    public void func_94332_a(IconRegister reg) {
        GENERIC = reg.func_94245_a("MiscPeripherals:generic");
        for (int i = 0; i < 16; ++i) {
            int j;
            if (this.data[i] == null) continue;
            for (j = 0; j < this.data[i].spriteNames.length; ++j) {
                this.data[i].sprites[j] = reg.func_94245_a("MiscPeripherals:" + this.data[i].spriteNames[j]);
            }
            for (j = 0; j < this.data[i].activeSpriteNames.length; ++j) {
                this.data[i].activeSprites[j] = reg.func_94245_a("MiscPeripherals:" + this.data[i].activeSpriteNames[j]);
            }
        }
    }

    public boolean rotateBlock(World worldObj, int x, int y, int z, ForgeDirection axis) {
        if (axis == ForgeDirection.UNKNOWN) {
            return false;
        }
        int meta = worldObj.func_72805_g(x, y, z);
        if (this.data[meta] == null) {
            return false;
        }
        switch (this.data[meta].facingMode) {
            case None: {
                return false;
            }
            case Horizontal: {
                if (axis.offsetY == 0) break;
                return false;
            }
        }
        TileEntity te = worldObj.func_72796_p(x, y, z);
        if (!(te instanceof Tile)) {
            return false;
        }
        ((Tile)te).setFacing(axis.ordinal());
        return true;
    }

    public boolean func_96468_q_() {
        return true;
    }

    public int func_94328_b_(World world, int x, int y, int z, int side) {
        TileEntity te = world.func_72796_p(x, y, z);
        if (!(te instanceof Tile)) {
            return 0;
        }
        return ((Tile)te).getComparator(side);
    }

    public TileData registerTile(int meta) {
        TileData td;
        if (this.data[meta] != null) {
            throw new RuntimeException("Metadata value " + meta + " already used by " + this.data[meta]);
        }
        this.data[meta] = td = new TileData(meta);
        return td;
    }

    public int findFirstUsedMeta() {
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] == null) continue;
            return i;
        }
        return -1;
    }

    public static class TileData {
        public final int meta;
        public Class clazz;
        public Icon[] sprites = new Icon[6];
        public Icon[] activeSprites = new Icon[6];
        public String name;
        public FacingMode facingMode = FacingMode.None;
        public String[] infoText = new String[0];
        private String[] spriteNames = new String[6];
        private String[] activeSpriteNames = new String[6];

        private TileData(int meta) {
            this.meta = meta;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("name", (Object)this.name).add("meta", this.meta).add("clazz", (Object)this.clazz).toString();
        }

        public TileData setClass(Class clazz) {
            this.clazz = clazz;
            return this;
        }

        public TileData setSprites(String ... sprites) {
            switch (sprites.length) {
                case 1: {
                    this.spriteNames = new String[]{sprites[0], sprites[0], sprites[0], sprites[0], sprites[0], sprites[0]};
                    this.activeSpriteNames = this.spriteNames;
                    break;
                }
                case 2: {
                    this.spriteNames = new String[]{sprites[0], sprites[0], sprites[0], sprites[0], sprites[0], sprites[0]};
                    this.activeSpriteNames = new String[]{sprites[1], sprites[1], sprites[1], sprites[1], sprites[1], sprites[1]};
                    break;
                }
                case 6: {
                    this.spriteNames = sprites;
                    this.activeSpriteNames = sprites;
                    break;
                }
                case 12: {
                    System.arraycopy(sprites, 0, this.spriteNames, 0, 6);
                    System.arraycopy(sprites, 6, this.activeSpriteNames, 0, 6);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown sprite array size " + sprites.length);
                }
            }
            return this;
        }

        public TileData setName(String name) {
            this.name = name;
            return this;
        }

        public TileData setFacingMode(FacingMode facingMode) {
            this.facingMode = facingMode;
            return this;
        }

        public TileData setInfoText(String ... infoText) {
            if (infoText.length > 0 && infoText[0] == null) {
                return this;
            }
            this.infoText = infoText;
            return this;
        }

        public static enum FacingMode {
            All,
            Horizontal,
            None;

        }
    }
}

