/*
 * Decompiled with CFR 0.152.
 */
package miscperipherals.block;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import miscperipherals.core.MiscPeripherals;
import miscperipherals.tile.TileLanCable;
import miscperipherals.util.Util;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class BlockLanCable
extends BlockContainer {
    public static Map types = new TreeMap(new Comparator(){

        public int compare(Integer o1, Integer o2) {
            return o1 < o2 ? -1 : (o1 > o2 ? 1 : 0);
        }
    });

    public BlockLanCable(int id) {
        super(id, Material.field_76246_e);
        this.func_71868_h(0);
        this.func_71849_a(MiscPeripherals.instance.tabMiscPeripherals);
    }

    public TileEntity func_72274_a(World var1) {
        return new TileLanCable();
    }

    public void func_85105_g(World world, int x, int y, int z, int meta) {
        TileEntity te = world.func_72796_p(x, y, z);
        if (te.getClass() != TileLanCable.class) {
            return;
        }
        ((TileLanCable)te).setType(meta);
        world.func_72902_n(x, y, z);
    }

    public void func_71879_a(int id, CreativeTabs tabs, List list) {
        for (Integer type : types.keySet()) {
            list.add(new ItemStack((Block)this, 1, type.intValue()));
        }
    }

    public boolean func_71886_c() {
        return false;
    }

    public int func_71857_b() {
        return MiscPeripherals.proxy.getRenderID("lanCable");
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean isBlockNormalCube(World world, int x, int y, int z) {
        return false;
    }

    public Icon func_71895_b(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity te = world.func_72796_p(x, y, z);
        if (te.getClass() != TileLanCable.class) {
            return ((CableType)BlockLanCable.types.get((Object)Integer.valueOf((int)0))).sprite;
        }
        return ((CableType)BlockLanCable.types.get((Object)Integer.valueOf((int)((TileLanCable)te).getType()))).sprite;
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int x, int y, int z, int meta) {
        TileEntity te = world.func_72796_p(x, y, z);
        if (te.getClass() != TileLanCable.class) {
            return null;
        }
        double halfThickness = ((TileLanCable)te).getThickness();
        return AxisAlignedBB.func_72330_a((double)((double)x + 0.5 - halfThickness), (double)((double)y + 0.5 - halfThickness), (double)((double)z + 0.5 - halfThickness), (double)((double)x + 0.5 + halfThickness), (double)((double)y + 0.5 + halfThickness), (double)((double)z + 0.5 + halfThickness));
    }

    public AxisAlignedBB func_71872_e(World world, int x, int y, int z) {
        return this.getCommonBoundingBoxFromPool(world, x, y, z, false);
    }

    public AxisAlignedBB func_71911_a_(World world, int x, int y, int z) {
        return this.getCommonBoundingBoxFromPool(world, x, y, z, true);
    }

    public ArrayList getBlockDropped(World world, int x, int y, int z, int metadata, int fortune) {
        TileEntity te = world.func_72796_p(x, y, z);
        if (te == null || te.getClass() != TileLanCable.class) {
            return new ArrayList(0);
        }
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>(1);
        ret.add(new ItemStack((Block)this, 1, ((TileLanCable)te).getType()));
        return ret;
    }

    public AxisAlignedBB getCommonBoundingBoxFromPool(World world, int x, int y, int z, boolean selectionBoundingBox) {
        TileEntity te = world.func_72796_p(x, y, z);
        if (te == null || te.getClass() != TileLanCable.class) {
            return null;
        }
        TileLanCable cable = (TileLanCable)te;
        double halfThickness = (double)cable.getThickness() / 2.0;
        double minX = (double)x + 0.5 - halfThickness;
        double minY = (double)y + 0.5 - halfThickness;
        double minZ = (double)z + 0.5 - halfThickness;
        double maxX = (double)x + 0.5 + halfThickness;
        double maxY = (double)y + 0.5 + halfThickness;
        double maxZ = (double)z + 0.5 + halfThickness;
        if (cable.canInteractWith(world.func_72796_p(x - 1, y, z))) {
            minX = x;
        }
        if (cable.canInteractWith(world.func_72796_p(x, y - 1, z))) {
            minY = y;
        }
        if (cable.canInteractWith(world.func_72796_p(x, y, z - 1))) {
            minZ = z;
        }
        if (cable.canInteractWith(world.func_72796_p(x + 1, y, z))) {
            maxX = x + 1;
        }
        if (cable.canInteractWith(world.func_72796_p(x, y + 1, z))) {
            maxY = y + 1;
        }
        if (cable.canInteractWith(world.func_72796_p(x, y, z + 1))) {
            maxZ = z + 1;
        }
        return AxisAlignedBB.func_72330_a((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    public static CableType registerType(int id, String name, Block sprite, double cps, boolean state, boolean redstone) {
        if (types.containsKey(id)) {
            throw new RuntimeException("Cable type " + id + " already taken by " + ((CableType)BlockLanCable.types.get((Object)Integer.valueOf((int)id))).name);
        }
        CableType type = new CableType(id, name, MiscPeripherals.proxy.getIcon(sprite), cps, state, redstone);
        types.put(id, type);
        return type;
    }

    public static class CableType {
        public final int id;
        public final String name;
        public Icon sprite;
        public final double cps;
        public final boolean state;
        public final boolean redstone;

        public CableType(int id, String name, Icon sprite, double cps, boolean state, boolean redstone) {
            this.id = id;
            String localName = Util.camelCase(name);
            LanguageRegistry.instance().addStringLocalization("miscperipherals.lanCable." + localName + ".name", name + " LAN Cable");
            this.name = localName;
            this.sprite = sprite;
            this.cps = cps;
            this.state = state;
            this.redstone = redstone;
        }

        public CableType addRecipe(String mat) {
            String arg = mat;
            if (mat.equals("ingotIron")) {
                arg = Item.field_77703_o;
            } else if (mat.equals("ingotGold")) {
                arg = Item.field_77717_p;
            }
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)MiscPeripherals.instance.blockLanCable, 8, this.id), new Object[]{" R ", "*R*", " R ", Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('*'), arg}));
            return this;
        }

        public CableType setOreDictTexture(String ore, ItemStack fallback) {
            for (ItemStack stack : OreDictionary.getOres((String)ore)) {
                if (stack.field_77993_c <= 0 || stack.field_77993_c >= Block.field_71973_m.length) continue;
                this.sprite = Block.field_71973_m[stack.field_77993_c].func_71858_a(3, stack.func_77960_j());
                return this;
            }
            this.sprite = Block.field_71973_m[fallback.field_77993_c].func_71858_a(3, fallback.func_77960_j());
            return this;
        }
    }
}

