/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.core.util;

import buildcraft.api.transport.IPipeEntry;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import powercrystals.core.block.IAirDropTarget;
import powercrystals.core.inventory.IInventoryManager;
import powercrystals.core.inventory.InventoryManager;
import powercrystals.core.position.BlockPosition;

public abstract class UtilInventory {
    public static Map findPipes(World world, int x, int y, int z) {
        return UtilInventory.findPipes(world, x, y, z, ForgeDirection.VALID_DIRECTIONS);
    }

    public static Map findPipes(World world, int x, int y, int z, ForgeDirection[] directionstocheck) {
        LinkedHashMap<ForgeDirection, IPipeEntry> pipes = new LinkedHashMap<ForgeDirection, IPipeEntry>();
        for (ForgeDirection direction : directionstocheck) {
            BlockPosition bp = new BlockPosition(x, y, z);
            bp.orientation = direction;
            bp.moveForwards(1);
            TileEntity te = world.func_72796_p(bp.x, bp.y, bp.z);
            if (!(te instanceof IPipeEntry)) continue;
            pipes.put(direction, (IPipeEntry)te);
        }
        return pipes;
    }

    public static Map findChests(World world, int x, int y, int z) {
        return UtilInventory.findChests(world, x, y, z, ForgeDirection.VALID_DIRECTIONS);
    }

    public static Map findChests(World world, int x, int y, int z, ForgeDirection[] directionstocheck) {
        LinkedHashMap<ForgeDirection, IInventory> chests = new LinkedHashMap<ForgeDirection, IInventory>();
        for (ForgeDirection direction : directionstocheck) {
            BlockPosition bp = new BlockPosition(x, y, z);
            bp.orientation = direction;
            bp.moveForwards(1);
            TileEntity te = world.func_72796_p(bp.x, bp.y, bp.z);
            if (te == null || !(te instanceof IInventory)) continue;
            chests.put(direction, UtilInventory.checkForDoubleChest(world, te, bp));
        }
        return chests;
    }

    private static IInventory checkForDoubleChest(World world, TileEntity te, BlockPosition chestloc) {
        if (world.func_72798_a(chestloc.x, chestloc.y, chestloc.z) == Block.field_72077_au.field_71990_ca) {
            for (BlockPosition bp : chestloc.getAdjacent(false)) {
                if (world.func_72798_a(bp.x, bp.y, bp.z) != Block.field_72077_au.field_71990_ca) continue;
                return new InventoryLargeChest("Large Chest", (IInventory)te, (IInventory)world.func_72796_p(bp.x, bp.y, bp.z));
            }
        }
        return (IInventory)te;
    }

    public static ItemStack dropStack(TileEntity from, ItemStack stack) {
        return UtilInventory.dropStack(from.field_70331_k, new BlockPosition(from.field_70329_l, from.field_70330_m, from.field_70327_n), stack, ForgeDirection.VALID_DIRECTIONS, ForgeDirection.UNKNOWN);
    }

    public static ItemStack dropStack(TileEntity from, ItemStack stack, ForgeDirection airdropdirection) {
        return UtilInventory.dropStack(from.field_70331_k, new BlockPosition(from.field_70329_l, from.field_70330_m, from.field_70327_n), stack, ForgeDirection.VALID_DIRECTIONS, airdropdirection);
    }

    public static ItemStack dropStack(TileEntity from, ItemStack stack, ForgeDirection dropdirection, ForgeDirection airdropdirection) {
        ForgeDirection[] dropdirections = new ForgeDirection[]{dropdirection};
        return UtilInventory.dropStack(from.field_70331_k, new BlockPosition(from.field_70329_l, from.field_70330_m, from.field_70327_n), stack, dropdirections, airdropdirection);
    }

    public static ItemStack dropStack(TileEntity from, ItemStack stack, ForgeDirection[] dropdirections, ForgeDirection airdropdirection) {
        return UtilInventory.dropStack(from.field_70331_k, new BlockPosition(from.field_70329_l, from.field_70330_m, from.field_70327_n), stack, dropdirections, airdropdirection);
    }

    public static ItemStack dropStack(World world, BlockPosition bp, ItemStack stack, ForgeDirection[] dropdirections, ForgeDirection airdropdirection) {
        if (stack == null || stack.field_77994_a == 0 || world.field_72995_K || stack.func_77973_b() == null) {
            return stack;
        }
        stack = stack.func_77946_l();
        for (Map.Entry pipe : UtilInventory.findPipes(world, bp.x, bp.y, bp.z, dropdirections).entrySet()) {
            if (!((IPipeEntry)pipe.getValue()).acceptItems()) continue;
            ((IPipeEntry)pipe.getValue()).entityEntering(stack.func_77946_l(), (ForgeDirection)pipe.getKey());
            return null;
        }
        for (Map.Entry chest : UtilInventory.findChests(world, bp.x, bp.y, bp.z, dropdirections).entrySet()) {
            IInventoryManager manager = InventoryManager.create((IInventory)chest.getValue(), ((ForgeDirection)chest.getKey()).getOpposite());
            stack = manager.addItem(stack);
            if (stack != null && stack.field_77994_a != 0) continue;
            return null;
        }
        bp.orientation = airdropdirection;
        bp.moveForwards(1);
        TileEntity droppingInto = world.func_72796_p(bp.x, bp.y, bp.z);
        if (Arrays.asList(ForgeDirection.VALID_DIRECTIONS).contains(airdropdirection) && (world.func_72799_c(bp.x, bp.y, bp.z) || droppingInto != null && droppingInto instanceof IAirDropTarget)) {
            bp.moveBackwards(1);
            UtilInventory.dropStackInAir(stack, bp, world, airdropdirection);
            return null;
        }
        return stack;
    }

    private static void dropStackInAir(ItemStack stack, BlockPosition bp, World world, ForgeDirection towards) {
        float dropOffsetX = 0.0f;
        float dropOffsetY = 0.0f;
        float dropOffsetZ = 0.0f;
        switch (towards) {
            case UNKNOWN: 
            case UP: {
                dropOffsetX = 0.5f;
                dropOffsetY = 1.5f;
                dropOffsetZ = 0.5f;
                break;
            }
            case DOWN: {
                dropOffsetX = 0.5f;
                dropOffsetY = -0.75f;
                dropOffsetZ = 0.5f;
                break;
            }
            case NORTH: {
                dropOffsetX = 0.5f;
                dropOffsetY = 0.5f;
                dropOffsetZ = -0.5f;
                break;
            }
            case SOUTH: {
                dropOffsetX = 0.5f;
                dropOffsetY = 0.5f;
                dropOffsetZ = 1.5f;
                break;
            }
            case EAST: {
                dropOffsetX = 1.5f;
                dropOffsetY = 0.5f;
                dropOffsetZ = 0.5f;
                break;
            }
            case WEST: {
                dropOffsetX = -0.5f;
                dropOffsetY = 0.5f;
                dropOffsetZ = 0.5f;
                break;
            }
        }
        EntityItem entityitem = new EntityItem(world, (double)((float)bp.x + dropOffsetX), (double)((float)bp.y + dropOffsetY), (double)((float)bp.z + dropOffsetZ), stack.func_77946_l());
        entityitem.field_70159_w = 0.0;
        if (towards != ForgeDirection.DOWN) {
            entityitem.field_70181_x = 0.3;
        }
        entityitem.field_70179_y = 0.0;
        entityitem.field_70293_c = 20;
        world.func_72838_d((Entity)entityitem);
    }

    public static ItemStack consumeItem(ItemStack stack) {
        if (stack.field_77994_a == 1) {
            if (stack.func_77973_b().func_77634_r()) {
                return stack.func_77973_b().getContainerItemStack(stack);
            }
            return null;
        }
        return stack.func_77979_a(1);
    }

    public static void mergeStacks(ItemStack to, ItemStack from) {
        if (to == null || from == null) {
            return;
        }
        if (to.field_77993_c != from.field_77993_c || to.func_77960_j() != from.func_77960_j()) {
            return;
        }
        if (to.func_77978_p() != null || from.func_77978_p() != null) {
            return;
        }
        int amountToCopy = Math.min(to.func_77976_d() - to.field_77994_a, from.field_77994_a);
        to.field_77994_a += amountToCopy;
        from.field_77994_a -= amountToCopy;
    }
}

