/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.core.updater;

import cpw.mods.fml.common.FMLLog;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.logging.Level;
import powercrystals.core.updater.IUpdateableMod;
import powercrystals.core.updater.ModVersion;

public class UpdateCheckThread
extends Thread {
    private String _releaseUrl;
    private IUpdateableMod _mod;
    private boolean _checkComplete;
    private boolean _newVerAvailable;
    private ModVersion _newVer;

    public UpdateCheckThread(IUpdateableMod mod) {
        this(mod, null);
    }

    public UpdateCheckThread(IUpdateableMod mod, String releaseUrl) {
        this._mod = mod;
        if (releaseUrl == null) {
            releaseUrl = "https://raw.github.com/powercrystals/" + mod.getModId() + "/master/VERSION";
        }
        this._releaseUrl = releaseUrl;
    }

    @Override
    public void run() {
        try {
            URL versionFile = new URL(this._releaseUrl);
            BufferedReader reader = new BufferedReader(new InputStreamReader(versionFile.openStream()));
            ModVersion newVer = ModVersion.parse(reader.readLine());
            ModVersion ourVer = ModVersion.parse(this._mod.getModVersion());
            reader.close();
            if (ourVer.compareTo(newVer) < 0) {
                FMLLog.log((Level)Level.INFO, (String)("An updated version of " + this._mod.getModName() + " is available: " + newVer.modVersion().toString() + "."), (Object[])new Object[0]);
                if (ourVer.minecraftVersion().compareTo(newVer.minecraftVersion()) < 0) {
                    FMLLog.log((Level)Level.INFO, (String)("This update is for Minecraft " + newVer.minecraftVersion().toString() + "."), (Object[])new Object[0]);
                }
            }
            this._newVer = newVer;
            this._newVerAvailable = ourVer.compareTo(newVer) < 0;
            this._checkComplete = true;
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.WARNING, (String)("Update check for " + this._mod.getModName() + " failed: " + e.getMessage()), (Object[])new Object[0]);
            e.printStackTrace();
        }
    }

    public boolean checkComplete() {
        return this._checkComplete;
    }

    public boolean newVersionAvailable() {
        return this._newVerAvailable;
    }

    public ModVersion newVersion() {
        return this._newVer;
    }
}

