/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.core.gui.controls;

import net.minecraft.client.gui.inventory.GuiContainer;
import org.lwjgl.opengl.GL11;
import powercrystals.core.gui.Control;
import powercrystals.core.gui.GuiColor;
import powercrystals.core.gui.GuiRender;

public abstract class SliderHorizontal
extends Control {
    private int _value;
    private int _valueMax;
    private boolean _isDragging;
    public int borderColor = new GuiColor(120, 120, 120, 255).getColor();
    public int backgroundColor = new GuiColor(0, 0, 0, 255).getColor();

    protected SliderHorizontal(GuiContainer containerScreen, int x, int y, int width, int height, int maxValue) {
        super(containerScreen, x, y, width, height);
        this._valueMax = maxValue;
    }

    public void setValue(int value) {
        if (value != this._value && value >= 0 && value <= this._valueMax) {
            this._value = value;
            this.onValueChanged(this._value);
        }
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float gameTicks) {
        GuiRender.drawRect(this.x - 1, this.y - 1, this.x + this.width + 1, this.y + this.height + 1, this.borderColor);
        GuiRender.drawRect(this.x, this.y, this.x + this.width, this.y + this.height, this.backgroundColor);
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        int sliderWidth = 8;
        int sliderHeight = this.height;
        int sliderX = this.x + (this.width - sliderWidth) * this._value / this._valueMax;
        int sliderY = this.y;
        if (this.enabled && this.isPointInBounds(mouseX, mouseY)) {
            this.containerScreen.field_73882_e.field_71446_o.func_98187_b("/powercrystals/core/textures/button_hover.png");
        } else if (this.enabled) {
            this.containerScreen.field_73882_e.field_71446_o.func_98187_b("/powercrystals/core/textures/button_enabled.png");
        } else {
            this.containerScreen.field_73882_e.field_71446_o.func_98187_b("/powercrystals/core/textures/button_disabled.png");
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiRender.drawTexturedModalRect(sliderX, sliderY, 0, 0, sliderWidth / 2, sliderHeight / 2);
        GuiRender.drawTexturedModalRect(sliderX, sliderY + sliderHeight / 2, 0, 256 - sliderHeight / 2, sliderWidth / 2, sliderHeight / 2);
        GuiRender.drawTexturedModalRect(sliderX + sliderWidth / 2, sliderY, 256 - sliderWidth / 2, 0, sliderWidth / 2, sliderHeight / 2);
        GuiRender.drawTexturedModalRect(sliderX + sliderWidth / 2, sliderY + sliderHeight / 2, 256 - this.width / 2, 256 - sliderHeight / 2, sliderWidth / 2, sliderHeight / 2);
    }

    @Override
    public boolean onMousePressed(int mouseX, int mouseY, int mouseButton) {
        this._isDragging = true;
        return true;
    }

    @Override
    public void onMouseReleased(int mouseX, int mouseY) {
        this._isDragging = false;
    }

    @Override
    public void updateTick(int mouseX, int mouseY) {
        if (this._isDragging) {
            this.setValue(this._valueMax * (mouseX - this.x) / this.width);
        }
    }

    public abstract void onValueChanged(int var1);
}

