/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.core.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import powercrystals.core.block.BlockFluidRoot;

public class BlockFluidFinite
extends BlockFluidRoot {
    public BlockFluidFinite(int id, Material material) {
        super(id, material);
    }

    public void func_71847_b(World world, int x, int y, int z, Random rand) {
        int quantaRemaining;
        boolean changed = false;
        int prevRemaining = quantaRemaining = world.func_72805_g(x, y, z) + 1;
        if ((quantaRemaining = this.tryToFlowVerticallyInto(world, x, y, z, quantaRemaining)) < 1) {
            return;
        }
        if (quantaRemaining != prevRemaining) {
            changed = true;
            if (quantaRemaining == 1) {
                world.func_72921_c(x, y, z, quantaRemaining - 1, 2);
                return;
            }
        } else if (quantaRemaining == 1) {
            return;
        }
        int lowerthan = quantaRemaining - 1;
        if (this.displaceIfPossible(world, x, y, z - 1)) {
            world.func_94575_c(x, y, z - 1, 0);
        }
        if (this.displaceIfPossible(world, x, y, z + 1)) {
            world.func_94575_c(x, y, z + 1, 0);
        }
        if (this.displaceIfPossible(world, x - 1, y, z)) {
            world.func_94575_c(x - 1, y, z, 0);
        }
        if (this.displaceIfPossible(world, x + 1, y, z)) {
            world.func_94575_c(x + 1, y, z, 0);
        }
        int north = this.getQuantaValueBelow((IBlockAccess)world, x, y, z - 1, lowerthan);
        int south = this.getQuantaValueBelow((IBlockAccess)world, x, y, z + 1, lowerthan);
        int west = this.getQuantaValueBelow((IBlockAccess)world, x - 1, y, z, lowerthan);
        int east = this.getQuantaValueBelow((IBlockAccess)world, x + 1, y, z, lowerthan);
        int total = quantaRemaining;
        int count = 1;
        if (north >= 0) {
            ++count;
            total += north;
        }
        if (south >= 0) {
            ++count;
            total += south;
        }
        if (west >= 0) {
            ++count;
            total += west;
        }
        if (east >= 0) {
            ++count;
            total += east;
        }
        if (count == 1) {
            if (changed) {
                world.func_72921_c(x, y, z, quantaRemaining - 1, 2);
            }
            return;
        }
        int each = total / count;
        int rem = total % count;
        if (north >= 0) {
            int newnorth = each;
            if (rem == count || rem > 1 && rand.nextInt(count - rem) != 0) {
                ++newnorth;
                --rem;
            }
            if (newnorth != north) {
                if (newnorth == 0) {
                    world.func_94575_c(x, y, z - 1, 0);
                } else {
                    world.func_72832_d(x, y, z - 1, this.field_71990_ca, newnorth - 1, 2);
                }
                world.func_72836_a(x, y, z - 1, this.field_71990_ca, this.tickRate);
            }
            --count;
        }
        if (south >= 0) {
            int newsouth = each;
            if (rem == count || rem > 1 && rand.nextInt(count - rem) != 0) {
                ++newsouth;
                --rem;
            }
            if (newsouth != south) {
                if (newsouth == 0) {
                    world.func_94575_c(x, y, z + 1, 0);
                } else {
                    world.func_72832_d(x, y, z + 1, this.field_71990_ca, newsouth - 1, 2);
                }
                world.func_72836_a(x, y, z + 1, this.field_71990_ca, this.tickRate);
            }
            --count;
        }
        if (west >= 0) {
            int newwest = each;
            if (rem == count || rem > 1 && rand.nextInt(count - rem) != 0) {
                ++newwest;
                --rem;
            }
            if (newwest != west) {
                if (newwest == 0) {
                    world.func_94575_c(x - 1, y, z, 0);
                } else {
                    world.func_72832_d(x - 1, y, z, this.field_71990_ca, newwest - 1, 2);
                }
                world.func_72836_a(x - 1, y, z, this.field_71990_ca, this.tickRate);
            }
            --count;
        }
        if (east >= 0) {
            int neweast = each;
            if (rem == count || rem > 1 && rand.nextInt(count - rem) != 0) {
                ++neweast;
                --rem;
            }
            if (neweast != east) {
                if (neweast == 0) {
                    world.func_94575_c(x + 1, y, z, 0);
                } else {
                    world.func_72832_d(x + 1, y, z, this.field_71990_ca, neweast - 1, 2);
                }
                world.func_72836_a(x + 1, y, z, this.field_71990_ca, this.tickRate);
            }
            --count;
        }
        if (rem > 0) {
            ++each;
        }
        world.func_72921_c(x, y, z, each - 1, 2);
    }

    public int tryToFlowVerticallyInto(World world, int x, int y, int z, int amtToInput) {
        int otherY = y + this.densityDir;
        if (otherY < 0 || otherY >= world.func_72800_K()) {
            world.func_94571_i(x, y, z);
            return 0;
        }
        int amt = this.getQuantaValueBelow((IBlockAccess)world, x, otherY, z, this.quantaPerBlock);
        if (amt >= 0) {
            if ((amt += amtToInput) > this.quantaPerBlock) {
                world.func_72832_d(x, otherY, z, this.field_71990_ca, this.quantaPerBlock - 1, 3);
                world.func_72836_a(x, otherY, z, this.field_71990_ca, this.tickRate);
                return amt - this.quantaPerBlock;
            }
            if (amt > 0) {
                world.func_72832_d(x, otherY, z, this.field_71990_ca, amt - 1, 3);
                world.func_72836_a(x, otherY, z, this.field_71990_ca, this.tickRate);
                world.func_94571_i(x, y, z);
                return 0;
            }
            return amtToInput;
        }
        int density_other = BlockFluidFinite.getDensity((IBlockAccess)world, x, otherY, z);
        if (density_other == Integer.MAX_VALUE) {
            if (this.displaceIfPossible(world, x, otherY, z)) {
                world.func_72832_d(x, otherY, z, this.field_71990_ca, amtToInput - 1, 3);
                world.func_72836_a(x, otherY, z, this.field_71990_ca, this.tickRate);
                world.func_94571_i(x, y, z);
                return 0;
            }
            return amtToInput;
        }
        if (this.densityDir < 0) {
            if (density_other < this.density) {
                int bId = world.func_72798_a(x, otherY, z);
                BlockFluidRoot block = (BlockFluidRoot)Block.field_71973_m[bId];
                int otherData = world.func_72805_g(x, otherY, z);
                world.func_72832_d(x, otherY, z, this.field_71990_ca, amtToInput - 1, 3);
                world.func_72832_d(x, y, z, bId, otherData, 3);
                world.func_72836_a(x, otherY, z, this.field_71990_ca, this.tickRate);
                world.func_72836_a(x, y, z, bId, block.func_71859_p_(world));
                return 0;
            }
        } else if (density_other > this.density) {
            int bId = world.func_72798_a(x, otherY, z);
            BlockFluidRoot block = (BlockFluidRoot)Block.field_71973_m[bId];
            int otherData = world.func_72805_g(x, otherY, z);
            world.func_72832_d(x, otherY, z, this.field_71990_ca, amtToInput - 1, 3);
            world.func_72832_d(x, y, z, bId, otherData, 3);
            world.func_72836_a(x, otherY, z, this.field_71990_ca, this.tickRate);
            world.func_72836_a(x, y, z, bId, block.func_71859_p_(world));
            return 0;
        }
        return amtToInput;
    }
}

