/*
 * Decompiled with CFR 0.152.
 */
package factorization.nei;

import codechicken.nei.PositionedStack;
import codechicken.nei.forge.GuiContainerManager;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import factorization.client.gui.GuiCrystallizer;
import factorization.common.Core;
import factorization.common.TileEntityCrystallizer;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class RecipeCrystallizer
extends TemplateRecipeHandler {
    public void loadCraftingRecipes(ItemStack result) {
        for (TileEntityCrystallizer.CrystalRecipe cr : TileEntityCrystallizer.recipes) {
            if (result != null && !result.func_77969_a(cr.output)) continue;
            this.arecipes.add(new CachedCrystallizerRecipe(cr));
        }
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("fz.crystallizing")) {
            this.loadCraftingRecipes(null);
            return;
        }
        super.loadCraftingRecipes(outputId, results);
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (TileEntityCrystallizer.CrystalRecipe cr : TileEntityCrystallizer.recipes) {
            if (ingredient != null && !ingredient.func_77969_a(cr.input) && (ingredient.func_77973_b() != Core.registry.inverium || cr.inverium_count <= 0) && !ingredient.func_77969_a(cr.solution)) continue;
            this.arecipes.add(new CachedCrystallizerRecipe(cr));
        }
    }

    public List handleItemTooltip(GuiRecipe gui, ItemStack stack, List currenttip, int recipe) {
        if (stack == null) {
            return currenttip;
        }
        TileEntityCrystallizer.CrystalRecipe cr = ((CachedCrystallizerRecipe)((Object)this.arecipes.get((int)recipe))).cr;
        if (stack.func_77969_a(cr.output)) {
            float prob = cr.output_count * 100.0f;
            if (prob == 100.0f) {
                // empty if block
            }
            currenttip.add((int)prob + "%");
        }
        if (stack.func_77969_a(cr.solution)) {
            currenttip.add("Does not get used up");
        }
        if (stack.func_77969_a(cr.input)) {
            currenttip.add("Extra copies of this can be added");
            currenttip.add("to the other slots to increase yield");
        }
        if (stack.func_77969_a(Core.registry.heater_item)) {
            currenttip.add("Use this to heat the crystallizer");
        }
        return currenttip;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(98, 78, 32, 16), "fz.crystallizing", new Object[0]));
    }

    public Class getGuiClass() {
        return GuiCrystallizer.class;
    }

    public String getRecipeName() {
        return "Crystallizer";
    }

    public String getGuiTexture() {
        return "/mods/factorization/textures/gui/crystal.png";
    }

    public String getOverlayIdentifier() {
        return "fz.crystallizing";
    }

    public void drawBackground(GuiContainerManager gui, int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        gui.bindTexture(this.getGuiTexture());
        gui.drawTexturedModalRect(0, 15, 5, 11, 166, 95);
    }

    public void drawExtras(GuiContainerManager gui, int recipe) {
        super.drawExtras(gui, recipe);
    }

    public int recipiesPerPage() {
        return 1;
    }

    class CachedCrystallizerRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        TileEntityCrystallizer.CrystalRecipe cr;

        public CachedCrystallizerRecipe(TileEntityCrystallizer.CrystalRecipe cr) {
            super((TemplateRecipeHandler)RecipeCrystallizer.this);
            this.cr = cr;
        }

        public PositionedStack getResult() {
            return new PositionedStack((Object)this.cr.output, 75, 44);
        }

        public PositionedStack getIngredient() {
            return null;
        }

        public ArrayList getOtherStacks() {
            ArrayList<PositionedStack> ret = new ArrayList<PositionedStack>();
            ret.add(new PositionedStack((Object)this.cr.input, 75, 17));
            if (this.cr.inverium_count > 0) {
                ItemStack inverium = new ItemStack((Item)Core.registry.inverium, this.cr.inverium_count, 1);
                ret.add(new PositionedStack((Object)inverium, 103, 59));
                ret.add(new PositionedStack((Object)this.cr.solution, 47, 59));
            } else {
                ret.add(new PositionedStack((Object)this.cr.solution, 75, 73));
            }
            ret.add(new PositionedStack((Object)Core.registry.heater_item, 0, 75));
            return ret;
        }
    }
}

