/*
 * Decompiled with CFR 0.152.
 */
package factorization.common.servo.actuators;

import factorization.api.Coord;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.DataInNBT;
import factorization.api.datahelpers.IDataSerializable;
import factorization.api.datahelpers.Share;
import factorization.common.Core;
import factorization.common.FactorizationUtil;
import factorization.common.servo.ActuatorItem;
import java.io.IOException;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumMovingObjectType;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.common.ForgeDirection;

public class ActuatorItemSyringe
extends ActuatorItem {
    public ActuatorItemSyringe(int itemId) {
        super(itemId, "servo/actuator.item_syringe");
        this.func_77664_n();
    }

    boolean giveItem(State state, ItemStack actuator_is, Entity user, MovingObjectPosition mop) throws IOException {
        FactorizationUtil.FzInv target_inv = this.getInv(user, mop);
        if (target_inv == null) {
            return false;
        }
        if (state.slot != -1) {
            target_inv = target_inv.slice(state.slot, state.slot + 1);
        }
        return FactorizationUtil.openInventory(user, true).transfer(target_inv, state.limit, actuator_is);
    }

    boolean takeItem(State state, ItemStack actuator_is, Entity user, MovingObjectPosition mop) throws IOException {
        FactorizationUtil.FzInv target_inv = this.getInv(user, mop);
        if (target_inv == null) {
            return false;
        }
        if (state.slot != -1) {
            target_inv = target_inv.slice(state.slot, state.slot + 1);
        }
        FactorizationUtil.FzInv user_inv = FactorizationUtil.openInventory(user, true);
        return target_inv.transfer(user_inv, state.limit, actuator_is);
    }

    FactorizationUtil.FzInv getInv(Entity user, MovingObjectPosition mop) {
        if (mop.field_72313_a == EnumMovingObjectType.TILE) {
            Coord here = new Coord(user.field_70170_p, mop);
            return FactorizationUtil.openInventory((IInventory)here.getTE(IInventory.class), ForgeDirection.getOrientation((int)mop.field_72310_e));
        }
        if (mop.field_72313_a == EnumMovingObjectType.ENTITY) {
            return FactorizationUtil.openInventory(mop.field_72308_g, false);
        }
        return null;
    }

    @Override
    public boolean use(ItemStack is, Entity user, MovingObjectPosition mop) throws IOException {
        if (user.field_70170_p.field_72995_K) {
            return true;
        }
        State state = (State)new DataInNBT(FactorizationUtil.getTag(is)).as(Share.VISIBLE, "").put(new State());
        if (ActuatorItemSyringe.isSneaking(user)) {
            this.giveItem(state, is, user, mop);
        } else {
            this.takeItem(state, is, user, mop);
        }
        if (user instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)user;
            Core.proxy.updatePlayerInventory(player);
        }
        return true;
    }

    @Override
    public IDataSerializable getState() {
        return new State();
    }

    @Override
    public void addConfigurationInfo(ItemStack is, List infoList) throws IOException {
        State state = (State)new DataInNBT(FactorizationUtil.getTag(is)).as(Share.VISIBLE, "").put(new State());
        infoList.add("Slot: " + (state.slot == -1 ? "Any" : Integer.valueOf(state.slot)));
        infoList.add("Size: " + state.limit);
    }

    private static class State
    implements IDataSerializable {
        int slot = -1;
        int limit = 64;

        private State() {
        }

        @Override
        public IDataSerializable serialize(String prefix, DataHelper data) throws IOException {
            this.slot = (Integer)data.asSameShare(prefix + "slot").put(this.slot);
            this.limit = (Integer)data.asSameShare(prefix + "limit").put(this.limit);
            return this;
        }
    }
}

