/*
 * Decompiled with CFR 0.152.
 */
package factorization.common.servo;

import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.IDataSerializable;
import factorization.api.datahelpers.Share;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;

public class ServoStack
implements IDataSerializable,
Iterable {
    private LinkedList contents = new LinkedList();
    private final int maxSize = 16;

    public void setContentsList(LinkedList obj) {
        this.contents = obj;
    }

    public boolean push(Object o) {
        if (this.contents.size() >= 16) {
            return false;
        }
        this.contents.addFirst(o);
        return true;
    }

    public boolean append(Object o) {
        if (this.contents.size() >= 16) {
            return false;
        }
        this.contents.add(o);
        return true;
    }

    public void forceAppend(Object o) {
        this.contents.add(o);
    }

    public Object pop() {
        if (this.contents.isEmpty()) {
            return null;
        }
        return this.contents.removeFirst();
    }

    public Object popEnd() {
        if (this.contents.isEmpty()) {
            return null;
        }
        return this.contents.removeLast();
    }

    public Object popType(Class eClass) {
        return this.popType(eClass, true);
    }

    public Object remove(int index) {
        if (index >= this.contents.size()) {
            return null;
        }
        return this.contents.remove(index);
    }

    public Object findType(Class eClass) {
        return this.popType(eClass, false);
    }

    private Object popType(Class eClass, boolean remove) {
        Iterator it = this.contents.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (o.getClass() != eClass) continue;
            if (remove) {
                it.remove();
            }
            return o;
        }
        return null;
    }

    public Iterator iterator() {
        return this.contents.iterator();
    }

    public int getMaxSize() {
        return 16;
    }

    public int getFreeSpace() {
        return Math.max(0, 16 - this.contents.size());
    }

    public int getSize() {
        return this.contents.size();
    }

    @Override
    public IDataSerializable serialize(String prefix, DataHelper data) throws IOException {
        int length = data.asSameShare(prefix + "_size").putInt(this.contents.size());
        if (length == 0) {
            return this;
        }
        prefix = prefix + "#";
        if (data.isWriter()) {
            int i = 0;
            for (Object o : this.contents) {
                data.asSameShare(prefix + i++).putUntypedOject(o);
            }
        } else {
            this.contents.clear();
            for (int i = 0; i < length; ++i) {
                Object n = data.asSameShare(prefix + i).putUntypedOject(null);
                if (n == null) continue;
                this.contents.add(n);
            }
        }
        return this;
    }

    public DataHelper getDataHelper(boolean reader) {
        return new DataServoStack(reader);
    }

    public String toString() {
        return this.contents.toString();
    }

    private class DataServoStack
    extends DataHelper {
        final boolean reader;

        public DataServoStack(boolean reader) {
            this.reader = reader;
        }

        @Override
        protected boolean shouldStore(Share share) {
            return true;
        }

        @Override
        public boolean isReader() {
            return this.reader;
        }

        @Override
        protected Object putImplementation(Object value) throws IOException {
            if (this.reader) {
                Object ret = ServoStack.this.popType(value.getClass());
                if (ret == null) {
                    throw new IOException();
                }
                return ret;
            }
            ServoStack.this.push(value);
            return value;
        }
    }
}

