/*
 * Decompiled with CFR 0.152.
 */
package factorization.common.servo;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.Coord;
import factorization.api.DeltaCoord;
import factorization.api.FzOrientation;
import factorization.api.IChargeConductor;
import factorization.api.IEntityMessage;
import factorization.api.Quaternion;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.DataInNBT;
import factorization.api.datahelpers.DataInPacket;
import factorization.api.datahelpers.DataOutNBT;
import factorization.api.datahelpers.DataOutPacket;
import factorization.api.datahelpers.Share;
import factorization.common.Core;
import factorization.common.FactorizationUtil;
import factorization.common.servo.ActuatorItem;
import factorization.common.servo.ServoStack;
import factorization.common.servo.Signal;
import factorization.common.servo.TileEntityServoRail;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class ServoMotor
extends Entity
implements IEntityAdditionalSpawnData,
IEntityMessage,
IInventory {
    public static final int STACKS = 16;
    public static final int STACK_EQUIPMENT = 0;
    public static final int STACK_ARGUMENT = 1;
    public static final int STACK_IO = 2;
    public static final int STACK_CONFIG = 3;
    public static final int STACK_ERRNO = 4;
    private ServoStack[] stacks = new ServoStack[16];
    private ItemStack[] inv;
    private ItemStack[] inv_last_sent;
    public boolean sneaking;
    public int next_stack;
    boolean dampenVelocity;
    Coord pos_prev;
    Coord pos_next;
    float pos_progress;
    public FzOrientation prevOrientation;
    public FzOrientation orientation;
    public ForgeDirection nextDirection;
    private byte speed_b;
    private static final double max_speed_b = 127.0;
    double accumulated_motion;
    boolean new_motor;
    double sprocket_rotation;
    double prev_sprocket_rotation;
    double servo_reorient;
    double prev_servo_reorient;
    static final double maxSpeed = 0.0875;
    static final double slowedSpeed = 0.0043749999999999995;
    static final double minSpeed = 4.3749999999999995E-4;
    private boolean need_description_packet;
    private static Quaternion target_orientation = new Quaternion();
    private static final ItemStack EMPTY_ITEM = new ItemStack(0, 0, 0);
    private FactorizationUtil.FzInv my_fz_inv;

    public ServoMotor(World world) {
        super(world);
        for (int i = 0; i < this.stacks.length; ++i) {
            this.stacks[i] = new ServoStack();
        }
        this.inv = new ItemStack[9];
        this.inv_last_sent = new ItemStack[this.inv.length];
        this.sneaking = false;
        this.next_stack = 0;
        this.prevOrientation = FzOrientation.UNKNOWN;
        this.orientation = FzOrientation.UNKNOWN;
        this.nextDirection = ForgeDirection.UNKNOWN;
        this.new_motor = true;
        this.sprocket_rotation = 0.0;
        this.prev_sprocket_rotation = 0.0;
        this.servo_reorient = 0.0;
        this.prev_servo_reorient = 0.0;
        this.need_description_packet = false;
        this.my_fz_inv = FactorizationUtil.openInventory((IInventory)this, 0);
        this.func_70105_a(1.0f, 1.0f);
        double d = 0.5;
        this.pos_prev = new Coord(world, 0, 0, 0);
        this.pos_next = this.pos_prev.copy();
    }

    public void spawnServoMotor() {
        this.pos_prev = new Coord(this);
        this.pos_next = this.pos_prev.copy();
        this.pickNextOrientation();
        this.pickNextOrientation();
        this.interpolatePosition(0.0f);
        this.field_70170_p.func_72838_d((Entity)this);
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        try {
            this.putData(new DataInNBT(nbttagcompound));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        try {
            this.putData(new DataOutNBT(nbttagcompound));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void readSpawnData(ByteArrayDataInput data) {
        try {
            this.putData(new DataInPacket((DataInput)data, Side.CLIENT));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
    }

    public void writeSpawnData(ByteArrayDataOutput data) {
        try {
            this.putData(new DataOutPacket((DataOutput)data, Side.SERVER));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
    }

    void putData(DataHelper data) throws IOException {
        int i;
        data.as(Share.VISIBLE, "controller");
        this.prevOrientation = data.as(Share.PRIVATE, "prevOrient").putFzOrientation(this.prevOrientation);
        this.orientation = data.as(Share.VISIBLE, "Orient").putFzOrientation(this.orientation);
        this.nextDirection = (ForgeDirection)data.as(Share.VISIBLE, "nextDir").putEnum((Enum)this.nextDirection);
        this.speed_b = data.as(Share.VISIBLE, "speedb").putByte(this.speed_b);
        this.accumulated_motion = data.as(Share.PRIVATE, "accumulated_motion").putDouble(this.accumulated_motion);
        this.pos_next = (Coord)data.as(Share.VISIBLE, "pos_next").put(this.pos_next);
        this.pos_prev = (Coord)data.as(Share.VISIBLE, "pos_prev").put(this.pos_prev);
        this.pos_progress = data.as(Share.VISIBLE, "pos_progress").putFloat(this.pos_progress);
        this.new_motor = data.as(Share.PRIVATE, "new").putBoolean(this.new_motor);
        for (i = 0; i < 16; ++i) {
            String name2 = "stack" + i;
            this.stacks[i] = (ServoStack)data.as(Share.VISIBLE, name2).put(this.stacks[i]);
        }
        this.next_stack = data.as(Share.VISIBLE, "next_stack").putInt(this.next_stack);
        for (i = 0; i < this.inv.length; ++i) {
            ItemStack is = this.inv[i] == null ? EMPTY_ITEM : this.inv[i];
            is = data.as(Share.VISIBLE, "inv" + i).putItemStack(is);
            this.inv[i] = is == null ? is : (is.field_77993_c == 0 ? null : is);
        }
    }

    boolean validPosition(Coord c) {
        return c.getTE(TileEntityServoRail.class) != null;
    }

    boolean validDirection(ForgeDirection dir) {
        return this.validPosition(this.getCurrentPos().add(dir));
    }

    void checkDirection() {
        if (this.validDirection(this.orientation.facing)) {
            return;
        }
        if (this.validDirection(this.nextDirection)) {
            this.swapOrientations();
            return;
        }
        this.speed_b = 0;
        this.orientation = FzOrientation.UNKNOWN;
    }

    public void func_70030_z() {
        if (this.new_motor && this.prevOrientation == FzOrientation.UNKNOWN) {
            this.prevOrientation = this.orientation;
        }
        if (this.field_70173_aa == 1) {
            this.checkDirection();
        }
        super.func_70030_z();
        if (this.field_70170_p.field_72995_K) {
            this.doLogic();
        } else {
            byte orig_speed = this.speed_b;
            this.doLogic();
            this.need_description_packet |= orig_speed != this.speed_b;
            if (this.need_description_packet) {
                this.need_description_packet = false;
                this.describe();
            }
        }
        this.interpolatePosition(this.pos_progress);
    }

    public void interpolatePosition(float interp) {
        this.func_70107_b(ServoMotor.ip(this.pos_prev.x, this.pos_next.x, interp), ServoMotor.ip(this.pos_prev.y, this.pos_next.y, interp), ServoMotor.ip(this.pos_prev.z, this.pos_next.z, interp));
    }

    static double ip(int a, int b, float interp) {
        return (float)a + (float)(b - a) * interp;
    }

    void updateSpeed() {
        boolean should_accelerate;
        double speed = this.getProperSpeed();
        boolean bl = should_accelerate = speed < 0.0875 && this.orientation != FzOrientation.UNKNOWN;
        if (this.dampenVelocity || this.hasSignal(Signal.STOP_MOTOR) || this.hasSignal(Signal.SLOW_MOTOR)) {
            this.speed_b = (byte)(this.speed_b * 2 / 3);
            if (speed < 0.0043749999999999995) {
                this.dampenVelocity = false;
                if (this.hasSignal(Signal.STOP_MOTOR) && speed < 4.3749999999999995E-4) {
                    this.speed_b = 0;
                }
            }
            should_accelerate = false;
        }
        if (Core.cheat_servo_energy) {
            if (should_accelerate) {
                this.accelerate();
            }
        } else {
            long now = this.field_70170_p.func_82737_E();
            IChargeConductor conductor = (IChargeConductor)this.getCurrentPos().getTE(IChargeConductor.class);
            boolean failure = true;
            if (conductor != null) {
                int to_drain = 0;
                if (should_accelerate) {
                    if (now % 3L == 0L) {
                        to_drain = 2;
                    } else {
                        should_accelerate = false;
                    }
                } else if (now % 60L == 0L) {
                    to_drain = 1;
                }
                if (to_drain > 0 && should_accelerate && conductor.getCharge().tryTake(to_drain) >= to_drain) {
                    this.accelerate();
                    failure = false;
                } else if (to_drain == 0) {
                    failure = false;
                }
            }
            if (failure) {
                this.speed_b = (byte)Math.max(this.speed_b - 1, 0);
            }
        }
    }

    void doLogic() {
        double speed;
        if (this.orientation == FzOrientation.UNKNOWN) {
            this.pickNextOrientation();
        }
        if (!this.field_70170_p.field_72995_K) {
            this.updateSpeed();
        }
        if ((speed = this.getProperSpeed()) <= 0.0 || this.orientation == FzOrientation.UNKNOWN) {
            return;
        }
        this.accumulated_motion += speed;
        this.moveMotor();
        if (this.pos_progress >= 1.0f) {
            this.pos_progress -= 1.0f;
            this.accumulated_motion = Math.min((double)this.pos_progress, speed);
            this.pos_prev = this.pos_next;
            this.onEnterNewBlock();
            this.pickNextOrientation();
        }
    }

    public Random getRandom() {
        Random rand = FactorizationUtil.dirtyRandomCache();
        long seed = this.field_70157_k + this.getCurrentPos().seed() << 5 + this.orientation.ordinal() << 2 + this.nextDirection.ordinal();
        rand.setSeed(seed);
        return rand;
    }

    public boolean testDirection(ForgeDirection d) {
        if (d == ForgeDirection.UNKNOWN) {
            return false;
        }
        return this.validDirection(d);
    }

    static int similarity(FzOrientation base, FzOrientation novel) {
        int score = 0;
        return score;
    }

    boolean pickNextOrientation() {
        boolean ret = this.pickNextOrientation_impl();
        this.pos_next = this.pos_prev.add(this.orientation.facing);
        return ret;
    }

    public void swapOrientations() {
        ForgeDirection orig_direction = this.orientation.facing;
        ForgeDirection orig_top = this.orientation.top;
        FzOrientation start = FzOrientation.fromDirection(this.nextDirection);
        FzOrientation perfect = start.pointTopTo(orig_top);
        if (perfect == FzOrientation.UNKNOWN) {
            if (this.nextDirection == orig_top) {
                perfect = start.pointTopTo(orig_direction.getOpposite());
            } else if (this.nextDirection == orig_top.getOpposite()) {
                perfect = start.pointTopTo(orig_direction);
            }
            if (perfect == FzOrientation.UNKNOWN) {
                perfect = start;
            }
        }
        this.orientation = perfect;
        this.nextDirection = orig_direction;
    }

    boolean pickNextOrientation_impl() {
        ForgeDirection direction = this.orientation.facing;
        if (this.nextDirection != direction.getOpposite() && this.testDirection(this.nextDirection)) {
            this.swapOrientations();
            return true;
        }
        if (this.testDirection(direction)) {
            return true;
        }
        ForgeDirection top = this.orientation.top;
        if (this.testDirection(top)) {
            this.nextDirection = top;
            this.swapOrientations();
            return true;
        }
        ForgeDirection opposite = direction.getOpposite();
        ArrayList dirs = FactorizationUtil.dirtyDirectionCache();
        Collections.shuffle(dirs, this.getRandom());
        for (int i = 0; i < 6; ++i) {
            ForgeDirection d = (ForgeDirection)dirs.get(i);
            if (d == opposite || d == direction || d == this.nextDirection || d == top || d == this.nextDirection || !this.validDirection(d)) continue;
            this.nextDirection = d;
            this.swapOrientations();
            this.need_description_packet = true;
            return true;
        }
        if (this.validDirection(opposite)) {
            this.orientation = FzOrientation.fromDirection(opposite).pointTopTo(top);
            if (this.orientation != FzOrientation.UNKNOWN) {
                return true;
            }
        }
        this.orientation = FzOrientation.UNKNOWN;
        return false;
    }

    void accelerate() {
        this.speed_b = (byte)(this.speed_b + 1);
        this.speed_b = (byte)Math.min((double)this.speed_b, 127.0);
    }

    void broadcast(short message_type, Object ... msg) {
        Packet p = Core.network.entityPacket(this, message_type, msg);
        Core.network.broadcastPacket(this.field_70170_p, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, p);
    }

    void moveMotor() {
        if (this.accumulated_motion == 0.0) {
            return;
        }
        double move = Math.min(this.accumulated_motion, (double)(1.0f - this.pos_progress));
        this.accumulated_motion -= move;
        this.pos_progress = (float)((double)this.pos_progress + move);
        if (this.field_70170_p.field_72995_K) {
            this.prev_sprocket_rotation = this.sprocket_rotation;
            this.sprocket_rotation += move;
            this.prev_servo_reorient = this.servo_reorient;
            this.servo_reorient = Math.min(1.0, this.servo_reorient + move);
            if (this.servo_reorient >= 1.0) {
                this.servo_reorient = 0.0;
                this.prev_servo_reorient = 0.0;
                this.prevOrientation = this.orientation;
            }
        }
    }

    public Coord getCurrentPos() {
        return this.pos_prev;
    }

    public Coord getNextPos() {
        return this.pos_next;
    }

    boolean hasSignal(Signal signal) {
        return false;
    }

    void onEnterNewBlock() {
        TileEntityServoRail rail = (TileEntityServoRail)this.getCurrentPos().getTE(TileEntityServoRail.class);
        if (rail == null || rail.decoration == null) {
            return;
        }
        if (this.getCurrentPos().isPowered()) {
            return;
        }
        rail.decoration.motorHit(this);
    }

    public boolean func_70085_c(EntityPlayer player) {
        ItemStack is = FactorizationUtil.normalize(player.func_70694_bm());
        if (is == null) {
            return false;
        }
        if (is.func_77973_b() instanceof ActuatorItem) {
            ItemStack toPush = is.func_77979_a(1);
            if (FactorizationUtil.getStackSize(this.getInv().push(toPush)) <= 0) {
                return false;
            }
            ++is.field_77994_a;
            return false;
        }
        return false;
    }

    public boolean func_70097_a(DamageSource damageSource, int damage) {
        if (damageSource instanceof EntityDamageSourceIndirect) {
            return false;
        }
        Entity src = damageSource.func_76364_f();
        if (!(src instanceof EntityPlayer)) {
            return false;
        }
        EntityPlayer player = (EntityPlayer)src;
        if (!this.field_70170_p.field_72995_K) {
            this.func_70106_y();
            ArrayList<ItemStack> toDrop = new ArrayList<ItemStack>();
            toDrop.add(new ItemStack((Item)Core.registry.servo_motor_placer));
            for (ItemStack is : this.inv) {
                toDrop.add(is);
            }
            this.dropItemStacks(toDrop);
        }
        return true;
    }

    public boolean func_70067_L() {
        return true;
    }

    public String toString() {
        return super.toString() + (this.field_70170_p.field_72995_K ? " client" : " server") + " " + this.getProperSpeed();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70056_a(double x, double y, double z, float yaw, float pitch, int three) {
    }

    public void func_70107_b(double x, double y, double z) {
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        double neg_size = 0.0;
        double pos_size = 1.0;
        double height = 0.5;
        double dy = 0.5;
        this.field_70121_D.func_72324_b(x - neg_size, dy + y - height, z - neg_size, x + pos_size, dy + y + height, z + pos_size);
    }

    public void func_70080_a(double x, double y, double z, float yaw, float pitch) {
        super.func_70080_a(x, y, z, yaw, pitch);
    }

    void describe() {
        this.broadcast((short)100, this.speed_b, Float.valueOf(this.pos_progress), this.pos_prev.asDeltaCoord(), this.pos_next.asDeltaCoord(), (byte)this.orientation.ordinal(), (byte)this.nextDirection.ordinal());
    }

    @Override
    public boolean handleMessage(short messageType, DataInputStream input) throws IOException {
        switch (messageType) {
            case 103: {
                byte index;
                while ((index = input.readByte()) >= 0) {
                    int id = input.readInt();
                    int damage = input.readInt();
                    ItemStack is = null;
                    if (id != 0) {
                        is = new ItemStack(id, 1, damage);
                    }
                    this.inv[index] = is;
                }
                return true;
            }
            case 100: {
                this.speed_b = input.readByte();
                this.pos_progress = input.readFloat();
                this.pos_prev.set(DeltaCoord.read(input));
                this.pos_next.set(DeltaCoord.read(input));
                this.interpolatePosition(this.pos_progress);
            }
            case 101: {
                this.orientation = FzOrientation.getOrientation(input.readByte());
                this.nextDirection = ForgeDirection.getOrientation((int)input.readByte());
                return true;
            }
        }
        return false;
    }

    public double getProperSpeed() {
        double perc = (double)this.speed_b / 127.0;
        return 0.0875 * perc;
    }

    public void dropItemStacks(Iterable toDrop) {
        for (ItemStack is : toDrop) {
            FactorizationUtil.spawnItemStack(this, is);
        }
    }

    public ServoStack getServoStack(int stackId) {
        stackId = Math.max(0, stackId);
        stackId = Math.min(stackId, 16);
        return this.stacks[stackId];
    }

    public void putError(Object error) {
        ServoStack ss;
        if (!this.field_70170_p.field_72995_K) {
            Core.notify(null, this.getCurrentPos(), "" + error, new String[0]);
        }
        if ((ss = this.getServoStack(4)).getFreeSpace() <= 0) {
            ss.popEnd();
        }
        ss.push(error);
    }

    public int func_70302_i_() {
        return this.inv.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.inv[i];
    }

    public ItemStack func_70298_a(int i, int j) {
        ItemStack ret = this.inv[i].func_77979_a(j);
        this.inv[i] = FactorizationUtil.normalize(this.inv[i]);
        return ret;
    }

    public ItemStack func_70304_b(int i) {
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inv[i] = itemstack;
    }

    public String func_70303_b() {
        return "Servo Motor Inventory";
    }

    public boolean func_94042_c() {
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        this.updateInventory(this.inv.length);
    }

    public void updateInventory(int slot_count) {
        ArrayList<Number> toSend = new ArrayList<Number>(18);
        for (byte i = 0; i < slot_count; i = (byte)(i + 1)) {
            if (FactorizationUtil.identical(this.inv[i], this.inv_last_sent[i])) continue;
            toSend.add(i);
            if (this.inv[i] == null) {
                toSend.add(0);
                toSend.add(0);
            } else {
                int id = this.inv[i].field_77993_c;
                toSend.add(id);
                this.inv[i].field_77993_c = 1;
                int damage = this.inv[i].func_77960_j();
                this.inv[i].field_77993_c = id;
                toSend.add(damage);
            }
            this.inv_last_sent[i] = this.inv[i];
        }
        if (toSend.isEmpty()) {
            return;
        }
        toSend.add(-1);
        this.broadcast((short)103, toSend.toArray());
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    public FactorizationUtil.FzInv getInv() {
        return this.my_fz_inv;
    }

    public ItemStack getActuator() {
        FactorizationUtil.FzInv mi = this.getInv();
        for (int i = 0; i < mi.size(); ++i) {
            ActuatorItem actuator;
            ItemStack is = mi.get(i);
            if (is == null || !(is.func_77973_b() instanceof ActuatorItem) || (actuator = (ActuatorItem)is.func_77973_b()) == null) continue;
            return is;
        }
        return null;
    }

    private static class MessageType {
        static final short motor_description = 100;
        static final short motor_direction = 101;
        static final short motor_speed = 102;
        static final short motor_inventory = 103;

        private MessageType() {
        }
    }
}

