/*
 * Decompiled with CFR 0.152.
 */
package factorization.common.servo;

import factorization.api.FzOrientation;
import factorization.api.Quaternion;
import factorization.common.BlockRenderHelper;
import factorization.common.Core;
import factorization.common.FactorizationUtil;
import factorization.common.ItemIcons;
import factorization.common.servo.ServoMotor;
import factorization.common.servo.ServoStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelZombie;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.entity.RenderBiped;
import net.minecraft.client.renderer.entity.RenderEntity;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class RenderServoMotor
extends RenderEntity {
    static int sprocket_display_list = -1;
    boolean loaded_model = false;
    static Vec3 quat_vector = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
    static Quaternion start = new Quaternion();
    static Quaternion end = new Quaternion();
    private Quaternion q0 = new Quaternion();
    private Quaternion q1 = new Quaternion();
    private static boolean debug_servo_orientation = false;
    RenderItem renderItem = new RenderItem();
    static ItemStack equiped_item = null;
    static EntityLiving item_holder = new EntityLiving(null){

        public int func_70667_aM() {
            return 0;
        }

        public ItemStack func_70694_bm() {
            return equiped_item;
        }
    };
    static HolderRenderer holder_render = new HolderRenderer((ModelBiped)new ModelZombie(), 1.0f);
    static EntityLiving dummy_entity = new EntityEnderman(null);

    void loadSprocketModel() {
        IModelCustom sprocket = AdvancedModelLoader.loadModel((String)"/mods/factorization/models/sprocket/sprocket.obj");
        sprocket_display_list = GLAllocation.func_74526_a((int)1);
        GL11.glNewList((int)sprocket_display_list, (int)4864);
        sprocket.renderAll();
        GL11.glEndList();
    }

    void renderSprocket() {
        GL11.glCallList((int)sprocket_display_list);
    }

    ForgeDirection getPerpendicular(ForgeDirection a, ForgeDirection b) {
        return a.getRotation(b);
    }

    void rotateForDirection(ForgeDirection dir) {
        switch (dir) {
            case WEST: {
                break;
            }
            case EAST: {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case NORTH: {
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case SOUTH: {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case UP: {
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case DOWN: {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
        }
    }

    float interp(double a, double b, double part) {
        double d = a - b;
        float r = (float)(b + d * part);
        double v = Math.min(1.0f, r * r * 4.0f);
        return (float)v;
    }

    public void func_76986_a(Entity ent, double x, double y, double z, float yaw, float partial) {
        Quaternion qt;
        Core.profileStartRender("servo");
        MovingObjectPosition mop = Minecraft.func_71410_x().field_71476_x;
        boolean highlighted = mop != null && mop.field_72308_g == ent;
        ServoMotor motor = (ServoMotor)ent;
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        GL11.glPushMatrix();
        motor.interpolatePosition((float)Math.pow(motor.pos_progress, 2.0));
        FzOrientation orientation = motor.orientation;
        FzOrientation prevOrientation = motor.prevOrientation;
        if (debug_servo_orientation) {
            GL11.glDisable((int)2896);
            GL11.glDisable((int)3553);
            GL11.glLineWidth((float)4.0f);
            GL11.glBegin((int)3);
            FzOrientation o = orientation;
            GL11.glColor3f((float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glVertex3d((double)0.0, (double)0.0, (double)0.0);
            GL11.glVertex3d((double)o.facing.offsetX, (double)o.facing.offsetY, (double)o.facing.offsetZ);
            GL11.glVertex3d((double)(o.facing.offsetX + o.top.offsetX), (double)(o.facing.offsetY + o.top.offsetY), (double)(o.facing.offsetZ + o.top.offsetZ));
            GL11.glEnd();
            GL11.glLineWidth((float)2.0f);
            GL11.glBegin((int)3);
            o = prevOrientation;
            GL11.glColor3f((float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glVertex3d((double)0.0, (double)0.0, (double)0.0);
            GL11.glVertex3d((double)o.facing.offsetX, (double)o.facing.offsetY, (double)o.facing.offsetZ);
            GL11.glVertex3d((double)(o.facing.offsetX + o.top.offsetX), (double)(o.facing.offsetY + o.top.offsetY), (double)(o.facing.offsetZ + o.top.offsetZ));
            GL11.glEnd();
        }
        float ro = this.interp(motor.servo_reorient, motor.prev_servo_reorient, partial);
        if (prevOrientation == orientation) {
            qt = Quaternion.fromOrientation(orientation);
        } else {
            this.q0.update(Quaternion.fromOrientation(prevOrientation));
            this.q1.update(Quaternion.fromOrientation(orientation));
            if (this.q0.dotProduct(this.q1) < 0.0) {
                this.q0.incrScale(-1.0);
            }
            this.q0.incrLerp(this.q1, ro);
            qt = this.q0;
        }
        qt.glRotate();
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        if (debug_servo_orientation) {
            GL11.glColor3f((float)1.0f, (float)0.0f, (float)1.0f);
            GL11.glBegin((int)3);
            GL11.glVertex3d((double)0.0, (double)0.0, (double)0.0);
            GL11.glVertex3d((double)1.0, (double)0.0, (double)0.0);
            GL11.glVertex3d((double)1.0, (double)1.0, (double)0.0);
            GL11.glVertex3d((double)0.0, (double)0.0, (double)0.0);
            GL11.glEnd();
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)3553);
            GL11.glEnable((int)2896);
        }
        float s = 0.5f;
        GL11.glScalef((float)s, (float)s, (float)s);
        this.renderMainModel(motor, partial, ro, false);
        boolean render_stacks = false;
        if (highlighted) {
            GL11.glDisable((int)3553);
            boolean dso = debug_servo_orientation;
            debug_servo_orientation = false;
            GL11.glColor4f((float)0.0f, (float)0.75f, (float)0.75f, (float)0.11f);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            this.renderMainModel(motor, partial, ro, true);
            debug_servo_orientation = dso;
            GL11.glEnable((int)3553);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)3042);
            EntityPlayer player = Core.proxy.getClientPlayer();
            if (player != null) {
                ItemStack is = player.func_70694_bm();
                ItemStack helmet = player.func_82169_q(3);
                if (is != null && is.func_77973_b() == Core.registry.logicMatrixProgrammer || FactorizationUtil.oreDictionarySimilar("visionInducingEyewear", helmet)) {
                    render_stacks = true;
                }
            }
        }
        GL11.glScalef((float)(1.0f / s), (float)(1.0f / s), (float)(1.0f / s));
        this.renderItem(motor, motor.getActuator(), partial);
        motor.interpolatePosition(motor.pos_progress);
        GL11.glPopMatrix();
        if (render_stacks) {
            GL11.glRotatef((float)(-RenderManager.field_78727_a.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)RenderManager.field_78727_a.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
            this.renderInventory(motor, partial);
            this.renderStacks(motor);
        }
        GL11.glPopMatrix();
        Core.profileEndRender();
    }

    void renderInventory(ServoMotor motor, float partial) {
        GL11.glPushMatrix();
        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        float s = 0.25f;
        ItemStack actuator = motor.getActuator();
        FactorizationUtil.FzInv inv = motor.getInv();
        Minecraft mc = Minecraft.func_71410_x();
        long range = 180L;
        double d = (float)motor.field_70170_p.func_72820_D() + partial;
        float now = (float)(d % (double)range / (double)range);
        int count = 0;
        for (int i = 0; i < inv.size(); ++i) {
            count += inv.get(i) == null ? 0 : 1;
        }
        int c = 0;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack is = inv.get(i);
            if (is == null) continue;
            GL11.glPushMatrix();
            float theta = 360 / count * ++c;
            GL11.glRotatef((float)theta, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)0.65f, (float)-0.25f, (float)0.0f);
            GL11.glScalef((float)s, (float)s, (float)s);
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            try {
                this.renderItem(motor, is, partial);
            }
            catch (Exception e) {
                System.err.println("Error rendering item: " + is);
                e.printStackTrace();
                inv.set(i, null);
            }
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }

    void renderMainModel(ServoMotor motor, float partial, double ro, boolean hilighting) {
        double stretch_interp;
        GL11.glPushMatrix();
        if (!this.loaded_model) {
            this.loadSprocketModel();
            this.loaded_model = true;
        }
        this.func_76985_a("/mods/factorization/models/sprocket/servo_uv.png");
        double rail_width = 0.4375;
        double radius = 0.6230500000000001;
        double constant = Math.PI * 2 * radius;
        double dr = motor.sprocket_rotation - motor.prev_sprocket_rotation;
        double partial_rotation = motor.prev_sprocket_rotation + dr * (double)partial;
        double angle = constant * partial_rotation;
        radius = 0.22916666666666666;
        float rd = (float)(radius + rail_width);
        if (motor.orientation != motor.prevOrientation && (stretch_interp = ro * 2.0) < 1.0) {
            if (stretch_interp > 0.5) {
                stretch_interp = 1.0 - stretch_interp;
            }
            rd = (float)((double)rd + stretch_interp / 8.0);
        }
        float height_d = -0.0234375f;
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)height_d, (float)rd);
        GL11.glRotatef((float)((float)Math.toDegrees(angle)), (float)0.0f, (float)1.0f, (float)0.0f);
        this.renderSprocket();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)height_d, (float)(-rd));
        GL11.glRotatef((float)((float)Math.toDegrees(-angle) + 40.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        this.renderSprocket();
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        if (!hilighting) {
            this.func_76985_a("/gui/items.png");
        }
        this.renderServoPlate();
    }

    void renderServoPlate() {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.6f, (float)0.15625f, (float)0.0f);
        float sh = 2.0f;
        float sv = 1.5f;
        GL11.glScalef((float)sh, (float)sv, (float)sh);
        BlockRenderHelper block2 = Core.registry.blockRender;
        float height = 0.4375f;
        block2.func_71905_a(0.0f, 0.5f, 0.0f, 0.625f, 0.5625f, 1.0f);
        block2.useTextures(ItemIcons.servo$plate, ItemIcons.servo$plate, ItemIcons.servo$plate_side_left, ItemIcons.servo$plate_side_right, ItemIcons.servo$plate_side_red, ItemIcons.servo$plate_side_silver);
        Minecraft mc = Minecraft.func_71410_x();
        block2.renderForInventory(mc.field_71438_f.field_72776_r);
        GL11.glPopMatrix();
    }

    void renderItem(ServoMotor motor, ItemStack is, float partial) {
        equiped_item = is;
        if (equiped_item == null) {
            return;
        }
        RenderServoMotor.dummy_entity.field_70170_p = motor.field_70170_p;
        holder_render.func_76976_a(this.field_76990_c);
        this.do_renderItem(equiped_item);
    }

    public void do_renderItem(ItemStack itemstack) {
        GL11.glPushMatrix();
        GL11.glRotatef((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        float s = 0.5f;
        GL11.glScalef((float)s, (float)s, (float)s);
        this.field_76990_c.field_78721_f.func_78443_a(dummy_entity, itemstack, 0);
        if (itemstack.func_77973_b().func_77623_v()) {
            for (int x = 1; x < itemstack.func_77973_b().getRenderPasses(itemstack.func_77960_j()); ++x) {
                this.field_76990_c.field_78721_f.func_78443_a(dummy_entity, itemstack, x);
            }
        }
        GL11.glPopMatrix();
    }

    protected void func_82422_c() {
        GL11.glTranslatef((float)0.0f, (float)0.1875f, (float)0.0f);
    }

    void renderStacks(ServoMotor motor) {
        GL11.glDisable((int)2896);
        GL11.glPushMatrix();
        float s = 0.0078125f;
        GL11.glScalef((float)s, (float)s, (float)s);
        for (int i = 0; i < 16; ++i) {
            GL11.glPushMatrix();
            ServoStack ss = motor.getServoStack(i);
            GL11.glRotatef((float)(11.0f * (8.5f + (float)i)), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)0.0f, (float)(-0.9f / s), (float)0.0f);
            if (this.renderStack(ss, ItemDye.field_77859_b[15 - i])) {
                // empty if block
            }
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
        GL11.glEnable((int)2896);
    }

    boolean renderStack(ServoStack stack, int color) {
        int i = 0;
        Minecraft mc = Minecraft.func_71410_x();
        FontRenderer fr = mc.field_71466_p;
        fr.func_85187_a("\u4dfc", 0, 0, color, false);
        for (Object o : stack) {
            if (i == 0) {
                GL11.glPushMatrix();
            }
            String text = o.toString();
            GL11.glTranslatef((float)0.0f, (float)-10.0f, (float)0.0f);
            fr.func_85187_a(text, 0, 0, color, false);
            ++i;
        }
        if (i > 0) {
            GL11.glPopMatrix();
        }
        return i > 0;
    }

    private static class HolderRenderer
    extends RenderBiped {
        public HolderRenderer(ModelBiped model, float someFloat) {
            super(model, someFloat);
        }

        public void renderItem(float partial) {
            this.func_77029_c(item_holder, partial);
        }
    }
}

