/*
 * Decompiled with CFR 0.152.
 */
package factorization.common.servo;

import factorization.api.Coord;
import factorization.api.datahelpers.IDataSerializable;
import factorization.common.Core;
import factorization.common.ItemCraftingComponent;
import factorization.common.servo.ServoMotor;
import java.io.IOException;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public abstract class ActuatorItem
extends ItemCraftingComponent {
    public ActuatorItem(int itemId, String name2) {
        super(itemId, name2);
        Core.tab(this, Core.TabType.SERVOS);
    }

    public abstract boolean use(ItemStack var1, Entity var2, MovingObjectPosition var3) throws IOException;

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return false;
        }
        MovingObjectPosition mop = new MovingObjectPosition(x, y, z, side, Vec3.func_72443_a((double)hitX, (double)hitY, (double)hitZ));
        try {
            this.use(stack, (Entity)player, mop);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    public boolean onUse(ItemStack is, Entity user) {
        MovingObjectPosition target = null;
        if (user instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)user;
            target = player.func_70614_a(4.5, 1.0f);
        } else if (user instanceof ServoMotor) {
            ServoMotor motor = (ServoMotor)user;
            Coord c = motor.getCurrentPos();
            ForgeDirection fd = motor.orientation.top;
            target = new MovingObjectPosition(c.x + fd.offsetX, c.y + fd.offsetY, c.z + fd.offsetZ, fd.getOpposite().ordinal(), Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0));
        }
        if (target == null) {
            return false;
        }
        try {
            return this.use(is, user, target);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean extractEnergy(Entity user, int amount) {
        if (amount <= 0) {
            return true;
        }
        if (user instanceof ServoMotor) {
            ServoMotor motor = (ServoMotor)user;
        } else if (user instanceof EntityPlayer) {
            EntityPlayer entityPlayer = (EntityPlayer)user;
        }
        return true;
    }

    public static boolean isSneaking(Entity user) {
        if (user instanceof EntityLiving) {
            return ((EntityLiving)user).func_70093_af();
        }
        if (user instanceof ServoMotor) {
            return ((ServoMotor)user).sneaking;
        }
        return false;
    }

    public abstract IDataSerializable getState();

    @Override
    public void func_77624_a(ItemStack is, EntityPlayer player, List infoList, boolean verbose) {
        super.func_77624_a(is, player, infoList, verbose);
        try {
            this.addConfigurationInfo(is, infoList);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public abstract void addConfigurationInfo(ItemStack var1, List var2) throws IOException;

    static class TraceHelper
    extends EntityLiving {
        public ForgeDirection look = ForgeDirection.UP;

        public TraceHelper() {
            super(null);
        }

        public int func_70667_aM() {
            return 0;
        }

        public Vec3 getLook() {
            return Vec3.func_72443_a((double)this.look.offsetX, (double)this.look.offsetY, (double)this.look.offsetZ);
        }
    }
}

