/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import factorization.common.BlockClass;
import factorization.common.BlockIcons;
import factorization.common.Core;
import factorization.common.FactorizationUtil;
import factorization.common.FactoryType;
import factorization.common.ItemCraft;
import factorization.common.Sound;
import factorization.common.TileEntityFactorization;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;

public class TileEntityStamper
extends TileEntityFactorization {
    ItemStack input;
    ItemStack output;
    ArrayList outputBuffer;
    static int[] OUTPUT_sides = new int[]{0};
    static int[] INPUT_sides = new int[]{1};

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.Machine;
    }

    @Override
    public Icon getIcon(ForgeDirection dir) {
        return BlockIcons.stamper.get(this, dir);
    }

    public int func_70302_i_() {
        return 2;
    }

    public int[] func_94128_d(int s) {
        switch (ForgeDirection.getOrientation((int)s)) {
            case DOWN: {
                return INPUT_sides;
            }
        }
        return OUTPUT_sides;
    }

    public boolean func_94041_b(int slotIndex, ItemStack itemstack) {
        return slotIndex == 0;
    }

    public ItemStack func_70301_a(int i) {
        this.needLogic();
        switch (i) {
            case 0: {
                return this.input;
            }
            case 1: {
                return this.output;
            }
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        if (i == 0) {
            this.input = itemstack;
        }
        if (i == 1) {
            this.output = itemstack;
        }
        this.func_70296_d();
    }

    public String func_70303_b() {
        return "Stamper";
    }

    @Override
    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        TileEntityStamper.saveItem("input", tag, this.input);
        TileEntityStamper.saveItem("output", tag, this.output);
        if (this.outputBuffer != null && this.outputBuffer.size() > 0) {
            NBTTagList buffer = new NBTTagList();
            for (ItemStack item2 : this.outputBuffer) {
                if (item2 == null) continue;
                NBTTagCompound btag = new NBTTagCompound();
                item2.func_77955_b(btag);
                buffer.func_74742_a((NBTBase)btag);
            }
            tag.func_74782_a("buffer", (NBTBase)buffer);
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound tag) {
        NBTTagList buffer;
        int bufferSize;
        super.func_70307_a(tag);
        this.input = TileEntityStamper.readItem("input", tag);
        this.output = TileEntityStamper.readItem("output", tag);
        if (tag.func_74764_b("buffer") && (bufferSize = (buffer = tag.func_74761_m("buffer")).func_74745_c()) > 0) {
            this.outputBuffer = new ArrayList();
            for (int i = 0; i < bufferSize; ++i) {
                this.outputBuffer.add(ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)buffer.func_74743_b(i))));
            }
        }
    }

    boolean canMerge(ArrayList items) {
        if (items == null) {
            return true;
        }
        if (this.output == null) {
            return true;
        }
        for (ItemStack item2 : items) {
            if (item2 == null) continue;
            if (!FactorizationUtil.couldMerge(this.output, item2)) {
                return false;
            }
            if (this.output.field_77994_a + item2.field_77994_a <= this.output.func_77976_d()) continue;
            return false;
        }
        return true;
    }

    @Override
    void doLogic() {
        int new_input_count;
        boolean can_add;
        int input_count = this.input == null ? 0 : this.input.field_77994_a;
        boolean bl = can_add = this.output == null || this.output.field_77994_a < this.output.func_77976_d();
        if (this.outputBuffer == null && can_add && this.input != null && this.input.field_77994_a > 0) {
            ItemCraft ic;
            ItemStack toCraft;
            if (this.input.func_77973_b() instanceof ItemCraft) {
                toCraft = this.input;
                ic = (ItemCraft)this.input.func_77973_b();
            } else {
                ic = Core.registry.item_craft;
                toCraft = new ItemStack((Item)ic);
                ItemStack craftInput = this.input.func_77946_l();
                craftInput.field_77994_a = 1;
                ic.addItem(toCraft, 4, craftInput, this);
            }
            ArrayList fakeResult = Core.registry.item_craft.craftAt(toCraft, true, this);
            if (this.canMerge(fakeResult)) {
                ArrayList craftResult = Core.registry.item_craft.craftAt(toCraft, false, this);
                --this.input.field_77994_a;
                this.outputBuffer = craftResult;
                this.needLogic();
                this.drawActive(3);
            }
        }
        if (this.input != null && this.input.field_77994_a <= 0) {
            this.input = null;
        }
        if (this.outputBuffer != null) {
            Iterator it = this.outputBuffer.iterator();
            while (it.hasNext()) {
                ItemStack here = (ItemStack)it.next();
                if (here == null) {
                    it.remove();
                    continue;
                }
                if (this.output == null) {
                    this.output = here;
                    it.remove();
                    this.needLogic();
                    continue;
                }
                if (!FactorizationUtil.couldMerge(this.output, here)) continue;
                this.needLogic();
                int can_take = this.output.func_77976_d() - this.output.field_77994_a;
                if (here.field_77994_a > can_take) {
                    this.output.field_77994_a += can_take;
                    here.field_77994_a -= can_take;
                    break;
                }
                this.output.field_77994_a += here.field_77994_a;
                it.remove();
            }
        }
        if (this.outputBuffer != null && this.outputBuffer.size() == 0) {
            this.outputBuffer = null;
            this.needLogic();
        }
        int n = new_input_count = this.input == null ? 0 : this.input.field_77994_a;
        if (input_count != new_input_count) {
            this.needLogic();
        }
        if (this.need_logic_check) {
            this.pulse();
        }
    }

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.STAMPER;
    }

    @Override
    void makeNoise() {
        Sound.stamperUse.playAt(this);
    }

    @Override
    public boolean power() {
        return this.draw_active > 0;
    }

    @Override
    int getLogicSpeed() {
        return 16;
    }
}

