/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import factorization.api.Coord;
import factorization.api.IMeterInfo;
import factorization.api.IReflectionTarget;
import factorization.common.BlockClass;
import factorization.common.BlockIcons;
import factorization.common.Core;
import factorization.common.FactorizationUtil;
import factorization.common.FactoryType;
import factorization.common.TileEntityCommon;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidDictionary;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;

public class TileEntitySolarBoiler
extends TileEntityCommon
implements IReflectionTarget,
ITankContainer,
IMeterInfo {
    public static LiquidStack water_stack = null;
    public static LiquidStack steam_stack = null;
    LiquidTank waterTank = new LiquidTank(water_stack.copy(), 8000, (TileEntity)this);
    LiquidTank steamTank = new LiquidTank(steam_stack.copy(), 8000, (TileEntity)this);
    int reflector_count = 0;

    public static void setupSteam() {
        if (water_stack == null) {
            water_stack = LiquidDictionary.getOrCreateLiquid((String)"Water", (LiquidStack)new LiquidStack(Block.field_71943_B, 0));
            steam_stack = LiquidDictionary.getOrCreateLiquid((String)"Steam", (LiquidStack)new LiquidStack(Core.registry.fz_steam, 0));
        }
    }

    public TileEntitySolarBoiler() {
        this.waterTank.setTankPressure(0);
        this.steamTank.setTankPressure(1);
        this.waterTank.getLiquid().amount = 0;
        this.steamTank.getLiquid().amount = 0;
    }

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.SOLARBOILER;
    }

    @Override
    public Icon getIcon(ForgeDirection dir) {
        switch (dir) {
            case UP: {
                return BlockIcons.boiler_top;
            }
        }
        return BlockIcons.boiler_side;
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.Machine;
    }

    @Override
    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        FactorizationUtil.writeTank(tag, this.waterTank, "water");
        FactorizationUtil.writeTank(tag, this.steamTank, "steam");
    }

    @Override
    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        FactorizationUtil.readTank(tag, this.waterTank, "water");
        FactorizationUtil.readTank(tag, this.steamTank, "steam");
        this.sanitize();
    }

    private LiquidTank getTank(ForgeDirection from) {
        if (from == ForgeDirection.UP) {
            return this.steamTank;
        }
        return this.waterTank;
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        return this.getTank(from, resource).fill(resource, doFill);
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        return this.waterTank.fill(resource, doFill);
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.getTank(from).drain(maxDrain, doDrain);
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return this.steamTank.drain(maxDrain, doDrain);
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        return new ILiquidTank[]{this.getTank(direction)};
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        if (direction == ForgeDirection.UP) {
            return this.steamTank;
        }
        if (water_stack.isLiquidEqual(type)) {
            return this.waterTank;
        }
        if (steam_stack.isLiquidEqual(type)) {
            return this.steamTank;
        }
        return this.getTank(direction);
    }

    @Override
    public void addReflector(int strength) {
        this.reflector_count = Math.max(0, this.reflector_count + strength);
    }

    int getWater() {
        return this.waterTank.getLiquid().amount;
    }

    int getSteam() {
        return this.steamTank.getLiquid().amount;
    }

    int getHeat() {
        return Math.max(this.reflector_count - 3, 0);
    }

    void sanitize() {
        LiquidStack water = this.waterTank.getLiquid();
        LiquidStack steam = this.steamTank.getLiquid();
        if (water == null) {
            water = LiquidDictionary.getLiquid((String)"Water", (int)0);
            this.waterTank.setLiquid(water);
        }
        if (steam == null) {
            steam = LiquidDictionary.getLiquid((String)"Steam", (int)0);
            this.steamTank.setLiquid(steam);
        }
        if (water == null || steam == null) {
            throw new RuntimeException("Steam/Water not defined");
        }
    }

    public void func_70316_g() {
        boolean random;
        Coord above;
        ITankContainer tc;
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        this.sanitize();
        LiquidStack water = this.waterTank.getLiquid();
        LiquidStack steam = this.steamTank.getLiquid();
        Coord here = this.getCoord();
        long seed = (long)here.seed() + this.field_70331_k.func_72820_D();
        if (steam.amount > 0 && seed % 5L == 0L && (tc = (ITankContainer)(above = here.add(0, 1, 0)).getTE(ITankContainer.class)) != null) {
            LiquidStack sending_steam = steam.copy();
            sending_steam.amount = Math.min(sending_steam.amount, Math.max(1, this.getHeat() / 10));
            steam.amount -= tc.fill(ForgeDirection.DOWN, steam.copy(), true);
            steam.amount = Math.max(0, steam.amount);
        }
        boolean bl = random = seed % 40L == 0L;
        if (water.amount <= 0 || random && water.amount < this.waterTank.getCapacity()) {
            Coord below = here.add(0, -1, 0);
            ITankContainer tc2 = (ITankContainer)below.getTE(ITankContainer.class);
            boolean water_below = below.is((Block)Block.field_71942_A) || below.is(Block.field_71943_B);
            if ((water_below &= !here.isPowered()) && Core.boilers_suck_water) {
                if (below.getMd() == 0) {
                    below.setId(0);
                    water.amount += 1000;
                }
            } else if (tc2 != null) {
                ForgeDirection dir = ForgeDirection.UP;
                if (below.getTE(TileEntitySolarBoiler.class) != null) {
                    dir = ForgeDirection.DOWN;
                }
                int free = Math.max(0, this.waterTank.getCapacity() - water.amount);
                LiquidStack avail = tc2.drain(dir, free = Math.min(100, free), false);
                if (avail != null && avail.isLiquidEqual(water_stack)) {
                    water.amount += tc2.drain((ForgeDirection)dir, (int)free, (boolean)true).amount;
                }
            }
            return;
        }
        int time_scale = 1;
        if (this.getHeat() <= 0) {
            return;
        }
        if (steam.amount >= this.steamTank.getCapacity()) {
            return;
        }
        int toBoil = Math.min(this.getHeat() * time_scale, water.amount);
        toBoil = Math.min(this.steamTank.getCapacity() - steam.amount, toBoil);
        int water_to_steam = 160;
        water.amount -= Math.max(toBoil / water_to_steam, 1);
        steam.amount += (int)((double)toBoil * Core.steam_output_adjust);
    }

    @Override
    protected void onRemove() {
        super.onRemove();
        Coord here = this.getCoord();
        FactorizationUtil.spill(here, this.waterTank.getLiquid());
        FactorizationUtil.spill(here, this.steamTank.getLiquid());
    }

    @Override
    public String getInfo() {
        this.sanitize();
        float w = (float)(this.waterTank.getLiquid().amount * 16) / (float)this.waterTank.getCapacity();
        float s = (float)(this.steamTank.getLiquid().amount * 16) / (float)this.steamTank.getCapacity();
        return "Power: " + this.reflector_count + "\nSteam: " + String.format("%.1f", Float.valueOf(s)) + "\nWater: " + String.format("%.1f", Float.valueOf(w));
    }
}

