/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.DeltaCoord;
import factorization.common.BlockClass;
import factorization.common.FactoryType;
import factorization.common.TileEntityCommon;
import factorization.common.TileEntityGreenware;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumMovingObjectType;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.ForgeDirection;

public class TileEntityExtension
extends TileEntityCommon {
    private TileEntityCommon _parent = null;
    private DeltaCoord pc;

    public TileEntityExtension() {
    }

    public TileEntityExtension(TileEntityCommon parent) {
        this._parent = parent;
    }

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.EXTENDED;
    }

    @Override
    public BlockClass getBlockClass() {
        TileEntityCommon p = this.getParent();
        if (p == null) {
            return BlockClass.Default;
        }
        return p.getBlockClass();
    }

    @Override
    protected void onRemove() {
        super.onRemove();
        TileEntityCommon p = this.getParent();
        if (p != null) {
            p.onRemove();
        }
    }

    public boolean canUpdate() {
        return false;
    }

    public TileEntityCommon getParent() {
        if (this._parent != null && this._parent.func_70320_p()) {
            this.setParent(null);
            this._parent = null;
            this.getCoord().setId(0);
        }
        if (this._parent == null && this.pc != null) {
            this._parent = (TileEntityCommon)this.getCoord().add(this.pc).getTE(TileEntityCommon.class);
            if (this._parent == null || this._parent.getClass() == TileEntityExtension.class) {
                this.setParent(null);
            }
        }
        return this._parent;
    }

    public void setParent(TileEntityCommon newParent) {
        if (newParent == null || newParent.getClass() == TileEntityExtension.class) {
            this._parent = null;
            this.pc = null;
            return;
        }
        this._parent = newParent;
        this.pc = newParent.getCoord().difference(this.getCoord());
    }

    @Override
    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        if (this.pc != null) {
            this.pc.writeToTag("p", tag);
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        this.pc = DeltaCoord.readFromTag("p", tag);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        TileEntityCommon p = this.getParent();
        if (p == null) {
            return super.getCollisionBoundingBoxFromPool();
        }
        return p.getCollisionBoundingBoxFromPool();
    }

    @Override
    public boolean addCollisionBoxesToList(Block block2, AxisAlignedBB aabb, List list, Entity entity) {
        TileEntityCommon p = this.getParent();
        if (p == null) {
            return super.addCollisionBoxesToList(block2, aabb, list, entity);
        }
        return p.addCollisionBoxesToList(block2, aabb, list, entity);
    }

    public void func_70312_q() {
        super.func_70312_q();
        if (this._parent != null && this.pc == null) {
            this.setParent(this._parent);
        }
    }

    @Override
    public Packet getAuxillaryInfoPacket() {
        if (this.pc == null) {
            return super.getAuxillaryInfoPacket();
        }
        return this.getDescriptionPacketWith(150, this.pc);
    }

    @Override
    public boolean handleMessageFromServer(int messageType, DataInputStream input) throws IOException {
        if (super.handleMessageFromServer(messageType, input)) {
            return true;
        }
        if (messageType == 150) {
            this.pc = DeltaCoord.read(input);
            return true;
        }
        return false;
    }

    @Override
    public boolean activate(EntityPlayer entityplayer, ForgeDirection side) {
        TileEntityCommon p = this.getParent();
        if (p != null) {
            return p.activate(entityplayer, side);
        }
        return false;
    }

    @Override
    public void neighborChanged() {
        TileEntityCommon p = this.getParent();
        if (p != null) {
            p.neighborChanged();
        }
    }

    @Override
    public MovingObjectPosition collisionRayTrace(Vec3 startVec, Vec3 endVec) {
        TileEntityCommon p = this.getParent();
        if (p != null) {
            MovingObjectPosition ret = p.collisionRayTrace(startVec, endVec);
            if (!(p instanceof TileEntityGreenware) && ret != null && ret.field_72313_a == EnumMovingObjectType.TILE) {
                ret.field_72311_b = this.field_70329_l;
                ret.field_72312_c = this.field_70330_m;
                ret.field_72309_d = this.field_70327_n;
            }
            return ret;
        }
        return super.collisionRayTrace(startVec, endVec);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon getIcon(ForgeDirection dir) {
        TileEntityCommon p = this.getParent();
        if (p == null) {
            return super.getIcon(dir);
        }
        return p.getIcon(dir);
    }
}

