/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import factorization.api.Charge;
import factorization.api.IChargeConductor;
import factorization.common.BlockClass;
import factorization.common.BlockIcons;
import factorization.common.Core;
import factorization.common.FactorizationUtil;
import factorization.common.FactoryType;
import factorization.common.TileEntityCommon;
import java.io.DataInputStream;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;

public class TileEntityBattery
extends TileEntityCommon
implements IChargeConductor {
    Charge charge = new Charge(this);
    int storage = 0;
    static final int max_storage = 6400;

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.BATTERY;
    }

    @Override
    public Charge getCharge() {
        return this.charge;
    }

    @Override
    public Icon getIcon(ForgeDirection dir) {
        switch (dir) {
            case UP: {
                return BlockIcons.battery_top;
            }
            case DOWN: {
                return BlockIcons.battery_bottom;
            }
        }
        return BlockIcons.battery_side;
    }

    @Override
    public String getInfo() {
        float f = this.storage * 100 / 6400;
        return "Storage: " + (int)f + "%";
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.Machine;
    }

    @Override
    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        this.charge.readFromNBT(tag, "charge");
        this.storage = tag.func_74762_e("storage");
    }

    @Override
    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        this.charge.writeToNBT(tag, "charge");
        tag.func_74768_a("storage", this.storage);
    }

    public static float getFullness(int value) {
        return (float)value / 6400.0f;
    }

    public float getFullness() {
        return TileEntityBattery.getFullness(this.storage);
    }

    public void func_70316_g() {
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        this.charge.update();
        int val = this.getCharge().getValue();
        int store_delta = 0;
        int charge_delta = 0;
        if (val < 20) {
            charge_delta = Math.min(20, this.storage);
            store_delta = -charge_delta;
        } else if (val > 30) {
            charge_delta = -val;
            int free = 6400 - this.storage;
            store_delta = Math.min(val * 2 / 3, free);
        }
        int tier = this.storage * 32 / 6400;
        if (store_delta != 0) {
            this.charge.addValue(charge_delta);
            this.storage += store_delta;
        }
        if (tier != this.storage * 32 / 6400) {
            this.updateMeter();
        }
    }

    void updateMeter() {
        Core.network.broadcastMessage(null, this.getCoord(), 50, this.storage);
    }

    @Override
    public boolean handleMessageFromServer(int messageType, DataInputStream input) throws IOException {
        if (super.handleMessageFromServer(messageType, input)) {
            return true;
        }
        if (messageType == 50) {
            this.storage = input.readInt();
            this.getCoord().redraw();
            return true;
        }
        return false;
    }

    @Override
    void onPlacedBy(EntityPlayer player, ItemStack is, int side) {
        super.onPlacedBy(player, is, side);
        NBTTagCompound tag = FactorizationUtil.getTag(is);
        this.storage = tag.func_74764_b("storage") ? tag.func_74762_e("storage") : 6400;
    }

    @Override
    byte getExtraInfo() {
        float perc = (float)this.storage / 6400.0f;
        byte ret = (byte)(perc * 127.0f);
        return ret;
    }

    @Override
    void useExtraInfo(byte b) {
        int new_storage;
        float perc = (float)b / 127.0f;
        this.storage = new_storage = (int)(6400.0f * perc);
    }
}

