/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.ITinyPacketHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.relauncher.Side;
import factorization.api.Coord;
import factorization.api.DeltaCoord;
import factorization.api.IEntityMessage;
import factorization.api.Quaternion;
import factorization.api.VectorUV;
import factorization.common.Command;
import factorization.common.Core;
import factorization.common.FactoryType;
import factorization.common.Sound;
import factorization.common.TileEntityBarrel;
import factorization.common.TileEntityCommon;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.IllegalFormatException;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.NetHandler;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet131MapData;
import net.minecraft.server.management.PlayerInstance;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StringTranslate;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;

public class NetworkFactorization
implements ITinyPacketHandler {
    protected static final short factorizeTEChannel = 0;
    protected static final short factorizeMsgChannel = 1;
    protected static final short factorizeCmdChannel = 2;
    protected static final short factorizeNtfyChannel = 3;
    protected static final short factorizeEntityChannel = 4;
    int huge_tag_warnings = 0;
    private double maxBroadcastDistSq = 2.0 * Math.pow(64.0, 2.0);
    private static final ThreadLocal currentPlayer = new ThreadLocal();

    public NetworkFactorization() {
        Core.network = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Packet TEmessagePacket(Coord src, int messageType, Object ... items) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DataOutputStream output = new DataOutputStream(outputStream);
            output.writeInt(src.x);
            output.writeInt(src.y);
            output.writeInt(src.z);
            output.writeShort(messageType);
            Object[] arr$ = items;
            int len$ = arr$.length;
            int i$ = 0;
            while (true) {
                if (i$ >= len$) {
                    output.flush();
                    return PacketDispatcher.getTinyPacket((Object)Core.instance, (short)0, (byte[])outputStream.toByteArray());
                }
                Object item2 = arr$[i$];
                if (item2 == null) {
                    throw new RuntimeException("Argument is null!");
                }
                if (item2 instanceof Integer) {
                    output.writeInt((Integer)item2);
                } else if (item2 instanceof Byte) {
                    output.writeByte(((Byte)item2).byteValue());
                } else if (item2 instanceof Short) {
                    output.writeShort(((Short)item2).shortValue());
                } else if (item2 instanceof String) {
                    output.writeUTF((String)item2);
                } else if (item2 instanceof Boolean) {
                    output.writeBoolean((Boolean)item2);
                } else if (item2 instanceof Float) {
                    output.writeFloat(((Float)item2).floatValue());
                } else if (item2 instanceof ItemStack) {
                    ItemStack is = (ItemStack)item2;
                    NBTTagCompound tag = new NBTTagCompound();
                    Item is_item = is.func_77973_b();
                    if (is_item == null || is_item.func_77651_p()) {
                        is.func_77955_b(tag);
                    } else {
                        NBTTagCompound backup = is.func_77978_p();
                        is.func_77955_b(tag);
                        is.func_77982_d(backup);
                    }
                    NBTTagCompound.func_74731_a((NBTBase)tag, (DataOutput)output);
                    if (outputStream.size() > 65536 && is.func_77942_o()) {
                        if (this.huge_tag_warnings++ < 10) {
                            Core.logWarning("Item " + is + " probably has a huge NBT tag; it will be stripped from the packet; at " + src, new Object[0]);
                            if (this.huge_tag_warnings == 10) {
                                Core.logWarning("(This will no longer be logged)", new Object[0]);
                            }
                        }
                        NBTTagCompound tag_copy = is.func_77978_p();
                        is.func_77982_d(null);
                        try {
                            Packet packet = this.TEmessagePacket(src, messageType, items);
                            return packet;
                        }
                        finally {
                            is.func_77982_d(tag_copy);
                        }
                    }
                } else if (item2 instanceof VectorUV) {
                    VectorUV v = (VectorUV)item2;
                    output.writeFloat((float)v.x);
                    output.writeFloat((float)v.y);
                    output.writeFloat((float)v.z);
                } else if (item2 instanceof DeltaCoord) {
                    DeltaCoord dc = (DeltaCoord)item2;
                    dc.write(output);
                } else if (item2 instanceof Quaternion) {
                    Quaternion q = (Quaternion)item2;
                    q.write(output);
                } else {
                    if (!(item2 instanceof byte[])) throw new RuntimeException("Don't know how to serialize " + item2.getClass() + " (" + item2 + ")");
                    byte[] b = (byte[])item2;
                    output.write(b, 0, b.length);
                }
                ++i$;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Packet translatePacket(String ... items) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DataOutputStream output = new DataOutputStream(outputStream);
            for (String i : items) {
                output.writeUTF(i);
            }
            output.flush();
            return PacketDispatcher.getTinyPacket((Object)Core.instance, (short)1, (byte[])outputStream.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Packet notifyPacket(Coord where, String format, String ... args) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DataOutputStream output = new DataOutputStream(outputStream);
            output.writeInt(where.x);
            output.writeInt(where.y);
            output.writeInt(where.z);
            output.writeUTF(format);
            output.writeInt(args.length);
            for (String a : args) {
                output.writeUTF(a);
            }
            output.flush();
            new PacketDispatcher();
            return PacketDispatcher.getTinyPacket((Object)Core.instance, (short)3, (byte[])outputStream.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Packet entityPacket(Entity to, short messageType, Object ... items) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DataOutputStream output = new DataOutputStream(outputStream);
            output.writeInt(to.field_70157_k);
            output.writeShort(messageType);
            Object[] arr$ = items;
            int len$ = arr$.length;
            int i$ = 0;
            while (true) {
                if (i$ >= len$) {
                    output.flush();
                    return PacketDispatcher.getTinyPacket((Object)Core.instance, (short)4, (byte[])outputStream.toByteArray());
                }
                Object item2 = arr$[i$];
                if (item2 == null) {
                    throw new RuntimeException("Argument is null!");
                }
                if (item2 instanceof Integer) {
                    output.writeInt((Integer)item2);
                } else if (item2 instanceof Byte) {
                    output.writeByte(((Byte)item2).byteValue());
                } else if (item2 instanceof Short) {
                    output.writeShort(((Short)item2).shortValue());
                } else if (item2 instanceof String) {
                    output.writeUTF((String)item2);
                } else if (item2 instanceof Boolean) {
                    output.writeBoolean((Boolean)item2);
                } else if (item2 instanceof Float) {
                    output.writeFloat(((Float)item2).floatValue());
                } else if (item2 instanceof ItemStack) {
                    ItemStack is = (ItemStack)item2;
                    NBTTagCompound tag = new NBTTagCompound();
                    Item is_item = is.func_77973_b();
                    if (is_item == null || is_item.func_77651_p()) {
                        is.func_77955_b(tag);
                    } else {
                        NBTTagCompound backup = is.func_77978_p();
                        is.func_77955_b(tag);
                        is.func_77982_d(backup);
                    }
                    NBTTagCompound.func_74731_a((NBTBase)tag, (DataOutput)output);
                    if (outputStream.size() > 65536 && is.func_77942_o()) {
                        if (this.huge_tag_warnings++ < 10) {
                            Core.logWarning("Item " + is + " probably has a huge NBT tag; it will be stripped from the packet; packet for entity " + to, new Object[0]);
                            if (this.huge_tag_warnings == 10) {
                                Core.logWarning("(This will no longer be logged)", new Object[0]);
                            }
                        }
                        NBTTagCompound tag_copy = is.func_77978_p();
                        is.func_77982_d(null);
                        try {
                            Packet packet = this.entityPacket(to, messageType, items);
                            return packet;
                        }
                        finally {
                            is.func_77982_d(tag_copy);
                        }
                    }
                } else if (item2 instanceof VectorUV) {
                    VectorUV v = (VectorUV)item2;
                    output.writeFloat((float)v.x);
                    output.writeFloat((float)v.y);
                    output.writeFloat((float)v.z);
                } else if (item2 instanceof DeltaCoord) {
                    DeltaCoord dc = (DeltaCoord)item2;
                    dc.write(output);
                } else {
                    if (!(item2 instanceof Quaternion)) throw new RuntimeException("Don't know how to serialize " + item2.getClass() + " (" + item2 + ")");
                    Quaternion q = (Quaternion)item2;
                    q.write(output);
                }
                ++i$;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void sendCommand(EntityPlayer player, Command cmd, byte arg) {
        byte[] data = new byte[]{cmd.id, arg};
        Packet131MapData packet = PacketDispatcher.getTinyPacket((Object)Core.instance, (short)2, (byte[])data);
        Core.proxy.addPacket(player, (Packet)packet);
    }

    public void broadcastMessage(EntityPlayer who, Coord src, int messageType, Object ... msg) {
        Packet toSend = this.TEmessagePacket(src, messageType, msg);
        if (who == null || !who.field_70170_p.field_72995_K) {
            this.broadcastPacket(who, src, toSend);
        } else {
            Core.proxy.addPacket(who, toSend);
        }
    }

    public void broadcastPacket(EntityPlayer who, Coord src, Packet toSend) {
        if (src.w == null) {
            new NullPointerException("Coord is null").printStackTrace();
            return;
        }
        if (who == null) {
            Chunk srcChunk = src.getChunk();
            for (EntityPlayer player : src.w.field_73010_i) {
                double x = (double)src.x - player.field_70165_t;
                double z = (double)src.z - player.field_70161_v;
                if (x * x + z * z > this.maxBroadcastDistSq || !Core.proxy.playerListensToCoord(player, src)) continue;
                Core.proxy.addPacket(player, toSend);
            }
        } else {
            Core.proxy.addPacket(who, toSend);
        }
    }

    public void broadcastPacket(World world, int xCoord, int yCoord, int zCoord, Packet toSend) {
        if (toSend == null) {
            return;
        }
        if (world.field_72995_K) {
            return;
        }
        WorldServer w = (WorldServer)world;
        PlayerInstance pi = w.func_73040_p().func_72690_a(xCoord >> 4, zCoord >> 4, false);
        if (pi == null) {
            return;
        }
        pi.func_73256_a(toSend);
    }

    EntityPlayer getCurrentPlayer() {
        EntityPlayer ret = (EntityPlayer)currentPlayer.get();
        if (ret == null) {
            throw new NullPointerException("currentPlayer wasn't set");
        }
        return ret;
    }

    public void handle(NetHandler handler, Packet131MapData mapData) {
        this.handlePacketData(handler, mapData.field_73436_b, mapData.field_73437_c, handler.getPlayer());
    }

    void handlePacketData(NetHandler handler, int channel, byte[] data, EntityPlayer me) {
        currentPlayer.set(me);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
        DataInputStream input = new DataInputStream(inputStream);
        switch (channel) {
            case 0: {
                this.handleTE(input);
                break;
            }
            case 1: {
                this.handleMsg(input);
                break;
            }
            case 2: {
                this.handleCmd(data);
                break;
            }
            case 3: {
                this.handleNtfy(input);
                break;
            }
            case 4: {
                this.handleEntity(input);
                break;
            }
            default: {
                Core.logWarning("Got packet with invalid channel %i with player = %s ", channel, me);
            }
        }
        currentPlayer.set(null);
    }

    void handleTE(DataInputStream input) {
        try {
            World world = this.getCurrentPlayer().field_70170_p;
            int x = input.readInt();
            int y = input.readInt();
            int z = input.readInt();
            int messageType = input.readShort();
            Coord here = new Coord(world, x, y, z);
            if (Core.debug_network) {
                Core.logFine("FactorNet: " + messageType + "      " + here, new Object[0]);
            }
            if (!here.blockExists() && world.field_72995_K) {
                return;
            }
            if (messageType == 2 && !world.field_72995_K) {
                TileEntityCommon tec = (TileEntityCommon)here.getTE(TileEntityCommon.class);
                if (tec != null) {
                    this.broadcastPacket(this.getCurrentPlayer(), here, tec.func_70319_e());
                }
                return;
            }
            if (messageType == 1 && world.field_72995_K) {
                FactoryType ft = FactoryType.fromMd(input.readInt());
                byte extraData = input.readByte();
                byte extraData2 = input.readByte();
                try {
                    messageType = input.readInt();
                }
                catch (IOException e) {
                    messageType = -1;
                }
                TileEntityCommon spawn = (TileEntityCommon)here.getTE(TileEntityCommon.class);
                if (spawn != null && spawn.getFactoryType() != ft) {
                    world.func_72932_q(x, y, z);
                    spawn = null;
                }
                if (spawn == null) {
                    spawn = ft.makeTileEntity();
                    spawn.field_70331_k = world;
                    world.func_72837_a(x, y, z, (TileEntity)spawn);
                }
                if (spawn != null) {
                    spawn.useExtraInfo(extraData);
                    spawn.useExtraInfo2(extraData2);
                }
            }
            if (messageType == -1) {
                return;
            }
            TileEntityCommon tec = (TileEntityCommon)here.getTE(TileEntityCommon.class);
            if (tec == null) {
                this.handleForeignMessage(world, x, y, z, tec, messageType, input);
                return;
            }
            boolean handled = here.w.field_72995_K ? tec.handleMessageFromServer(messageType, input) : tec.handleMessageFromClient(messageType, input);
            if (!handled) {
                this.handleForeignMessage(world, x, y, z, tec, messageType, input);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void handleMsg(DataInputStream input) {
        String main;
        if (FMLCommonHandler.instance().getSide() != Side.CLIENT) {
            return;
        }
        try {
            main = input.readUTF();
        }
        catch (IOException e1) {
            return;
        }
        ArrayList<String> items = new ArrayList<String>();
        try {
            while (true) {
                String orig = input.readUTF();
                String name2 = orig + ".name";
                String transd = StringTranslate.func_74808_a().func_74805_b(name2);
                if (transd.compareTo(name2) == 0) {
                    items.add(orig);
                    continue;
                }
                items.add(transd);
            }
        }
        catch (IOException e) {
            try {
                this.getCurrentPlayer().func_71035_c(String.format(main, items.toArray()));
            }
            catch (IllegalFormatException e2) {
                System.err.print("Illegal format: \"" + main + '\"');
                for (String i : items) {
                    System.err.print(" \"" + i + "\"");
                }
                System.err.println();
                e2.printStackTrace();
            }
            return;
        }
    }

    void handleForeignMessage(World world, int x, int y, int z, TileEntity ent, int messageType, DataInputStream input) throws IOException {
        if (world.field_72995_K) {
            Coord here = new Coord(world, x, y, z);
            switch (messageType) {
                case 11: {
                    Sound.receive(input);
                    break;
                }
                case 12: {
                    Block.field_71963_Z.func_71883_b(world, x, y, z, 0, input.readInt());
                    here.setId(0);
                    break;
                }
                case 43: {
                    TileEntityBarrel.spawnBreakParticles(here, input.readInt());
                    break;
                }
                default: {
                    if (here.blockExists() && here.getId() != 0) {
                        Core.logFine("Got unhandled message: " + messageType + " for " + here, new Object[0]);
                        break;
                    }
                    Core.logFine("Got message to unloaded chunk: " + messageType + " for " + here, new Object[0]);
                }
            }
        }
    }

    void handleCmd(byte[] data) {
        if (data == null || data.length < 2) {
            return;
        }
        byte s = data[0];
        byte arg = data[1];
        Command.fromNetwork(this.getCurrentPlayer(), s, arg);
    }

    void handleNtfy(DataInputStream input) {
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            EntityPlayer me = this.getCurrentPlayer();
            if (!me.field_70170_p.field_72995_K) {
                return;
            }
            try {
                int x = input.readInt();
                int y = input.readInt();
                int z = input.readInt();
                String msg = input.readUTF();
                int argCount = input.readInt();
                String[] args = new String[argCount];
                for (int i = 0; i < argCount; ++i) {
                    args[i] = input.readUTF();
                }
                Core.notify(me, new Coord(me.field_70170_p, x, y, z), msg, args);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    void handleEntity(DataInputStream input) {
        try {
            World world = this.getCurrentPlayer().field_70170_p;
            if (!world.field_72995_K) {
                return;
            }
            int entityId = input.readInt();
            short messageType = input.readShort();
            Entity to = world.func_73045_a(entityId);
            if (to == null) {
                if (Core.dev_environ) {
                    // empty if block
                }
                return;
            }
            if (!(to instanceof IEntityMessage)) {
                Core.logFine("Packet to inappropriate entity #%i: %i", entityId, messageType);
            }
            IEntityMessage iem = (IEntityMessage)to;
            if (Core.debug_network) {
                Core.logFine("EntityNet: " + messageType + "      " + to, new Object[0]);
            }
            iem.handleMessage(messageType, input);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class MessageType {
        public static final int ShareAll = -1;
        public static final int PlaySound = 11;
        public static final int PistonPush = 12;
        public static final int DrawActive = 0;
        public static final int FactoryType = 1;
        public static final int DescriptionRequest = 2;
        public static final int MakerTarget = 11;
        public static final int RouterSlot = 20;
        public static final int RouterTargetSide = 21;
        public static final int RouterMatch = 22;
        public static final int RouterIsInput = 23;
        public static final int RouterLastSeen = 24;
        public static final int RouterMatchToVisit = 25;
        public static final int RouterDowngrade = 26;
        public static final int RouterUpgradeState = 27;
        public static final int RouterEjectDirection = 28;
        public static final int BarrelDescription = 40;
        public static final int BarrelItem = 41;
        public static final int BarrelCount = 42;
        public static final int BarrelLoss = 43;
        public static final int BatteryLevel = 50;
        public static final int LeydenjarLevel = 51;
        public static final int MirrorDescription = 60;
        public static final int TurbineWater = 70;
        public static final int TurbineSpeed = 71;
        public static final int HeaterHeat = 80;
        public static final int GrinderSpeed = 90;
        public static final int MixerSpeed = 100;
        public static final int CrystallizerInfo = 110;
        public static final int WireFace = 121;
        public static final int SculptDescription = 130;
        public static final int SculptNew = 132;
        public static final int SculptMove = 133;
        public static final int SculptRemove = 134;
        public static final int SculptState = 135;
        public static final int FurnaceBurnTime = 140;
        public static final int ExtensionInfo = 150;
        public static final int RocketState = 151;
        public static final int ServoRailDecor = 161;
        public static final int ServoRailDecorUpdate = 162;
    }
}

