/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import factorization.api.Coord;
import factorization.common.Core;
import factorization.common.CubeFace;
import factorization.common.FactorizationUtil;
import factorization.common.FactoryType;
import factorization.common.TileEntityCommon;
import factorization.common.TileEntityGreenware;
import factorization.common.TileEntityLeydenJar;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.World;

public class ItemFactorization
extends ItemBlock {
    public ItemFactorization(int id) {
        super(id);
        this.func_77656_e(0);
        this.func_77627_a(true);
    }

    public boolean placeBlockAt(ItemStack is, EntityPlayer player, World w, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int md) {
        boolean good;
        Coord here = new Coord(w, x, y, z);
        FactoryType f = FactoryType.fromMd(is.func_77960_j());
        if (f == null) {
            is.field_77994_a = 0;
            return false;
        }
        TileEntityCommon te = f.makeTileEntity();
        if (te instanceof TileEntityCommon && !(good = te.canPlaceAgainst(player, here.copy().towardSide(CubeFace.oppositeSide(side)), side))) {
            return false;
        }
        if (super.placeBlockAt(is, player, w, x, y, z, side, hitX, hitY, hitZ, md)) {
            w.func_72837_a(here.x, here.y, here.z, (TileEntity)te);
            if (te instanceof TileEntityCommon) {
                TileEntityCommon tec = te;
                tec.onPlacedBy(player, is, side);
                tec.getBlockClass().enforce(here);
            }
            here.markBlockForUpdate();
            return true;
        }
        return false;
    }

    public Icon func_77617_a(int damage) {
        return Core.registry.factory_block.func_71858_a(0, damage);
    }

    public int func_77647_b(int i) {
        return 15;
    }

    public String func_77667_c(ItemStack is) {
        int md = is.func_77960_j();
        FactoryType ft = FactoryType.fromMd(md);
        return "factorization.factoryBlock." + (Object)((Object)ft);
    }

    public void func_77624_a(ItemStack is, EntityPlayer player, List infoList, boolean verbose) {
        NBTTagCompound tag;
        if (Core.registry.greenware_item != null && is.func_77969_a(Core.registry.greenware_item) && (tag = is.func_77978_p()) != null) {
            TileEntityGreenware teg = (TileEntityGreenware)FactoryType.CERAMIC.getRepresentative();
            teg.func_70307_a(tag);
            TileEntityGreenware.ClayState state = teg.getState();
            infoList.add(teg.parts.size() + " parts");
            infoList.add(state.toString());
        }
        if (FactorizationUtil.similar(is, Core.registry.leydenjar_item)) {
            if (is.func_77942_o()) {
                FactoryType ft = FactoryType.LEYDENJAR;
                TileEntityLeydenJar jar = (TileEntityLeydenJar)ft.getRepresentative();
                jar.onPlacedBy(player, is, 0);
                infoList.add((int)(jar.getLevel() * 100.0) + "% charged");
            } else {
                infoList.add("0% charged");
            }
        }
        Core.brand(is, infoList);
    }

    public boolean func_77651_p() {
        return true;
    }
}

