/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import factorization.api.Coord;
import factorization.common.Core;
import factorization.common.FactorizationUtil;
import factorization.common.ItemIcons;
import factorization.common.Sound;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.World;

public class ItemCraft
extends Item {
    private final int slot_length = 9;
    static List recipes = new ArrayList();

    public ItemCraft(int i) {
        super(i);
        this.field_77777_bU = 1;
        this.func_77627_a(true);
        Core.tab(this, Core.TabType.MISC);
        this.func_77655_b("factorization:craftpacket");
    }

    public static void addStamperRecipe(IRecipe recipe) {
        recipes.add(recipe);
    }

    boolean isSlotSet(ItemStack is, int i) {
        return this.getSlot(is, i) != null;
    }

    private ItemStack getSlot(ItemStack is, int i) {
        NBTTagCompound tag = is.func_77978_p();
        if (tag == null) {
            return null;
        }
        NBTTagCompound slot = (NBTTagCompound)tag.func_74781_a("slot" + i);
        if (slot == null) {
            return null;
        }
        return ItemStack.func_77949_a((NBTTagCompound)slot);
    }

    private void setSlot(ItemStack is, int i, ItemStack origWhat, TileEntity where) {
        ItemStack what = origWhat.func_77946_l();
        what.field_77994_a = 1;
        NBTTagCompound tag = is.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            is.func_77982_d(tag);
        }
        NBTTagCompound saved = new NBTTagCompound();
        what.func_77955_b(saved);
        tag.func_74782_a("slot" + i, (NBTBase)saved);
        if (Core.finished_loading) {
            this.craftAt(is, true, where);
        }
    }

    public void func_77624_a(ItemStack is, EntityPlayer player, List list, boolean verbose) {
        String line = "";
        ArrayList<String> toAdd = new ArrayList<String>();
        int count = 0;
        if (is.func_77960_j() > 1) {
            if (is.func_77960_j() == Core.registry.diamond_shard_packet.func_77960_j() && is != Core.registry.diamond_shard_packet) {
                this.func_77624_a(Core.registry.diamond_shard_packet, player, list, verbose);
            } else {
                Core.brand(is, list);
                return;
            }
        }
        for (int i = 0; i < 9; ++i) {
            ItemStack here = this.getSlot(is, i);
            if (here == null) {
                line = line + "-";
            } else {
                line = line + Core.proxy.translateItemStack(here);
                ++count;
            }
            if (i % 3 == 2) {
                if (line.length() > 0) {
                    toAdd.add(line);
                }
                line = "";
                continue;
            }
            line = line + " ";
        }
        if (count != 0) {
            list.addAll(toAdd);
        } else {
            list.add("Empty");
        }
        Core.brand(is, list);
    }

    public boolean addItem(ItemStack is, int i, ItemStack what, TileEntity where) {
        if (i < 0 || 8 < i) {
            throw new RuntimeException("out of range");
        }
        if (what.func_77973_b() instanceof ItemCraft) {
            return false;
        }
        if (this.getSlot(is, i) != null) {
            return false;
        }
        this.setSlot(is, i, what, where);
        return true;
    }

    InventoryCrafting getCrafter(ItemStack is) {
        InventoryCrafting craft = FactorizationUtil.makeCraftingGrid();
        for (int i = 0; i < 9; ++i) {
            craft.func_70299_a(i, this.getSlot(is, i));
        }
        return craft;
    }

    ItemStack findMatchingRecipe(InventoryCrafting craft, World world) {
        for (IRecipe recipe : recipes) {
            if (!recipe.func_77569_a(craft, world)) continue;
            return recipe.func_77572_b(craft);
        }
        return CraftingManager.func_77594_a().func_82787_a(craft, world);
    }

    public ArrayList craftAt(ItemStack is, boolean fake, TileEntity where) {
        if (!(is.func_77973_b() instanceof ItemCraft)) {
            return null;
        }
        if (is.func_77960_j() == Core.registry.diamond_shard_packet.func_77960_j()) {
            ItemStack cp = Core.registry.diamond_shard_packet.func_77946_l();
            cp.func_77964_b(0);
            return this.craftAt(cp, fake, where);
        }
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        InventoryCrafting craft = this.getCrafter(is);
        ItemStack result = where == null || where.field_70331_k == null ? this.findMatchingRecipe(craft, null) : this.findMatchingRecipe(craft, where.field_70331_k);
        if (result == null) {
            is.func_77964_b(0);
        } else if (is.func_77960_j() == 0) {
            is.func_77964_b(1);
        }
        if (result == null) {
            for (int i = 0; i < 9; ++i) {
                ItemStack here = this.getSlot(is, i);
                if (here == null) continue;
                ret.add(here);
            }
        } else {
            if (fake) {
                ret.add(result);
                return ret;
            }
            Coord pos = null;
            if (where != null) {
                pos = new Coord(where);
            }
            EntityPlayer fakePlayer = FactorizationUtil.makePlayer(pos, "CraftPacket");
            if (where != null) {
                if (Core.registry.diamond_shard_recipe.func_77569_a(craft, where.field_70331_k)) {
                    Sound.shardMake.playAt(where);
                }
                fakePlayer.field_70170_p = where.field_70331_k;
                fakePlayer.field_70165_t = where.field_70329_l;
                fakePlayer.field_70163_u = where.field_70330_m;
                fakePlayer.field_70161_v = where.field_70327_n;
            }
            InventoryCraftResult craftResult = new InventoryCraftResult();
            craftResult.func_70299_a(0, result);
            SlotCrafting slot = new SlotCrafting(fakePlayer, (IInventory)craft, (IInventory)craftResult, 0, 0, 0);
            slot.func_82870_a(fakePlayer, result);
            ret.add(result);
            FactorizationUtil.addInventoryToArray((IInventory)craft, ret);
            FactorizationUtil.addInventoryToArray((IInventory)fakePlayer.field_71071_by, ret);
        }
        return ret;
    }

    public boolean isValidCraft(ItemStack is) {
        return is.func_77960_j() != 0;
    }

    public void func_94581_a(IconRegister reg) {
    }

    public Icon func_77617_a(int damage) {
        if (damage == 0) {
            return ItemIcons.packet_incomplete;
        }
        return ItemIcons.packet_complete;
    }

    public String func_77667_c(ItemStack is) {
        if (is.func_77960_j() > 0) {
            return super.func_77667_c(is) + "_complete";
        }
        return super.func_77667_c(is);
    }

    public boolean func_77651_p() {
        return true;
    }

    public void func_77633_a(int id, CreativeTabs tab, List list) {
        list.add(new ItemStack((Item)Core.registry.item_craft));
        list.add(Core.registry.diamond_shard_packet);
    }
}

