/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.Coord;
import factorization.api.DeltaCoord;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.FakePlayer;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;
import net.minecraftforge.liquids.LiquidEvent;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;
import net.minecraftforge.oredict.OreDictionary;

public class FactorizationUtil {
    public static final int WILDCARD_DAMAGE = Short.MAX_VALUE;
    static Random rand = new Random();
    private static ThreadLocal direction_cache = new ThreadLocal();
    private static ThreadLocal random_cache = new ThreadLocal();

    public static ItemStack makeWildcard(Item item2) {
        return new ItemStack(item2, 1, Short.MAX_VALUE);
    }

    public static ItemStack makeWildcard(Block item2) {
        return new ItemStack(item2, 1, Short.MAX_VALUE);
    }

    public static boolean identical(ItemStack a, ItemStack b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return FactorizationUtil.couldMerge(a, b) && a.field_77994_a == b.field_77994_a;
    }

    public static boolean couldMerge(ItemStack a, ItemStack b) {
        if (a == null || b == null) {
            return true;
        }
        return a.field_77993_c == b.field_77993_c && a.func_77960_j() == b.func_77960_j() && FactorizationUtil.sameItemTags(a, b);
    }

    public static boolean sameItemTags(ItemStack a, ItemStack b) {
        if (a.field_77990_d == null || b.field_77990_d == null) {
            return a.field_77990_d == b.field_77990_d;
        }
        a.field_77990_d.func_74738_o("tag");
        b.field_77990_d.func_74738_o("tag");
        return a.field_77990_d.equals((Object)b.field_77990_d);
    }

    public static boolean similar(ItemStack a, ItemStack b) {
        if (a == null || b == null) {
            return a == b;
        }
        return a.field_77993_c == b.field_77993_c && a.func_77960_j() == b.func_77960_j();
    }

    public static boolean wildcardSimilar(ItemStack template, ItemStack stranger) {
        if (template == null || stranger == null) {
            return template == stranger;
        }
        if (template.func_77960_j() == Short.MAX_VALUE) {
            return template.field_77993_c == stranger.field_77993_c;
        }
        return FactorizationUtil.similar(template, stranger);
    }

    public static boolean oreDictionarySimilar(Object template, ItemStack stranger) {
        if (template instanceof String) {
            ArrayList ores = OreDictionary.getOres((String)((String)template));
            for (int i = 0; i < ores.size(); ++i) {
                if (!FactorizationUtil.wildcardSimilar((ItemStack)ores.get(i), stranger)) continue;
                return true;
            }
            return false;
        }
        if (template instanceof List) {
            for (Object o : (List)template) {
                if (!FactorizationUtil.oreDictionarySimilar(o, stranger)) continue;
                return true;
            }
            return false;
        }
        return FactorizationUtil.wildcardSimilar((ItemStack)template, stranger);
    }

    public static boolean itemInRange(ItemStack a, ItemStack b, ItemStack stranger) {
        if (stranger == null) {
            return false;
        }
        if (a == null || b == null) {
            if (a != null) {
                return FactorizationUtil.couldMerge(a, stranger);
            }
            if (b != null) {
                return FactorizationUtil.couldMerge(b, stranger);
            }
            return false;
        }
        if (a.field_77993_c != b.field_77993_c) {
            Class<?> ca = a.func_77973_b().getClass();
            Class<?> cb = b.func_77973_b().getClass();
            Class<?> c_stranger = stranger.func_77973_b().getClass();
            String na = ca.getName();
            String nb = cb.getName();
            String n_stranger = c_stranger.getName();
            int end = Math.min(na.length(), nb.length());
            int end_stranger = n_stranger.length();
            for (int i = 0; i < end; ++i) {
                char y;
                char x = na.charAt(i);
                if (x == (y = nb.charAt(i))) {
                    if (end_stranger > i && n_stranger.charAt(i) == x) continue;
                    return false;
                }
                return true;
            }
            return true;
        }
        if (a.field_77993_c != stranger.field_77993_c) {
            return false;
        }
        int mda = a.func_77960_j();
        int mdb = b.func_77960_j();
        int md_stranger = stranger.func_77960_j();
        if (a.func_77942_o() == b.func_77942_o() && (a.func_77942_o() ? !a.func_77978_p().equals((Object)stranger.func_77978_p()) : stranger.func_77942_o())) {
            return false;
        }
        if (mda < mdb) {
            return mda <= md_stranger && md_stranger <= mdb;
        }
        if (mda > mdb) {
            return mda >= md_stranger && md_stranger >= mdb;
        }
        return mda == md_stranger;
    }

    public static int stackSize(ItemStack is) {
        return is == null ? 0 : is.field_77994_a;
    }

    public static ItemStack normalDecr(ItemStack is) {
        --is.field_77994_a;
        return is.field_77994_a <= 0 ? null : is;
    }

    public static NBTTagCompound getTag(ItemStack is) {
        NBTTagCompound ret = is.func_77978_p();
        if (ret == null) {
            ret = new NBTTagCompound();
            is.func_77982_d(ret);
        }
        return ret;
    }

    public static String getCustomItemName(ItemStack is) {
        if (is.func_82837_s()) {
            return is.func_82833_r();
        }
        return null;
    }

    public static boolean itemCanFire(World w, ItemStack is, int tickDelay) {
        NBTTagCompound tag = FactorizationUtil.getTag(is);
        long t = tag.func_74763_f("lf");
        if (t > w.func_72820_D()) {
            tag.func_74772_a("lf", w.func_72820_D());
            return true;
        }
        if (t + (long)tickDelay > w.func_72820_D()) {
            return false;
        }
        tag.func_74772_a("lf", w.func_72820_D());
        return true;
    }

    public static ItemStack normalize(ItemStack is) {
        if (is == null || is.field_77994_a <= 0) {
            return null;
        }
        return is;
    }

    public static int getStackSize(ItemStack is) {
        if (is == null) {
            return 0;
        }
        return is.field_77994_a;
    }

    public static int getFreeSpace(ItemStack is, int stackLimit) {
        int max = Math.min(is.func_77976_d(), stackLimit);
        return Math.max(0, max - is.field_77994_a);
    }

    @Deprecated
    public static ItemStack transferStackToArea(IInventory srcInv, int slotIndex, IInventory destInv, Iterable targetSlots) {
        ItemStack target;
        int i;
        ItemStack is = srcInv.func_70301_a(slotIndex);
        if (is == null || is.field_77994_a == 0) {
            return null;
        }
        Iterator i$ = targetSlots.iterator();
        while (i$.hasNext()) {
            i = (Integer)i$.next();
            target = destInv.func_70301_a(i);
            if (target == null) continue;
            if (FactorizationUtil.couldMerge(is, target)) {
                int free_space = target.func_77976_d() - target.field_77994_a;
                int incr = Math.min(free_space, is.field_77994_a);
                if (incr <= 0) continue;
                is.field_77994_a -= incr;
                target.field_77994_a += incr;
            }
            if (is.field_77994_a > 0) continue;
            srcInv.func_70299_a(slotIndex, null);
            return null;
        }
        i$ = targetSlots.iterator();
        while (i$.hasNext()) {
            i = (Integer)i$.next();
            target = destInv.func_70301_a(i);
            if (target != null) continue;
            destInv.func_70299_a(i, is.func_77946_l());
            is.field_77994_a = 0;
            srcInv.func_70299_a(slotIndex, null);
            return null;
        }
        if (is.field_77994_a <= 0) {
            srcInv.func_70299_a(slotIndex, null);
            return null;
        }
        srcInv.func_70299_a(slotIndex, is);
        return is;
    }

    public static ItemStack transferSlotToSlots(Slot clickSlot, Iterable destinations) {
        ItemStack clickStack = FactorizationUtil.normalize(clickSlot.func_75211_c());
        if (clickStack == null) {
            return null;
        }
        for (Slot slot : destinations) {
            int freeSpace;
            ItemStack is = FactorizationUtil.normalize(slot.func_75211_c());
            if (is == null || !FactorizationUtil.couldMerge(is, clickStack) || (freeSpace = Math.min(is.func_77976_d() - is.field_77994_a, slot.func_75219_a() - is.field_77994_a)) <= 0 || !slot.func_75214_a(clickStack)) continue;
            int delta = Math.min(freeSpace, clickStack.field_77994_a);
            is.field_77994_a += delta;
            slot.func_75215_d(is);
            clickStack.field_77994_a -= delta;
            if (clickStack.field_77994_a > 0) continue;
            clickSlot.func_75215_d(null);
            return null;
        }
        for (Slot slot : destinations) {
            if (slot.func_75216_d() || !slot.func_75214_a(clickStack)) continue;
            int freeSpace = Math.min(slot.func_75219_a(), clickStack.func_77976_d());
            int delta = Math.min(freeSpace, clickStack.field_77994_a);
            ItemStack toPut = clickStack.func_77946_l();
            toPut.field_77994_a = delta;
            slot.func_75215_d(toPut);
            clickStack.field_77994_a -= delta;
            if ((clickStack = FactorizationUtil.normalize(clickStack)) != null) continue;
            clickSlot.func_75215_d(null);
            return null;
        }
        clickSlot.func_75215_d(FactorizationUtil.normalize(clickStack));
        return null;
    }

    public static FzInv openInventory(IInventory orig_inv, ForgeDirection side) {
        return FactorizationUtil.openInventory(orig_inv, side.ordinal(), true);
    }

    public static FzInv openInventory(IInventory orig_inv, ForgeDirection side, boolean openBothChests) {
        return FactorizationUtil.openInventory(orig_inv, side.ordinal(), openBothChests);
    }

    public static FzInv openInventory(IInventory orig_inv, int side) {
        return FactorizationUtil.openInventory(orig_inv, side, true);
    }

    public static FzInv openInventory(IInventory orig_inv, final int side, boolean openBothChests) {
        if (orig_inv == null) {
            return null;
        }
        if (orig_inv instanceof TileEntityChest && (orig_inv = FactorizationUtil.openDoubleChest((TileEntityChest)orig_inv, openBothChests)) == null) {
            return null;
        }
        if (orig_inv instanceof net.minecraft.inventory.ISidedInventory) {
            final net.minecraft.inventory.ISidedInventory inv = (net.minecraft.inventory.ISidedInventory)orig_inv;
            final int[] slotMap = inv.func_94128_d(side);
            return new FzInv((IInventory)inv){

                @Override
                int slotIndex(int i) {
                    return slotMap[i];
                }

                @Override
                public int size() {
                    return slotMap.length;
                }

                @Override
                public boolean canExtract(int i, ItemStack is) {
                    return inv.func_102008_b(slotMap[i], is, side);
                }

                @Override
                public boolean canInsert(int i, ItemStack is) {
                    if (this.forceInsert) {
                        return true;
                    }
                    return inv.func_102007_a(slotMap[i], is, side);
                }
            };
        }
        if (orig_inv instanceof ISidedInventory) {
            ISidedInventory inv = (ISidedInventory)orig_inv;
            ForgeDirection fside = ForgeDirection.getOrientation((int)side);
            final int start_slot = inv.getStartInventorySide(fside);
            final int length = inv.getSizeInventorySide(fside);
            return new FzInv((IInventory)inv){

                @Override
                int slotIndex(int i) {
                    return start_slot + i;
                }

                @Override
                public int size() {
                    return length;
                }
            };
        }
        return new PlainInvWrapper(orig_inv);
    }

    public static FzInv openInventory(Entity ent, boolean access_players) {
        if (ent instanceof EntityPlayer && !access_players) {
            return null;
        }
        if (ent instanceof IInventory) {
            return FactorizationUtil.openInventory((IInventory)ent, ForgeDirection.UP);
        }
        if (ent instanceof EntityPlayer) {
            InventoryPlayer ip = ((EntityPlayer)ent).field_71071_by;
            return FactorizationUtil.openInventory((IInventory)ip, ForgeDirection.UP).slice(0, ip.field_70462_a.length);
        }
        return null;
    }

    public static boolean canAccessSlot(IInventory inv, int slot) {
        if (inv instanceof net.minecraft.inventory.ISidedInventory) {
            net.minecraft.inventory.ISidedInventory isi = (net.minecraft.inventory.ISidedInventory)inv;
            for (int i = 0; i < 6; ++i) {
                int[] slots = isi.func_94128_d(i);
                for (int j = 0; j < slots.length; ++j) {
                    if (slots[j] != slot) continue;
                    return true;
                }
            }
        } else if (inv instanceof ISidedInventory) {
            ISidedInventory isi = (ISidedInventory)inv;
            for (int i = 0; i < 6; ++i) {
                ForgeDirection side = ForgeDirection.getOrientation((int)i);
                int start = isi.getStartInventorySide(side);
                int end = start + isi.getSizeInventorySide(side);
                if (start > slot || slot >= end) continue;
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    public static IInventory openDoubleChest(TileEntityChest chest, boolean openBothSides) {
        TileEntityChest origChest = chest;
        World world = chest.field_70331_k;
        int i = chest.field_70329_l;
        int j = chest.field_70330_m;
        int k = chest.field_70327_n;
        int chestBlock = Block.field_72077_au.field_71990_ca;
        if (world.func_72798_a(i - 1, j, k) == chestBlock) {
            return new InventoryLargeChest(origChest.func_70303_b(), (IInventory)((TileEntityChest)world.func_72796_p(i - 1, j, k)), (IInventory)origChest);
        }
        if (world.func_72798_a(i, j, k - 1) == chestBlock) {
            return new InventoryLargeChest(origChest.func_70303_b(), (IInventory)((TileEntityChest)world.func_72796_p(i, j, k - 1)), (IInventory)origChest);
        }
        if (world.func_72798_a(i + 1, j, k) == chestBlock) {
            if (openBothSides) {
                return new InventoryLargeChest(origChest.func_70303_b(), (IInventory)origChest, (IInventory)((TileEntityChest)world.func_72796_p(i + 1, j, k)));
            }
            return null;
        }
        if (world.func_72798_a(i, j, k + 1) == chestBlock) {
            if (openBothSides) {
                return new InventoryLargeChest(origChest.func_70303_b(), (IInventory)origChest, (IInventory)((TileEntityChest)world.func_72796_p(i, j, k + 1)));
            }
            return null;
        }
        return chest;
    }

    public static IInventory openDoubleChest(IInventory inv, boolean openBothSides) {
        if (inv instanceof TileEntityChest) {
            return FactorizationUtil.openDoubleChest((TileEntityChest)inv, openBothSides);
        }
        return inv;
    }

    public static IRecipe createShapedRecipe(ItemStack result, Object ... args) {
        String var3 = "";
        int var4 = 0;
        int var5 = 0;
        int var6 = 0;
        if (args[var4] instanceof String[]) {
            String[] var7 = (String[])args[var4++];
            for (int var8 = 0; var8 < var7.length; ++var8) {
                String var9 = var7[var8];
                ++var6;
                var5 = var9.length();
                var3 = var3 + var9;
            }
        } else {
            while (args[var4] instanceof String) {
                String var11 = (String)args[var4++];
                ++var6;
                var5 = var11.length();
                var3 = var3 + var11;
            }
        }
        HashMap<Character, ItemStack> var12 = new HashMap<Character, ItemStack>();
        while (var4 < args.length) {
            Character var13 = (Character)args[var4];
            ItemStack var14 = null;
            if (args[var4 + 1] instanceof Item) {
                var14 = new ItemStack((Item)args[var4 + 1]);
            } else if (args[var4 + 1] instanceof Block) {
                var14 = new ItemStack((Block)args[var4 + 1], 1, -1);
            } else if (args[var4 + 1] instanceof ItemStack) {
                var14 = (ItemStack)args[var4 + 1];
            }
            var12.put(var13, var14);
            var4 += 2;
        }
        ItemStack[] var15 = new ItemStack[var5 * var6];
        for (int var16 = 0; var16 < var5 * var6; ++var16) {
            char var10 = var3.charAt(var16);
            var15[var16] = var12.containsKey(Character.valueOf(var10)) ? ((ItemStack)var12.get(Character.valueOf(var10))).func_77946_l() : null;
        }
        return new ShapedRecipes(var5, var6, var15, result);
    }

    public static IRecipe createShapelessRecipe(ItemStack result, Object ... args) {
        ArrayList<ItemStack> var3 = new ArrayList<ItemStack>();
        for (Object var7 : args) {
            if (var7 instanceof ItemStack) {
                var3.add(((ItemStack)var7).func_77946_l());
                continue;
            }
            if (var7 instanceof Item) {
                var3.add(new ItemStack((Item)var7));
                continue;
            }
            if (!(var7 instanceof Block)) {
                throw new RuntimeException("Invalid shapeless recipy!");
            }
            var3.add(new ItemStack((Block)var7));
        }
        return new ShapelessRecipes(result, var3);
    }

    public static EntityItem spawnItemStack(Coord c, ItemStack item2) {
        if (item2 == null) {
            return null;
        }
        double dx = (double)rand.nextFloat() * 0.5 - 0.5;
        double dy = (double)rand.nextFloat() * 0.5 - 0.5;
        double dz = (double)rand.nextFloat() * 0.5 - 0.5;
        EntityItem entityitem = new EntityItem(c.w, (double)c.x + 0.5, (double)c.y + 0.5, (double)c.z + 0.5, item2);
        entityitem.field_70181_x = 0.2 + rand.nextGaussian() * 0.02;
        entityitem.field_70159_w = rand.nextGaussian() * 0.02;
        entityitem.field_70179_y = rand.nextGaussian() * 0.02;
        c.w.func_72838_d((Entity)entityitem);
        return entityitem;
    }

    public static EntityItem spawnItemStack(Entity c, ItemStack item2) {
        if (item2 == null) {
            return null;
        }
        double dx = (double)rand.nextFloat() * 0.5 - 0.5;
        double dy = (double)rand.nextFloat() * 0.5 - 0.5;
        double dz = (double)rand.nextFloat() * 0.5 - 0.5;
        EntityItem entityitem = new EntityItem(c.field_70170_p, c.field_70165_t + (double)(c.field_70130_N / 2.0f), c.field_70163_u + (double)(c.field_70131_O / 2.0f), c.field_70161_v + (double)(c.field_70130_N / 2.0f), item2);
        entityitem.field_70181_x = 0.2 + rand.nextGaussian() * 0.02;
        entityitem.field_70159_w = rand.nextGaussian() * 0.02;
        entityitem.field_70179_y = rand.nextGaussian() * 0.02;
        c.field_70170_p.func_72838_d((Entity)entityitem);
        return entityitem;
    }

    public static int determineOrientation(EntityPlayer player) {
        if (player.field_70125_A > 75.0f) {
            return 0;
        }
        if (player.field_70125_A <= -75.0f) {
            return 1;
        }
        int var7 = MathHelper.func_76128_c((double)((double)((180.0f + player.field_70177_z) * 4.0f / 360.0f) + 0.5)) & 3;
        return var7 == 0 ? 2 : (var7 == 1 ? 5 : (var7 == 2 ? 3 : (var7 == 3 ? 4 : 0)));
    }

    public static DeltaCoord getFlatDiagonalFacing(EntityPlayer player) {
        double angle = Math.toRadians(90.0f + player.field_70177_z);
        int dx = Math.cos(angle) > 0.0 ? 1 : -1;
        int dz = Math.sin(angle) > 0.0 ? 1 : -1;
        return new DeltaCoord(dx, 0, dz);
    }

    public static Enum shiftEnum(Enum current, Enum[] values, int delta) {
        int next = current.ordinal() + delta;
        if (next < 0) {
            return values[values.length - 1];
        }
        if (next >= values.length) {
            return values[0];
        }
        return values[next];
    }

    public static void writeTank(NBTTagCompound tag, LiquidTank tank, String name2) {
        LiquidStack ls = tank.getLiquid();
        if (ls == null) {
            return;
        }
        NBTTagCompound liquid_tag = new NBTTagCompound(name2);
        ls.writeToNBT(liquid_tag);
        tag.func_74782_a(name2, (NBTBase)liquid_tag);
    }

    public static void readTank(NBTTagCompound tag, LiquidTank tank, String name2) {
        NBTTagCompound liquid_tag = tag.func_74775_l(name2);
        LiquidStack ls = LiquidStack.loadLiquidStackFromNBT((NBTTagCompound)liquid_tag);
        tank.setLiquid(ls);
    }

    public static void spill(Coord where, LiquidStack what) {
        if (what == null || what.amount < 0) {
            return;
        }
        LiquidEvent.fireEvent((LiquidEvent)new LiquidEvent.LiquidSpilledEvent(what, where.w, where.x, where.y, where.z));
    }

    public static Vec3 getMin(AxisAlignedBB aabb) {
        return Vec3.func_72443_a((double)aabb.field_72340_a, (double)aabb.field_72338_b, (double)aabb.field_72339_c);
    }

    public static void setMin(AxisAlignedBB aabb, Vec3 v) {
        aabb.field_72340_a = v.field_72450_a;
        aabb.field_72338_b = v.field_72448_b;
        aabb.field_72339_c = v.field_72449_c;
    }

    public static Vec3 getMax(AxisAlignedBB aabb) {
        return Vec3.func_72443_a((double)aabb.field_72336_d, (double)aabb.field_72337_e, (double)aabb.field_72334_f);
    }

    public static void setMax(AxisAlignedBB aabb, Vec3 v) {
        aabb.field_72336_d = v.field_72450_a;
        aabb.field_72337_e = v.field_72448_b;
        aabb.field_72334_f = v.field_72449_c;
    }

    public static Vec3 averageVec(Vec3 a, Vec3 b) {
        return Vec3.func_72443_a((double)((a.field_72450_a + b.field_72450_a) / 2.0), (double)((a.field_72448_b + b.field_72448_b) / 2.0), (double)((a.field_72449_c + b.field_72449_c) / 2.0));
    }

    public static boolean intersect(double la, double ha, double lb, double hb) {
        return !(ha < lb) && !(hb < la);
    }

    public static InventoryCrafting makeCraftingGrid() {
        return new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer entityplayer) {
                return false;
            }

            public void func_75130_a(IInventory iinventory) {
            }
        }, 3, 3);
    }

    public static EntityPlayer makePlayer(final Coord where, String use) {
        FakePlayer fakePlayer = new FakePlayer(where.w, "[FZ " + use + "]"){

            public ChunkCoordinates func_82114_b() {
                return new ChunkCoordinates(where.x, where.y, where.z);
            }
        };
        where.setAsEntityLocation((Entity)fakePlayer);
        return fakePlayer;
    }

    public static void addInventoryToArray(IInventory inv, ArrayList ret) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack is = FactorizationUtil.normalize(inv.func_70301_a(i));
            if (is == null) continue;
            ret.add(is);
        }
    }

    public static ArrayList dirtyDirectionCache() {
        ArrayList<ForgeDirection> ret = (ArrayList<ForgeDirection>)direction_cache.get();
        if (ret == null) {
            ret = new ArrayList<ForgeDirection>(6);
            for (int i = 0; i < 6; ++i) {
                ret.add(ForgeDirection.getOrientation((int)i));
            }
            direction_cache.set(ret);
        }
        return ret;
    }

    public static Random dirtyRandomCache() {
        Random ret = (Random)random_cache.get();
        if (ret == null) {
            ret = new Random();
            random_cache.set(ret);
        }
        return ret;
    }

    @SideOnly(value=Side.CLIENT)
    public static RenderBlocks getRB() {
        return Minecraft.func_71410_x().field_71438_f.field_72776_r;
    }

    public static class Container2IInventory
    implements IInventory {
        Container cont;

        public Container2IInventory(Container cont) {
            this.cont = cont;
        }

        public int func_70302_i_() {
            return this.cont.func_75138_a().size();
        }

        public ItemStack func_70301_a(int i) {
            return this.cont.func_75139_a(i).func_75211_c();
        }

        public ItemStack func_70298_a(int i, int j) {
            return this.cont.func_75139_a(i).func_75209_a(j);
        }

        public ItemStack func_70304_b(int i) {
            return null;
        }

        public void func_70299_a(int i, ItemStack itemstack) {
            this.cont.func_75141_a(i, itemstack);
        }

        public boolean func_94041_b(int i, ItemStack itemstack) {
            return this.cont.func_75139_a(i).func_75214_a(itemstack);
        }

        public String func_70303_b() {
            return "Container2IInventory wrapper";
        }

        public boolean func_94042_c() {
            return false;
        }

        public int func_70297_j_() {
            return 64;
        }

        public void func_70296_d() {
        }

        public boolean func_70300_a(EntityPlayer entityplayer) {
            return false;
        }

        public void func_70295_k_() {
        }

        public void func_70305_f() {
        }
    }

    public static class PlainInvWrapper
    extends FzInv {
        final int length;

        public PlainInvWrapper(IInventory inv) {
            super(inv);
            this.length = inv.func_70302_i_();
        }

        @Override
        int slotIndex(int i) {
            return i;
        }

        @Override
        public int size() {
            return this.length;
        }
    }

    public static class SubsetInv
    extends FzInv {
        final FzInv ui;
        int start;
        int end;

        public SubsetInv(FzInv ui, int start, int end) {
            super(ui.under);
            this.ui = ui;
            this.start = start;
            this.end = end;
        }

        @Override
        public int size() {
            return this.end - this.start;
        }

        @Override
        int slotIndex(int i) {
            return this.ui.slotIndex(this.start + i);
        }
    }

    public static abstract class FzInv {
        boolean forceInsert = false;
        final IInventory under;

        public abstract int size();

        abstract int slotIndex(int var1);

        public FzInv(IInventory inv) {
            this.under = inv;
        }

        void setInsertForce(boolean b) {
            this.forceInsert = b;
        }

        public ItemStack get(int i) {
            return this.under.func_70301_a(this.slotIndex(i));
        }

        public void set(int i, ItemStack is) {
            this.under.func_70299_a(this.slotIndex(i), is);
            this.under.func_70296_d();
        }

        public int getFreeSpace(int i) {
            ItemStack dest = this.get(i);
            if (dest == null) {
                return this.under.func_70297_j_();
            }
            int dest_free = dest.func_77976_d() - dest.field_77994_a;
            return Math.min(dest_free, this.under.func_70297_j_());
        }

        public boolean canPush(ItemStack is) {
            for (int i = 0; i < this.size(); ++i) {
                ItemStack here = this.get(i);
                if (this.get(i) == null) {
                    return true;
                }
                if (!FactorizationUtil.couldMerge(here, is)) continue;
                return true;
            }
            return false;
        }

        public ItemStack pushInto(int i, ItemStack is) {
            int slotIndex = this.slotIndex(i);
            if (!this.canInsert(i, is)) {
                return is;
            }
            ItemStack dest = this.under.func_70301_a(slotIndex);
            if (dest == null) {
                ItemStack toPut = is;
                int stack_limit = this.under.func_70297_j_();
                if (toPut.field_77994_a > stack_limit) {
                    toPut = is.func_77979_a(stack_limit);
                } else {
                    is = null;
                }
                this.under.func_70299_a(slotIndex, toPut);
                this.under.func_70296_d();
                return is;
            }
            if (!FactorizationUtil.couldMerge(dest, is)) {
                return is;
            }
            int dest_free = this.getFreeSpace(i);
            if (dest_free < 1) {
                return is;
            }
            int delta = Math.min(dest_free, is.field_77994_a);
            dest.field_77994_a += delta;
            is.field_77994_a -= delta;
            this.under.func_70299_a(slotIndex, dest);
            this.under.func_70296_d();
            return FactorizationUtil.normalize(is);
        }

        public boolean canExtract(int i, ItemStack is) {
            return true;
        }

        public boolean canInsert(int i, ItemStack is) {
            if (this.forceInsert) {
                return true;
            }
            return this.under.func_94041_b(this.slotIndex(i), is) && FactorizationUtil.couldMerge(this.get(i), is);
        }

        public boolean isEmpty() {
            for (int i = 0; i < this.size(); ++i) {
                if (this.get(i) == null) continue;
                return false;
            }
            return true;
        }

        public boolean transfer(FzInv dest_inv, int max_transfer, ItemStack exclude) {
            for (int i = 0; i < this.size(); ++i) {
                int orig_size;
                ItemStack is = FactorizationUtil.normalize(this.get(i));
                if (is == null || is == exclude || !this.canExtract(i, is)) continue;
                if (is.field_77994_a <= max_transfer) {
                    int orig_size2 = is.field_77994_a;
                    if (orig_size2 == FactorizationUtil.getStackSize(is = dest_inv.push(is))) continue;
                    this.set(i, is);
                    return true;
                }
                ItemStack to_push = is.func_77946_l();
                to_push.field_77994_a = orig_size = Math.min(to_push.field_77994_a, max_transfer);
                int taken = orig_size - FactorizationUtil.getStackSize(to_push = dest_inv.push(to_push));
                if (taken <= 0) continue;
                is.field_77994_a -= taken;
                is = FactorizationUtil.normalize(is);
                this.set(i, is);
                return true;
            }
            return false;
        }

        public boolean transfer(int i, FzInv dest_inv, int dest_i, int max_transfer) {
            ItemStack src = FactorizationUtil.normalize(this.get(i));
            if (src == null) {
                return false;
            }
            if (!this.canExtract(i, src)) {
                return false;
            }
            ItemStack dest = dest_inv.get(dest_i);
            if (dest == null) {
                dest = src.func_77946_l();
                dest.field_77994_a = 0;
            } else if (!FactorizationUtil.couldMerge(src, dest)) {
                return false;
            }
            if (!dest_inv.canInsert(dest_i, src)) {
                return false;
            }
            int dest_free = dest_inv.getFreeSpace(dest_i);
            if (dest_free < 1) {
                return false;
            }
            int delta = Math.min(dest_free, src.field_77994_a);
            delta = Math.min(max_transfer, delta);
            dest.field_77994_a += delta;
            src.field_77994_a -= delta;
            src = FactorizationUtil.normalize(src);
            dest_inv.set(dest_i, dest);
            this.set(i, src);
            dest_inv.under.func_70296_d();
            this.under.func_70296_d();
            return true;
        }

        public ItemStack push(ItemStack is) {
            ItemStack dest;
            int i;
            is = FactorizationUtil.normalize(is);
            for (i = 0; i < this.size(); ++i) {
                if (is == null) {
                    return null;
                }
                dest = this.get(i);
                if (dest == null) continue;
                is = FactorizationUtil.normalize(this.pushInto(i, is));
            }
            for (i = 0; i < this.size(); ++i) {
                if (is == null) {
                    return null;
                }
                dest = this.get(i);
                if (dest != null) continue;
                is = FactorizationUtil.normalize(this.pushInto(i, is));
            }
            return is;
        }

        public ItemStack peek() {
            for (int i = 0; i < this.size(); ++i) {
                ItemStack is = FactorizationUtil.normalize(this.get(i));
                if (is == null) continue;
                return is;
            }
            return null;
        }

        public ItemStack pull() {
            for (int i = 0; i < this.size(); ++i) {
                ItemStack ret = this.pull(i, 64);
                if (ret == null) continue;
                return ret;
            }
            return null;
        }

        public ItemStack pullFromSlot(int slot) {
            return this.pull(slot, 64);
        }

        public ItemStack pullWithLimit(int limit) {
            for (int i = 0; i < this.size(); ++i) {
                ItemStack ret = this.pull(i, limit);
                if (ret == null) continue;
                return ret;
            }
            return null;
        }

        public ItemStack pull(int slot, int limit) {
            return this.under.func_70298_a(this.slotIndex(slot), limit);
        }

        public ItemStack pull(ItemStack toMatch, int limit, boolean strict) {
            ItemStack ret = null;
            for (int i = 0; i < this.size(); ++i) {
                ItemStack pulled;
                ItemStack is = this.get(i);
                if ((!strict ? !FactorizationUtil.wildcardSimilar(toMatch, is) : !FactorizationUtil.couldMerge(toMatch, is)) || (pulled = FactorizationUtil.normalize(this.pull(i, limit))) == null) continue;
                limit -= pulled.field_77994_a;
                if (ret == null) {
                    ret = pulled;
                } else {
                    ret.field_77994_a += pulled.field_77994_a;
                }
                if (limit <= 0) break;
            }
            return ret;
        }

        private int slice_index(int i) {
            int size = this.size();
            while (i < 0 && size > 0) {
                i += size;
            }
            return i;
        }

        public FzInv slice(int start, int end) {
            start = this.slice_index(start);
            end = this.slice_index(end);
            start = Math.max(start, 0);
            if ((end = Math.min(end, this.size())) < start) {
                end = start;
            }
            if (start > end) {
                start = end;
            }
            return new SubsetInv(this, start, end);
        }
    }
}

