/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import factorization.common.Core;
import factorization.common.ItemOreProcessing;
import factorization.common.TileEntityCrystallizer;
import factorization.common.TileEntityGrinder;
import factorization.common.TileEntitySlagFurnace;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.liquids.LiquidContainerData;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.oredict.OreDictionary;

public class FactorizationOreProcessingHandler {
    private static final String waterBucket = "fz.waterBucketLike";
    private HashMap bestIngots = new HashMap();
    public static final float GRIND_MULTIPLY = 2.0f;
    public static final float REDUCE_MULTIPLY = 2.5f;
    public static final float CRYSTALLIZE_MULTIPLY = 3.0f;
    public static final float GRIND = 2.0f;
    public static final float WASH = 1.0f;
    public static final float REDUCE = 1.25f;
    public static final float CRYSTALLIZE = 1.2f;
    ArrayList createdBodies = new ArrayList();

    void addProcessingFront(ItemOreProcessing.OreType oreType, ItemStack ore) {
        ItemStack dirty = Core.registry.ore_dirty_gravel.makeStack(oreType);
        TileEntityGrinder.addRecipe(ore, dirty, 2.0f);
    }

    void addProcessingEnds(ItemOreProcessing.OreType oreType, ItemStack ore, ItemStack ingot) {
        oreType.enable();
        if (oreType != ItemOreProcessing.OreType.LEAD && oreType != ItemOreProcessing.OreType.SILVER && oreType != ItemOreProcessing.OreType.GALENA) {
            TileEntitySlagFurnace.SlagRecipes.register(ore, 1.2f, ingot, 0.4f, Block.field_71981_t);
        } else if (oreType == ItemOreProcessing.OreType.SILVER) {
            TileEntitySlagFurnace.SlagRecipes.register(ore, 1.2f, new ItemStack((Item)Core.registry.lead_ingot), 1.0f, ingot);
        }
        if (oreType.processingResult != null) {
            return;
        }
        oreType.processingResult = ingot;
        ItemStack dirty = Core.registry.ore_dirty_gravel.makeStack(oreType);
        ItemStack clean = Core.registry.ore_clean_gravel.makeStack(oreType);
        ItemStack reduced = Core.registry.ore_reduced.makeStack(oreType);
        ItemStack crystal = Core.registry.ore_crystal.makeStack(oreType);
        ItemStack[] smeltable = oreType == ItemOreProcessing.OreType.LEAD || oreType == ItemOreProcessing.OreType.SILVER ? new ItemStack[]{reduced, crystal} : (oreType == ItemOreProcessing.OreType.GALENA ? new ItemStack[]{dirty, clean} : new ItemStack[]{dirty, clean, reduced, crystal});
        for (ItemStack is : smeltable) {
            float xp = FurnaceRecipes.func_77602_a().getExperience(ore);
            FurnaceRecipes.func_77602_a().addSmelting(is.field_77993_c, is.func_77960_j(), ingot, xp);
        }
        if (oreType != ItemOreProcessing.OreType.LEAD && oreType != ItemOreProcessing.OreType.SILVER) {
            TileEntitySlagFurnace.SlagRecipes.register(dirty, 1.4285715f, ingot, 0.2f, Block.field_71979_v);
        }
    }

    void createProccessingBody(ItemOreProcessing.OreType oreType) {
        if (this.createdBodies.contains((Object)oreType)) {
            return;
        }
        this.createdBodies.add(oreType);
        ItemStack dirty = Core.registry.ore_dirty_gravel.makeStack(oreType);
        ItemStack clean = Core.registry.ore_clean_gravel.makeStack(oreType);
        ItemStack reduced = Core.registry.ore_reduced.makeStack(oreType);
        ItemStack crystal = Core.registry.ore_crystal.makeStack(oreType);
        ItemStack clean8 = clean.func_77946_l();
        clean8.field_77994_a = 8;
        Core.registry.shapelessOreRecipe(clean, waterBucket, dirty);
        Core.registry.shapelessOreRecipe(clean8, waterBucket, dirty, dirty, dirty, dirty, dirty, dirty, dirty, dirty);
        if (oreType == ItemOreProcessing.OreType.GALENA) {
            ItemStack reduced_silver = Core.registry.ore_reduced.makeStack(ItemOreProcessing.OreType.SILVER);
            ItemStack reduced_lead = Core.registry.ore_reduced.makeStack(ItemOreProcessing.OreType.LEAD);
            ItemStack crystal_silver = Core.registry.ore_crystal.makeStack(ItemOreProcessing.OreType.SILVER);
            ItemStack crystal_lead = Core.registry.ore_crystal.makeStack(ItemOreProcessing.OreType.LEAD);
            TileEntitySlagFurnace.SlagRecipes.register(clean, 1.25f, reduced_lead, 1.25f, reduced_silver);
            TileEntityCrystallizer.addRecipe(reduced_silver, crystal_silver, 1.2f, Core.registry.aqua_regia, 0);
            TileEntityCrystallizer.addRecipe(reduced_lead, crystal_lead, 1.2f, Core.registry.aqua_regia, 0);
        } else {
            boolean r = true;
            TileEntitySlagFurnace.SlagRecipes.register(clean, (float)r, reduced, 1.25f - (float)r, reduced);
            TileEntityCrystallizer.addRecipe(reduced, crystal, 1.2f, Core.registry.aqua_regia, 0);
        }
    }

    void handleNewOre(String oreClass, ItemStack ore) {
        ItemOreProcessing.OreType oreType = ItemOreProcessing.OreType.fromOreClass(oreClass);
        if (oreType == null) {
            return;
        }
        if (ItemOreProcessing.OD_ores.contains(oreClass)) {
            oreType.enable();
            this.addProcessingFront(oreType, ore);
            this.createProccessingBody(oreType);
            ItemStack ingot = (ItemStack)this.bestIngots.get(oreClass);
            if (ingot == null) {
                ingot = oreType.processingResult;
            }
            if (ingot == null) {
                ingot = FurnaceRecipes.func_77602_a().getSmeltingResult(ore);
            }
            if (ingot != null) {
                if (oreType == ItemOreProcessing.OreType.GALENA) {
                    this.addProcessingEnds(ItemOreProcessing.OreType.LEAD, ore, new ItemStack((Item)Core.registry.lead_ingot));
                    this.addProcessingEnds(ItemOreProcessing.OreType.SILVER, ore, new ItemStack((Item)Core.registry.silver_ingot));
                    this.addProcessingEnds(ItemOreProcessing.OreType.GALENA, ore, new ItemStack((Item)Core.registry.silver_ingot));
                } else {
                    this.addProcessingEnds(oreType, ore, ingot);
                    oreType.processingResult = ingot;
                }
            }
        }
    }

    @ForgeSubscribe
    public void registerOre(OreDictionary.OreRegisterEvent evt) {
        this.handleNewOre(evt.Name, evt.Ore);
    }

    void loadWater() {
        LiquidStack h20 = LiquidContainerRegistry.getLiquidForFilledItem((ItemStack)new ItemStack(Item.field_77786_ax));
        for (LiquidContainerData container : LiquidContainerRegistry.getRegisteredLiquidContainerData()) {
            LiquidStack liq = container.stillLiquid;
            if (!h20.isLiquidEqual(liq) || liq.amount != 1000) continue;
            OreDictionary.registerOre((String)waterBucket, (ItemStack)container.filled);
        }
    }

    void addDictOres() {
        this.loadWater();
        this.handleNewOre("ingotIron", new ItemStack(Item.field_77703_o, 1));
        this.handleNewOre("oreIron", new ItemStack(Block.field_71949_H, 1));
        this.handleNewOre("ingotGold", new ItemStack(Item.field_77717_p, 1));
        this.handleNewOre("oreGold", new ItemStack(Block.field_71941_G, 1));
        for (String oreClass : ItemOreProcessing.OD_ores) {
            ItemStack bestIngot = null;
            ArrayList oreList = OreDictionary.getOres((String)oreClass);
            if (oreList == null || !oreList.iterator().hasNext()) continue;
            for (ItemStack ore : oreList) {
                ItemStack smeltsTo = FurnaceRecipes.func_77602_a().getSmeltingResult(ore);
                if (smeltsTo == null || bestIngot != null && ore.func_77960_j() == 0) continue;
                bestIngot = smeltsTo;
            }
            if (bestIngot == null) continue;
            this.bestIngots.put(oreClass, bestIngot);
            for (ItemStack ore : oreList) {
                this.handleNewOre(oreClass, ore);
            }
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }
}

