/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import factorization.api.DeltaCoord;

class CubeFace {
    private static final int[] side_reverser = new int[]{1, 0, 3, 2, 5, 4};
    int side;
    private static final int[][] vecMap = new int[][]{{0, -1, 0}, {0, 1, 0}, {0, 0, -1}, {0, 0, 1}, {-1, 0, 0}, {1, 0, 0}};
    private static final long[] edgeMap = new long[]{CubeFace.e(0, 1, 2, 3), CubeFace.e(4, 5, 6, 7), CubeFace.e(4, 8, 0, 11), CubeFace.e(6, 9, 2, 10), CubeFace.e(7, 10, 3, 11), CubeFace.e(5, 8, 1, 9)};
    private static final long[] edge2face = new long[12];

    public CubeFace(int side) {
        this.side = side;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CubeFace) {
            return ((CubeFace)obj).side == this.side;
        }
        return false;
    }

    static int oppositeSide(int side) {
        return side_reverser[side];
    }

    CubeFace opposite() {
        return new CubeFace(side_reverser[this.side]);
    }

    DeltaCoord toVector() {
        int[] a = vecMap[this.side];
        return new DeltaCoord(a[0], a[1], a[2]);
    }

    static CubeFace fromVector(DeltaCoord d) {
        for (int side = 0; side < vecMap.length; ++side) {
            if (d.x != vecMap[side][0] || d.y != vecMap[side][1] || d.z != vecMap[side][2]) continue;
            return new CubeFace(side);
        }
        return null;
    }

    long getFaceFlag() {
        return 1 << this.side;
    }

    private static long e(int ... args) {
        long r = 0L;
        for (int a : args) {
            r |= (long)(1 << a);
        }
        return r;
    }

    long getEdgeFlags() {
        return edgeMap[this.side];
    }

    static long getEdgeFlags(int side) {
        return edgeMap[side];
    }

    static long getFacesTouchingEdge(int edge) {
        return edge2face[edge];
    }

    static {
        for (int edge = 0; edge < 12; ++edge) {
            long edge_flag = 1 << edge;
            for (int side = 0; side < 6; ++side) {
                if ((edgeMap[side] & edge_flag) == 0L) continue;
                int n = edge;
                edge2face[n] = edge2face[n] | (long)(1 << side);
            }
        }
    }
}

