/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import factorization.common.ContainerPocket;
import factorization.common.Core;
import factorization.common.FactorizationUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;

public enum Command {
    bagShuffle(1),
    craftClear(2),
    craftMove(3),
    craftBalance(4),
    craftOpen(5, true),
    bagShuffleReverse(6),
    craftFill(11);

    public byte id;
    boolean executeLocally = false;
    public Command reverse = this;

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private Command() {
        void id;
        this.id = (byte)id;
        name.map.put(this.id, this);
    }

    /*
     * WARNING - void declaration
     */
    private Command() {
        this((String)var1_-1, (int)var2_-1, (int)id);
        void executeLocally;
        void id;
        void var2_-1;
        void var1_-1;
        this.executeLocally = executeLocally;
    }

    void setReverse(Command rev) {
        rev.reverse = this;
        this.reverse = rev;
    }

    static void fromNetwork(EntityPlayer player, byte s, byte arg) {
        Command c = (Command)((Object)name.map.get(s));
        if (c == null) {
            Core.logWarning("Received invalid command #" + s, new Object[0]);
            return;
        }
        c.call(player, arg);
    }

    public void call(EntityPlayer player) {
        this.call(player, (byte)0);
    }

    public void call(EntityPlayer player, byte arg) {
        if (player == null) {
            return;
        }
        if (player.field_70170_p.field_72995_K) {
            Core.network.sendCommand(player, this, arg);
            if (!this.executeLocally) {
                return;
            }
        }
        switch (this) {
            case bagShuffle: {
                Core.registry.bag_of_holding.useBag(player, false);
                break;
            }
            case bagShuffleReverse: {
                Core.registry.bag_of_holding.useBag(player, true);
                break;
            }
            case craftClear: {
                this.craftClear(player);
                break;
            }
            case craftMove: {
                this.craftMove(player);
                break;
            }
            case craftBalance: {
                this.craftBalance(player);
                break;
            }
            case craftFill: {
                this.craftFill(player, arg);
                break;
            }
            case craftOpen: {
                Core.registry.pocket_table.tryOpen(player);
                break;
            }
            default: {
                throw new RuntimeException("Command " + (Object)((Object)this) + " is missing handler");
            }
        }
    }

    void craftClear(EntityPlayer player) {
        if (!(player.field_71070_bA instanceof ContainerPocket)) {
            return;
        }
        ContainerPocket pocket = (ContainerPocket)player.field_71070_bA;
        Iterator i$ = ContainerPocket.craftArea.iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            pocket.func_82846_b(player, i);
        }
    }

    private boolean rotateAll(InventoryPlayer inv, int[] slots) {
        int empty = 0;
        for (int slot : slots) {
            if (FactorizationUtil.normalize(inv.func_70301_a(slot)) != null) continue;
            ++empty;
        }
        if (empty >= 2) {
            return false;
        }
        ArrayList<Object> buffer = new ArrayList<Object>(8);
        for (int slot : slots) {
            ItemStack toAdd = inv.func_70301_a(slot);
            buffer.add(buffer.size(), toAdd);
        }
        buffer.add(0, buffer.remove(buffer.size() - 1));
        for (int slot : slots) {
            ItemStack toSet = (ItemStack)buffer.remove(0);
            inv.func_70299_a(slot, toSet);
        }
        return true;
    }

    private boolean smear(InventoryPlayer inv, int[] slots) {
        int stackSrcSlotIndex = 0;
        boolean foundNonEmpty = false;
        for (int slot : slots) {
            if (inv.func_70301_a(slot) != null) {
                foundNonEmpty = true;
                continue;
            }
            if (!foundNonEmpty) continue;
            ItemStack toDrop = null;
            for (int count = 0; count < slots.length; ++count) {
                ItemStack here = inv.func_70301_a(slots[stackSrcSlotIndex]);
                if (++stackSrcSlotIndex == slots.length) {
                    stackSrcSlotIndex = 0;
                }
                if (here == null || here.field_77994_a <= 1) continue;
                toDrop = here;
                break;
            }
            if (toDrop == null) {
                return true;
            }
            inv.func_70299_a(slot, toDrop.func_77979_a(1));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void craftMove(EntityPlayer player) {
        InventoryPlayer inv = player.field_71071_by;
        int[] slots = new int[]{15, 16, 17, 26, 35, 34, 33, 24};
        try {
            if (this.rotateAll(inv, slots)) {
                return;
            }
            if (this.smear(inv, slots)) {
                return;
            }
        }
        finally {
            if (player.field_71070_bA instanceof ContainerPocket) {
                ((ContainerPocket)player.field_71070_bA).updateMatrix();
            }
        }
    }

    void craftBalance(EntityPlayer player) {
        InventoryPlayer inv = player.field_71071_by;
        int[] slots = new int[]{15, 16, 17, 24, 25, 26, 33, 34, 35};
        class Accumulator {
            ItemStack toMatch;
            int stackCount = 0;
            ArrayList matchingSlots = new ArrayList(9);

            public Accumulator(ItemStack toMatch, int slot) {
                this.toMatch = toMatch;
                this.stackCount = toMatch.field_77994_a;
                toMatch.field_77994_a = 0;
                this.matchingSlots.add(slot);
            }

            boolean add(ItemStack ta, int slot) {
                if (FactorizationUtil.couldMerge(this.toMatch, ta)) {
                    this.stackCount += ta.field_77994_a;
                    ta.field_77994_a = 0;
                    this.matchingSlots.add(slot);
                    return true;
                }
                return false;
            }
        }
        ArrayList<Accumulator> list = new ArrayList<Accumulator>(9);
        for (int slot : slots) {
            ItemStack here = inv.func_70301_a(slot);
            if (here == null || here.field_77994_a == 0) continue;
            boolean found = false;
            for (Accumulator acc : list) {
                if (!acc.add(here, slot)) continue;
                found = true;
            }
            if (found) continue;
            list.add(new Accumulator(here, slot));
        }
        for (Accumulator acc : list) {
            int slot;
            int delta = acc.stackCount / acc.matchingSlots.size();
            delta = Math.min(delta, 1);
            Iterator i$ = acc.matchingSlots.iterator();
            while (i$.hasNext()) {
                slot = (Integer)i$.next();
                if (acc.stackCount <= 0) break;
                inv.func_70301_a((int)slot).field_77994_a = delta;
                acc.stackCount -= delta;
            }
            block4: while (acc.stackCount > 0) {
                i$ = acc.matchingSlots.iterator();
                while (i$.hasNext()) {
                    slot = (Integer)i$.next();
                    if (acc.stackCount <= 0) continue block4;
                    ++inv.func_70301_a((int)slot).field_77994_a;
                    --acc.stackCount;
                }
            }
        }
        if (player.field_71070_bA instanceof ContainerPocket) {
            ((ContainerPocket)player.field_71070_bA).updateMatrix();
        }
    }

    void craftFill(EntityPlayer player, byte slot) {
        InventoryPlayer inv = player.field_71071_by;
        ItemStack toMove = inv.func_70301_a((int)slot);
        if (toMove == null) {
            return;
        }
        Iterator i$ = ContainerPocket.playerCraftInvSlots.iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            if (toMove.field_77994_a <= 0) break;
            ItemStack is = inv.func_70301_a(i);
            if (is != null) continue;
            inv.func_70299_a(i, toMove.func_77979_a(1));
        }
        inv.func_70299_a((int)slot, FactorizationUtil.normalize(toMove));
    }

    static {
        bagShuffle.setReverse(bagShuffleReverse);
    }

    static class name {
        static HashMap map = new HashMap();

        name() {
        }
    }
}

