/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.Coord;
import factorization.api.Quaternion;
import factorization.api.VectorUV;
import factorization.common.BlockIcons;
import factorization.common.Core;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.Icon;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class BlockRenderHelper
extends Block {
    public static BlockRenderHelper instance;
    public Icon[] textures;
    private Icon[] repetitionCache = new Icon[6];
    private static final int X = 0;
    private static final int Y = 1;
    private static final int Z = 2;
    private static final int U = 3;
    private static final int V = 4;
    private static ForgeDirection[] dirs;
    private static VectorUV center;
    private int[] colors = new int[6];
    static Vec3 midCache;
    VectorUV[] currentFace;
    VectorUV[][] faceCache;
    private static final float[] directionLighting;

    public BlockRenderHelper() {
        super(Core.factory_block_id, Material.field_76247_b);
        this.resetColors();
        this.faceCache = new VectorUV[6][4];
        for (int i = 0; i < this.faceCache.length; ++i) {
            this.currentFace = this.faceCache[i];
            for (int j = 0; j < this.currentFace.length; ++j) {
                this.currentFace[j] = new VectorUV();
            }
        }
        BlockRenderHelper.field_71973_m[this.field_71990_ca] = null;
        BlockRenderHelper.field_71970_n[this.field_71990_ca] = false;
        BlockRenderHelper.field_71971_o[this.field_71990_ca] = 0;
        BlockRenderHelper.field_71985_p[this.field_71990_ca] = false;
        if (instance == null) {
            instance = this;
        }
    }

    public BlockRenderHelper setBlockBoundsOffset(float x, float y, float z) {
        this.func_71905_a(x, y, z, 1.0f - x, 1.0f - y, 1.0f - z);
        return this;
    }

    public BlockRenderHelper setBlockBoundsBasedOnRotation() {
        double maxZ;
        double maxY;
        double maxX;
        this.currentFace = this.faceCache[0];
        double minX = maxX = this.currentFace[0].x;
        double minY = maxY = this.currentFace[0].y;
        double minZ = maxZ = this.currentFace[0].z;
        for (int face = 0; face < this.faceCache.length; ++face) {
            this.currentFace = this.faceCache[face];
            for (int i = 1; i < this.currentFace.length; ++i) {
                VectorUV vec = this.currentFace[i];
                minX = Math.min(minX, vec.x);
                minY = Math.min(minY, vec.y);
                minZ = Math.min(minZ, vec.z);
                maxX = Math.max(maxX, vec.x);
                maxY = Math.max(maxY, vec.y);
                maxZ = Math.max(maxZ, vec.z);
            }
        }
        this.func_71905_a((float)minX, (float)minY, (float)minZ, (float)maxX, (float)maxY, (float)maxZ);
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderHelper useTexture(Icon texture) {
        this.textures = this.repetitionCache;
        for (int i = 0; i < this.textures.length; ++i) {
            this.textures[i] = texture;
        }
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderHelper useTextures(Icon ... textures) {
        this.textures = textures;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderHelper setTexture(int i, Icon texture) {
        this.textures = this.repetitionCache;
        this.textures[i] = texture;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_71877_c(IBlockAccess w, int x, int y, int z, int side) {
        return this.textures[side] != null;
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int side, int md) {
        Icon ret;
        try {
            ret = this.textures[side];
        }
        catch (NullPointerException e) {
            this.textures = new Icon[6];
            this.textures[side] = BlockIcons.error;
            return this.textures[side];
        }
        if (ret == null) {
            return BlockIcons.error;
        }
        return this.textures[side];
    }

    @SideOnly(value=Side.CLIENT)
    public void renderForTileEntity() {
        this.renderRotated(Tessellator.field_78398_a, 0, 0, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderForInventory(RenderBlocks renderblocks) {
        Tessellator tessellator = Tessellator.field_78398_a;
        int i = 0;
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        renderblocks.func_83018_a((Block)this);
        tessellator.func_78382_b();
        Icon texture = this.textures[i++];
        if (texture != null) {
            tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
            renderblocks.func_78613_a((Block)this, 0.0, 0.0, 0.0, texture);
        }
        if ((texture = this.textures[i++]) != null) {
            tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
            renderblocks.func_78617_b((Block)this, 0.0, 0.0, 0.0, texture);
        }
        if ((texture = this.textures[i++]) != null) {
            tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
            renderblocks.func_78611_c((Block)this, 0.0, 0.0, 0.0, texture);
        }
        if ((texture = this.textures[i++]) != null) {
            tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
            renderblocks.func_78622_d((Block)this, 0.0, 0.0, 0.0, texture);
        }
        if ((texture = this.textures[i++]) != null) {
            tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
            renderblocks.func_78573_e((Block)this, 0.0, 0.0, 0.0, texture);
        }
        if ((texture = this.textures[i++]) != null) {
            tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
            renderblocks.func_78605_f((Block)this, 0.0, 0.0, 0.0, texture);
        }
        tessellator.func_78381_a();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    @SideOnly(value=Side.CLIENT)
    public void render(RenderBlocks rb, int x, int y, int z) {
        rb.func_83020_a(this.field_72026_ch, this.field_72023_ci, this.field_72024_cj, this.field_72021_ck, this.field_72022_cl, this.field_72019_cm);
        rb.func_78570_q((Block)this, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public void render(RenderBlocks rb, Coord c) {
        rb.func_83020_a(this.field_72026_ch, this.field_72023_ci, this.field_72024_cj, this.field_72021_ck, this.field_72022_cl, this.field_72019_cm);
        rb.func_78570_q((Block)this, c.x, c.y, c.z);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderHelper begin() {
        for (int i = 0; i < 6; ++i) {
            Icon faceIcon = this.textures[i];
            if (faceIcon == null) continue;
            this.currentFace = this.faceCache[i];
            this.faceVerts(i);
            for (int f = 0; f < this.currentFace.length; ++f) {
                VectorUV vert = this.currentFace[f];
                vert.u = faceIcon.func_94214_a(vert.u * 16.0);
                vert.v = faceIcon.func_94207_b(vert.v * 16.0);
            }
        }
        BlockRenderHelper.center.x = (this.field_72026_ch + this.field_72021_ck) / 2.0;
        BlockRenderHelper.center.y = (this.field_72023_ci + this.field_72022_cl) / 2.0;
        BlockRenderHelper.center.z = (this.field_72024_cj + this.field_72019_cm) / 2.0;
        return this;
    }

    public BlockRenderHelper beginNoIcons() {
        for (int i = 0; i < 6; ++i) {
            this.currentFace = this.faceCache[i];
            this.faceVerts(i);
        }
        return this;
    }

    boolean hasTexture(int f) {
        return Core.proxy.BlockRenderHelper_has_texture(this, f);
    }

    public BlockRenderHelper rotate(Quaternion q) {
        for (int f = 0; f < this.faceCache.length; ++f) {
            if (!this.hasTexture(f)) continue;
            VectorUV[] face = this.faceCache[f];
            for (int v = 0; v < face.length; ++v) {
                q.applyRotation(face[v]);
            }
        }
        q.applyRotation(center);
        return this;
    }

    public BlockRenderHelper rotateMiddle(Quaternion q) {
        Vec3 d = this.getBoundsMiddle();
        this.translate((float)(-d.field_72450_a), (float)(-d.field_72448_b), (float)(-d.field_72449_c));
        this.rotate(q);
        this.translate((float)d.field_72450_a, (float)d.field_72448_b, (float)d.field_72449_c);
        return this;
    }

    public BlockRenderHelper translate(float dx, float dy, float dz) {
        for (int f = 0; f < this.faceCache.length; ++f) {
            if (!this.hasTexture(f)) continue;
            VectorUV[] face = this.faceCache[f];
            for (int v = 0; v < face.length; ++v) {
                face[v].x += (double)dx;
                face[v].y += (double)dy;
                face[v].z += (double)dz;
            }
        }
        BlockRenderHelper.center.x += (double)dx;
        BlockRenderHelper.center.y += (double)dy;
        BlockRenderHelper.center.z += (double)dz;
        return this;
    }

    public void setColor(int index, int color) {
        this.colors[index] = color;
    }

    public void setColor(int color) {
        for (int i = 0; i < this.colors.length; ++i) {
            this.colors[i] = color;
        }
    }

    public void resetColors() {
        for (int i = 0; i < this.colors.length; ++i) {
            this.colors[i] = 0xFFFFFF;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderRotated(Tessellator tess, int x, int y, int z) {
        for (int f = 0; f < this.faceCache.length; ++f) {
            if (this.textures[f] == null) continue;
            VectorUV[] face = this.faceCache[f];
            float lighting = BlockRenderHelper.getNormalizedLighting(face, center);
            int color = this.colors[f];
            float color_r = (color & 0xFF0000) >> 16;
            float color_g = (color & 0xFF00) >> 8;
            float color_b = color & 0xFF;
            tess.func_78386_a(lighting * color_r, lighting * color_g, lighting * color_b);
            for (int i = 0; i < face.length; ++i) {
                VectorUV vert = face[i];
                tess.func_78374_a(vert.x + (double)x, vert.y + (double)y, vert.z + (double)z, vert.u, vert.v);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderRotated(Tessellator tess, Coord c) {
        if (c == null) {
            this.renderRotated(tess, 0, 0, 0);
        }
        for (int f = 0; f < this.faceCache.length; ++f) {
            if (this.textures[f] == null) continue;
            VectorUV[] face = this.faceCache[f];
            float lighting = BlockRenderHelper.getNormalizedLighting(face, center);
            tess.func_78386_a(lighting, lighting, lighting);
            int brightness = this.func_71874_e((IBlockAccess)c.w, c.x, c.y, c.z);
            tess.func_78380_c(brightness);
            for (int v = 0; v < face.length; ++v) {
                VectorUV vert = face[v];
                tess.func_78374_a(vert.x + (double)c.x, vert.y + (double)c.y, vert.z + (double)c.z, vert.u, vert.v);
            }
        }
    }

    public Vec3 getBoundsMiddle() {
        BlockRenderHelper.midCache.field_72450_a = (this.field_72026_ch + this.field_72021_ck) / 2.0;
        BlockRenderHelper.midCache.field_72448_b = (this.field_72023_ci + this.field_72022_cl) / 2.0;
        BlockRenderHelper.midCache.field_72449_c = (this.field_72024_cj + this.field_72019_cm) / 2.0;
        return midCache;
    }

    private void faceVerts(int face) {
        int i;
        int c = 8;
        switch (face) {
            case 0: {
                this.set(0, 1, 0, 1);
                this.set(1, 0, 0, 1);
                this.set(2, 0, 0, 0);
                this.set(3, 1, 0, 0);
                break;
            }
            case 1: {
                this.set(0, 1, 1, 0);
                this.set(1, 0, 1, 0);
                this.set(2, 0, 1, 1);
                this.set(3, 1, 1, 1);
                break;
            }
            case 2: {
                this.set(0, 1, 1, 0);
                this.set(1, 1, 0, 0);
                this.set(2, 0, 0, 0);
                this.set(3, 0, 1, 0);
                break;
            }
            case 3: {
                this.set(0, 1, 1, 1);
                this.set(1, 0, 1, 1);
                this.set(2, 0, 0, 1);
                this.set(3, 1, 0, 1);
                break;
            }
            case 4: {
                this.set(0, 0, 0, 1);
                this.set(1, 0, 1, 1);
                this.set(2, 0, 1, 0);
                this.set(3, 0, 0, 0);
                break;
            }
            case 5: {
                this.set(0, 1, 1, 1);
                this.set(1, 1, 0, 1);
                this.set(2, 1, 0, 0);
                this.set(3, 1, 1, 0);
            }
        }
        switch (face) {
            case 0: 
            case 1: {
                VectorUV vert;
                int i2;
                for (i2 = 0; i2 < this.currentFace.length; ++i2) {
                    vert = this.currentFace[i2];
                    vert.u = vert.x;
                    vert.v = vert.z;
                }
                break;
            }
            case 2: {
                VectorUV vert;
                int i2;
                for (i2 = 0; i2 < this.currentFace.length; ++i2) {
                    vert = this.currentFace[i2];
                    vert.u = 1.0 - vert.x;
                    vert.v = 1.0 - vert.y;
                }
                break;
            }
            case 3: {
                VectorUV vert;
                int i2;
                for (i2 = 0; i2 < this.currentFace.length; ++i2) {
                    vert = this.currentFace[i2];
                    vert.u = vert.x;
                    vert.v = 1.0 - vert.y;
                }
                break;
            }
            case 4: {
                VectorUV vert;
                int i2;
                for (i2 = 0; i2 < this.currentFace.length; ++i2) {
                    vert = this.currentFace[i2];
                    vert.u = vert.z;
                    vert.v = 1.0 - vert.y;
                }
                break;
            }
            case 5: {
                VectorUV vert;
                int i2;
                for (i2 = 0; i2 < this.currentFace.length; ++i2) {
                    vert = this.currentFace[i2];
                    vert.u = 1.0 - vert.z;
                    vert.v = 1.0 - vert.y;
                }
                break;
            }
            default: {
                throw new RuntimeException("Invalid face number");
            }
        }
        VectorUV[] cache = this.currentFace;
        boolean WIDTH = true;
        for (i = 0; i < cache.length; ++i) {
            VectorUV main = cache[i];
            double udelta = 0.0;
            double vdelta = 0.0;
            int nada = 0;
            if (main.u > (double)WIDTH) {
                udelta = main.u - (double)WIDTH;
            } else if (main.u < 0.0) {
                udelta = main.u;
            } else {
                ++nada;
            }
            if (main.v > (double)WIDTH) {
                vdelta = main.v - (double)WIDTH;
            } else if (main.v < 0.0) {
                vdelta = main.v;
            } else {
                ++nada;
            }
            if (nada == 2) continue;
            for (int J = 0; J < cache.length; ++J) {
                VectorUV other = cache[J];
                other.u -= udelta;
                other.v -= vdelta;
            }
        }
        for (i = 0; i < this.currentFace.length; ++i) {
            VectorUV vec = this.currentFace[i];
            vec.u = BlockRenderHelper.clip(vec.u);
            vec.v = BlockRenderHelper.clip(vec.v);
        }
    }

    static double clip(double v) {
        return Math.max(0.0, Math.min(1.0, v));
    }

    private void set(int i, int X, int Y, int Z) {
        this.currentFace[i].x = X == 0 ? this.field_72026_ch : this.field_72021_ck;
        this.currentFace[i].y = Y == 0 ? this.field_72023_ci : this.field_72022_cl;
        this.currentFace[i].z = Z == 0 ? this.field_72024_cj : this.field_72019_cm;
    }

    private static ForgeDirection getFaceDirection(VectorUV[] vecs, VectorUV center) {
        VectorUV here = vecs[0].add(vecs[2]);
        here.scale(0.5);
        here = here.add(center);
        double x = Math.abs(here.x);
        double y = Math.abs(here.y);
        double z = Math.abs(here.z);
        if (x >= y && x >= z) {
            return here.x >= 0.0 ? ForgeDirection.WEST : ForgeDirection.EAST;
        }
        if (y >= x && y >= z) {
            return here.y >= 0.0 ? ForgeDirection.UP : ForgeDirection.DOWN;
        }
        if (z >= x && z >= y) {
            return here.z >= 0.0 ? ForgeDirection.SOUTH : ForgeDirection.NORTH;
        }
        return ForgeDirection.UP;
    }

    private static float getNormalizedLighting(VectorUV[] vecs, VectorUV center) {
        return directionLighting[BlockRenderHelper.getFaceDirection(vecs, center).ordinal()];
    }

    static {
        dirs = ForgeDirection.values();
        center = new VectorUV();
        midCache = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        directionLighting = new float[]{0.5f, 1.0f, 0.8f, 0.8f, 0.6f, 0.6f};
    }
}

