/*
 * Decompiled with CFR 0.152.
 */
package factorization.api.recipe;

import factorization.api.recipe.GenericRecipeOutput;
import factorization.api.recipe.IGenericRecipeInput;
import factorization.common.FactorizationUtil;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class GenericRecipe {
    public IGenericRecipeInput[] inputs;
    public GenericRecipeOutput[] outputs;

    public GenericRecipe(IGenericRecipeInput[] inputs, GenericRecipeOutput[] outputs) {
        this.inputs = inputs;
        this.outputs = outputs;
    }

    public boolean canCraft(IInventory input, IInventory output) {
        return this.inputMatches(input) && this.roomForOutput(output);
    }

    public void apply(IInventory input, IInventory output) {
        ItemStack[] outputs = this.getOutputs(Math.random());
    }

    private boolean inputMatches(IInventory inv) {
        for (int inp = 0; inp < this.inputs.length; ++inp) {
            IGenericRecipeInput input = this.inputs[inp];
            boolean match = false;
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack is = inv.func_70301_a(i);
                if (is == null || !input.matches(is)) continue;
                match = true;
                break;
            }
            if (match) continue;
            return false;
        }
        return true;
    }

    private boolean roomForOutput(IInventory inv) {
        ItemStack[] outs = this.getOutputs(1.0);
        int stackLimit = inv.func_70297_j_();
        for (int o = 0; o < outs.length; ++o) {
            ItemStack out = outs[o];
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack is = inv.func_70301_a(i);
                if (is == null) {
                    out.field_77994_a -= stackLimit;
                    continue;
                }
                if (!out.func_77969_a(is)) continue;
                out.field_77994_a -= FactorizationUtil.getFreeSpace(is, stackLimit);
                if (out.field_77994_a <= 0) break;
            }
            if (out.field_77994_a <= 0) continue;
            return false;
        }
        return true;
    }

    private ItemStack[] getOutputs(double random) {
        ItemStack[] ret = new ItemStack[this.outputs.length];
        for (int i = 0; i < this.outputs.length; ++i) {
            ret[i] = this.outputs[i].getOutput(random);
        }
        return ret;
    }
}

