/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick.opengl;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.newdawn.slick.opengl.ImageData;
import org.newdawn.slick.opengl.LoadableImageData;
import org.newdawn.slick.opengl.PNGDecoder;
import org.newdawn.slick.util.Log;

public class PNGImageData
implements LoadableImageData {
    private int width;
    private int height;
    private int texHeight;
    private int texWidth;
    private PNGDecoder decoder;
    private ImageData.Format format;
    private ByteBuffer scratch;

    @Override
    public ImageData.Format getFormat() {
        return this.format;
    }

    @Override
    public ByteBuffer getImageBufferData() {
        return this.scratch;
    }

    @Override
    public int getTexHeight() {
        return this.texHeight;
    }

    @Override
    public int getTexWidth() {
        return this.texWidth;
    }

    @Override
    public ByteBuffer loadImage(InputStream fis) throws IOException {
        return this.loadImage(fis, false, null);
    }

    @Override
    public ByteBuffer loadImage(InputStream fis, boolean flipped, int[] transparent) throws IOException {
        return this.loadImage(fis, flipped, false, transparent);
    }

    @Override
    public ByteBuffer loadImage(InputStream fis, boolean flipped, boolean forceAlpha, int[] transparent) throws IOException {
        int i;
        if (transparent != null) {
            forceAlpha = true;
        }
        PNGDecoder decoder = new PNGDecoder(fis);
        this.width = decoder.getWidth();
        this.height = decoder.getHeight();
        this.texWidth = this.get2Fold(this.width);
        this.texHeight = this.get2Fold(this.height);
        PNGDecoder.Format decoderFormat = forceAlpha ? (decoder.isRGB() ? decoder.decideTextureFormat(PNGDecoder.Format.RGBA) : decoder.decideTextureFormat(PNGDecoder.Format.LUMINANCE_ALPHA)) : decoder.decideTextureFormat(PNGDecoder.Format.LUMINANCE);
        switch (decoderFormat) {
            case RGB: {
                this.format = ImageData.Format.RGB;
                break;
            }
            case RGBA: {
                this.format = ImageData.Format.RGBA;
                break;
            }
            case BGRA: {
                this.format = ImageData.Format.BGRA;
                break;
            }
            case LUMINANCE: {
                this.format = ImageData.Format.GRAY;
                break;
            }
            case LUMINANCE_ALPHA: {
                this.format = ImageData.Format.GRAYALPHA;
                break;
            }
            default: {
                throw new IOException("Unsupported Image format.");
            }
        }
        int perPixel = this.format.getColorComponents();
        this.scratch = BufferUtils.createByteBuffer((int)(this.texWidth * this.texHeight * perPixel));
        if (flipped) {
            decoder.decodeFlipped(this.scratch, this.texWidth * perPixel, decoderFormat);
        } else {
            decoder.decode(this.scratch, this.texWidth * perPixel, decoderFormat);
        }
        if (this.height < this.texHeight - 1) {
            int topOffset = (this.texHeight - 1) * (this.texWidth * perPixel);
            int bottomOffset = (this.height - 1) * (this.texWidth * perPixel);
            for (int x = 0; x < this.texWidth; ++x) {
                for (i = 0; i < perPixel; ++i) {
                    this.scratch.put(topOffset + x + i, this.scratch.get(x + i));
                    this.scratch.put(bottomOffset + this.texWidth * perPixel + x + i, this.scratch.get(bottomOffset + x + i));
                }
            }
        }
        if (this.width < this.texWidth - 1) {
            for (int y = 0; y < this.texHeight; ++y) {
                for (int i2 = 0; i2 < perPixel; ++i2) {
                    this.scratch.put((y + 1) * (this.texWidth * perPixel) - perPixel + i2, this.scratch.get(y * (this.texWidth * perPixel) + i2));
                    this.scratch.put(y * (this.texWidth * perPixel) + this.width * perPixel + i2, this.scratch.get(y * (this.texWidth * perPixel) + (this.width - 1) * perPixel + i2));
                }
            }
        }
        this.scratch.position(0);
        if (transparent != null) {
            int components = this.format.getColorComponents();
            if (transparent.length != components - 1) {
                Log.warn("The amount of color components of the transparent color does not fit the number of color components of the actual image.");
            }
            if (transparent.length < components - 1) {
                Log.error("Failed to apply transparent color, not enough color values in color definition.");
            } else {
                int size = this.texWidth * this.texHeight * components;
                for (i = 0; i < size; i += components) {
                    boolean match = true;
                    for (int c = 0; c < components - 1; ++c) {
                        if (this.toInt(this.scratch.get(i + c)) == transparent[c]) continue;
                        match = false;
                        break;
                    }
                    if (!match) continue;
                    this.scratch.put(i + components - 1, (byte)0);
                }
            }
        }
        this.scratch.position(0);
        return this.scratch;
    }

    private int toInt(byte b) {
        if (b < 0) {
            return 256 + b;
        }
        return b;
    }

    private int get2Fold(int fold) {
        int ret;
        for (ret = 2; ret < fold; ret *= 2) {
        }
        return ret;
    }

    @Override
    public void configureEdging(boolean edging) {
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }
}

