/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.utils;

import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.IPowerModule;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IRightClickModule;
import net.machinemuse.general.MuseLogger;
import net.machinemuse.powersuits.client.render.modelspec.DefaultModelSpec;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.network.packets.MusePacketModeChangeRequest;
import net.machinemuse.powersuits.tick.RenderTickHandler;
import net.machinemuse.utils.MuseMathUtils;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;

public class MuseItemUtils {
    public static final String NBTPREFIX = "mmmpsmod";
    public static final String ONLINE = "Active";

    public static List getValidModulesForItem(EntityPlayer player, ItemStack stack) {
        ArrayList<IPowerModule> validModules = new ArrayList<IPowerModule>();
        for (IPowerModule module : ModuleManager.getAllModules()) {
            if (!module.isValidForItem(stack, player)) continue;
            validModules.add(module);
        }
        return validModules;
    }

    private static int clampMode(int selection, int modesSize) {
        if (selection > 0) {
            return selection % modesSize;
        }
        return (selection + modesSize * -selection) % modesSize;
    }

    @SideOnly(value=Side.CLIENT)
    public static void cycleMode(ItemStack stack, EntityClientPlayerMP player, int dMode) {
        if (stack != null && stack.func_77973_b() instanceof IModularItem) {
            NBTTagCompound itemTag = MuseItemUtils.getMuseItemTag(stack);
            String mode = itemTag.func_74779_i("Mode");
            List modes = MuseItemUtils.getModes(stack, (EntityPlayer)player);
            if (mode.isEmpty() && modes.size() > 0) {
                mode = (String)modes.get(0);
            }
            if (modes.size() > 0 && dMode != 0) {
                int modeIndex = modes.indexOf(mode);
                String newMode = (String)modes.get(MuseItemUtils.clampMode(modeIndex + dMode, modes.size()));
                itemTag.func_74778_a("Mode", newMode);
                RenderTickHandler.lastSwapTime = System.currentTimeMillis();
                RenderTickHandler.lastSwapDirection = (int)Math.signum(dMode);
                MusePacketModeChangeRequest modeChangePacket = new MusePacketModeChangeRequest((Player)player, newMode, player.field_71071_by.field_70461_c);
                player.field_71174_a.func_72552_c((Packet)modeChangePacket.getPacket250());
            }
        }
    }

    public static boolean tagHasModule(NBTTagCompound tag, String moduleName) {
        return tag.func_74764_b(moduleName);
    }

    public static List getValidModes(ItemStack stack, EntityPlayer player) {
        ArrayList<String> modes = new ArrayList<String>();
        if (stack.func_77973_b() instanceof IModularItem) {
            for (IPowerModule module : ModuleManager.getAllModules()) {
                if (!module.isValidForItem(stack, player) || !(module instanceof IRightClickModule)) continue;
                modes.add(module.getName());
            }
        }
        return modes;
    }

    public static List getModes(ItemStack stack, EntityPlayer player) {
        ArrayList<String> modes = new ArrayList<String>();
        if (stack.func_77973_b() instanceof IModularItem) {
            for (IPowerModule module : ModuleManager.getAllModules()) {
                if (!module.isValidForItem(stack, player) || !(module instanceof IRightClickModule) || !MuseItemUtils.itemHasModule(stack, module.getName())) continue;
                modes.add(module.getName());
            }
        }
        return modes;
    }

    public static boolean isModuleOnline(NBTTagCompound itemTag, String moduleName) {
        if (MuseItemUtils.tagHasModule(itemTag, moduleName) && !itemTag.func_74775_l(moduleName).func_74764_b(ONLINE)) {
            return true;
        }
        return MuseItemUtils.tagHasModule(itemTag, moduleName) && itemTag.func_74775_l(moduleName).func_74767_n(ONLINE);
    }

    public static void toggleModule(NBTTagCompound itemTag, String name, boolean toggleval) {
        if (MuseItemUtils.tagHasModule(itemTag, name)) {
            NBTTagCompound moduleTag = itemTag.func_74775_l(name);
            moduleTag.func_74757_a(ONLINE, toggleval);
        }
    }

    public static boolean itemHasModule(ItemStack stack, String moduleName) {
        return MuseItemUtils.tagHasModule(MuseItemUtils.getMuseItemTag(stack), moduleName);
    }

    public static void tagAddModule(NBTTagCompound tag, IPowerModule module) {
        tag.func_74766_a(module.getName(), module.getNewTag());
    }

    public static void itemAddModule(ItemStack stack, IPowerModule moduleType) {
        MuseItemUtils.tagAddModule(MuseItemUtils.getMuseItemTag(stack), moduleType);
    }

    public static boolean removeModule(NBTTagCompound tag, String moduleName) {
        if (tag.func_74764_b(moduleName)) {
            tag.func_82580_o(moduleName);
            return true;
        }
        return false;
    }

    public static boolean removeModule(ItemStack stack, String moduleName) {
        return MuseItemUtils.removeModule(MuseItemUtils.getMuseItemTag(stack), moduleName);
    }

    public static NBTTagCompound getMuseItemTag(ItemStack stack) {
        NBTTagCompound properties;
        NBTTagCompound stackTag;
        if (stack == null) {
            return null;
        }
        if (stack.func_77942_o()) {
            stackTag = stack.func_77978_p();
        } else {
            stackTag = new NBTTagCompound();
            stack.func_77982_d(stackTag);
        }
        if (stackTag.func_74764_b(NBTPREFIX)) {
            properties = stackTag.func_74775_l(NBTPREFIX);
        } else {
            properties = new NBTTagCompound();
            stackTag.func_74766_a(NBTPREFIX, properties);
        }
        return properties;
    }

    public static NBTTagCompound getMuseRenderTag(ItemStack stack, int armorSlot) {
        NBTTagCompound tag = MuseItemUtils.getMuseItemTag(stack);
        if (!tag.func_74764_b("render") || !(tag.func_74781_a("render") instanceof NBTTagCompound)) {
            MuseLogger.logDebug("TAG BREACH IMMINENT, PLEASE HOLD ONTO YOUR SEATBELTS");
            tag.func_82580_o("render");
            tag.func_74782_a("render", (NBTBase)DefaultModelSpec.makeModelPrefs(stack, armorSlot));
        }
        return tag.func_74775_l("render");
    }

    public static NBTTagCompound getMuseRenderTag(ItemStack stack) {
        NBTTagCompound tag = MuseItemUtils.getMuseItemTag(stack);
        if (!tag.func_74764_b("render") || !(tag.func_74781_a("render") instanceof NBTTagCompound)) {
            tag.func_82580_o("render");
            tag.func_74782_a("render", (NBTBase)new NBTTagCompound());
        }
        return tag.func_74775_l("render");
    }

    public static List getModularItemsInInventory(IInventory inv) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack == null || !(stack.func_77973_b() instanceof IModularItem)) continue;
            stacks.add(stack);
        }
        return stacks;
    }

    public static List getModularItemsInInventory(EntityPlayer player) {
        return MuseItemUtils.getModularItemsInInventory((IInventory)player.field_71071_by);
    }

    public static List getModularItemSlotsInInventory(IInventory inv) {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack == null || !(stack.func_77973_b() instanceof IModularItem)) continue;
            slots.add(i);
        }
        return slots;
    }

    public static IModularItem getAsModular(Item item) {
        if (item instanceof IModularItem) {
            return (IModularItem)item;
        }
        return null;
    }

    public static boolean hasInInventory(List workingUpgradeCost, InventoryPlayer inventory) {
        for (ItemStack stackInCost : workingUpgradeCost) {
            int found = 0;
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack stackInInventory = inventory.func_70301_a(i);
                if (!MuseItemUtils.isSameItem(stackInInventory, stackInCost)) continue;
                found += stackInInventory.field_77994_a;
            }
            if (found >= stackInCost.field_77994_a) continue;
            return false;
        }
        return true;
    }

    public static List deleteFromInventory(List cost, InventoryPlayer inventory) {
        LinkedList<Integer> slots = new LinkedList<Integer>();
        for (ItemStack stackInCost : cost) {
            int remaining = stackInCost.field_77994_a;
            for (int i = 0; i < inventory.func_70302_i_() && remaining > 0; ++i) {
                ItemStack stackInInventory = inventory.func_70301_a(i);
                if (!MuseItemUtils.isSameItem(stackInInventory, stackInCost)) continue;
                int numToTake = Math.min(stackInInventory.field_77994_a, remaining);
                stackInInventory.field_77994_a -= numToTake;
                remaining -= numToTake;
                if (stackInInventory.field_77994_a == 0) {
                    inventory.func_70299_a(i, null);
                }
                slots.add(i);
            }
        }
        return slots;
    }

    public static List findInInventoryForCost(List workingUpgradeCost, InventoryPlayer inventory) {
        LinkedList<Integer> slots = new LinkedList<Integer>();
        for (ItemStack stackInCost : workingUpgradeCost) {
            int found = 0;
            for (int i = 0; i < inventory.func_70302_i_() && found < stackInCost.field_77994_a; ++i) {
                ItemStack stackInInventory = inventory.func_70301_a(i);
                if (!MuseItemUtils.isSameItem(stackInInventory, stackInCost)) continue;
                found += stackInInventory.field_77994_a;
                slots.add(i);
            }
        }
        return slots;
    }

    public static double getDoubleOrZero(NBTTagCompound itemProperties, String string) {
        double value = 0.0;
        if (itemProperties != null && itemProperties.func_74764_b(string)) {
            value = itemProperties.func_74769_h(string);
        }
        return value;
    }

    public static double getDoubleOrZero(ItemStack stack, String string) {
        return MuseItemUtils.getDoubleOrZero(MuseItemUtils.getMuseItemTag(stack), string);
    }

    public static void setDoubleOrRemove(NBTTagCompound itemProperties, String string, double value) {
        if (itemProperties != null) {
            if (value == 0.0) {
                itemProperties.func_82580_o(string);
            } else {
                itemProperties.func_74780_a(string, value);
            }
        }
    }

    public static void setDoubleOrRemove(ItemStack stack, String string, double value) {
        MuseItemUtils.setDoubleOrRemove(MuseItemUtils.getMuseItemTag(stack), string, value);
    }

    public static String getStringOrNull(NBTTagCompound itemProperties, String key) {
        String value = null;
        if (itemProperties != null && itemProperties.func_74764_b(key)) {
            value = itemProperties.func_74779_i(key);
        }
        return value;
    }

    public static String getStringOrNull(ItemStack stack, String key) {
        return MuseItemUtils.getStringOrNull(MuseItemUtils.getMuseItemTag(stack), key);
    }

    public static void setStringOrNull(NBTTagCompound itemProperties, String key, String value) {
        if (itemProperties != null) {
            if (value.isEmpty()) {
                itemProperties.func_82580_o(key);
            } else {
                itemProperties.func_74778_a(key, value);
            }
        }
    }

    public static void setStringOrNull(ItemStack stack, String key, String value) {
        MuseItemUtils.setStringOrNull(MuseItemUtils.getMuseItemTag(stack), key, value);
    }

    public static List modularItemsEquipped(EntityPlayer player) {
        ItemStack[] equipped;
        ArrayList<ItemStack> modulars = new ArrayList<ItemStack>(5);
        for (ItemStack stack : equipped = MuseItemUtils.itemsEquipped(player)) {
            if (stack == null || !(stack.func_77973_b() instanceof IModularItem)) continue;
            modulars.add(stack);
        }
        return modulars;
    }

    public static ItemStack[] itemsEquipped(EntityPlayer player) {
        ItemStack[] equipped = new ItemStack[]{player.field_71071_by.field_70460_b[0], player.field_71071_by.field_70460_b[1], player.field_71071_by.field_70460_b[2], player.field_71071_by.field_70460_b[3], player.field_71071_by.func_70448_g()};
        return equipped;
    }

    public static boolean canStackTogether(ItemStack stack1, ItemStack stack2) {
        if (!MuseItemUtils.isSameItem(stack1, stack2)) {
            return false;
        }
        if (!stack1.func_77985_e()) {
            return false;
        }
        return stack1.field_77994_a < stack1.func_77976_d();
    }

    public static boolean isSameItem(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null || stack2 == null) {
            return false;
        }
        if (stack1.field_77993_c != stack2.field_77993_c) {
            return false;
        }
        return stack1.func_77984_f() || stack1.func_77960_j() == stack2.func_77960_j();
    }

    public static void transferStackWithChance(ItemStack itemsToGive, ItemStack destinationStack, double chanceOfSuccess) {
        if (MuseItemUtils.isSameItem(itemsToGive, ItemComponent.lvcapacitor)) {
            itemsToGive.field_77994_a = 0;
            return;
        }
        if (MuseItemUtils.isSameItem(itemsToGive, ItemComponent.mvcapacitor)) {
            itemsToGive.field_77994_a = 0;
            return;
        }
        if (MuseItemUtils.isSameItem(itemsToGive, ItemComponent.hvcapacitor)) {
            itemsToGive.field_77994_a = 0;
            return;
        }
        int maxSize = destinationStack.func_77976_d();
        while (itemsToGive.field_77994_a > 0 && destinationStack.field_77994_a < maxSize) {
            --itemsToGive.field_77994_a;
            if (!(MuseMathUtils.nextDouble() < chanceOfSuccess)) continue;
            ++destinationStack.field_77994_a;
        }
    }

    public static Set giveOrDropItems(ItemStack itemsToGive, EntityPlayer player) {
        return MuseItemUtils.giveOrDropItemWithChance(itemsToGive, player, 1.0);
    }

    public static Set giveOrDropItemWithChance(ItemStack itemsToGive, EntityPlayer player, double chanceOfSuccess) {
        int i;
        HashSet<Integer> slots = new HashSet<Integer>();
        for (i = 0; i < player.field_71071_by.func_70302_i_() && itemsToGive.field_77994_a > 0; ++i) {
            ItemStack currentStack = player.field_71071_by.func_70301_a(i);
            if (!MuseItemUtils.canStackTogether(currentStack, itemsToGive)) continue;
            slots.add(i);
            MuseItemUtils.transferStackWithChance(itemsToGive, currentStack, chanceOfSuccess);
        }
        for (i = 0; i < player.field_71071_by.func_70302_i_() && itemsToGive.field_77994_a > 0; ++i) {
            if (player.field_71071_by.func_70301_a(i) != null) continue;
            ItemStack destination = new ItemStack(itemsToGive.field_77993_c, 0, itemsToGive.func_77960_j());
            MuseItemUtils.transferStackWithChance(itemsToGive, destination, chanceOfSuccess);
            if (destination.field_77994_a <= 0) continue;
            player.field_71071_by.func_70299_a(i, destination);
            slots.add(i);
        }
        if (itemsToGive.field_77994_a > 0) {
            for (i = 0; i < itemsToGive.field_77994_a; ++i) {
                if (!(MuseMathUtils.nextDouble() < chanceOfSuccess)) continue;
                ItemStack copyStack = itemsToGive.func_77946_l();
                copyStack.field_77994_a = 1;
                player.func_71021_b(copyStack);
            }
        }
        return slots;
    }

    public static double getPlayerWeight(EntityPlayer player) {
        double weight = 0.0;
        for (ItemStack stack : MuseItemUtils.modularItemsEquipped(player)) {
            weight += ModuleManager.computeModularProperty(stack, "Weight");
        }
        return weight;
    }

    public static List getPlayerInstalledModules(EntityPlayer player) {
        ArrayList<IPowerModule> installedModules = new ArrayList<IPowerModule>();
        for (ItemStack stack : MuseItemUtils.modularItemsEquipped(player)) {
            NBTTagCompound itemTag = MuseItemUtils.getMuseItemTag(stack);
            for (IPowerModule module : MuseItemUtils.getValidModulesForItem(player, stack)) {
                if (!MuseItemUtils.tagHasModule(itemTag, module.getName())) continue;
                installedModules.add(module);
            }
        }
        return installedModules;
    }

    public static void toggleModuleForPlayer(EntityPlayer player, String name, boolean toggleval) {
        for (ItemStack stack : MuseItemUtils.modularItemsEquipped(player)) {
            NBTTagCompound itemTag = MuseItemUtils.getMuseItemTag(stack);
            MuseItemUtils.toggleModule(itemTag, name, toggleval);
        }
    }

    public static boolean itemHasActiveModule(ItemStack itemStack, String moduleName) {
        IPowerModule module = ModuleManager.getModule(moduleName);
        if (module == null || itemStack == null || !module.isAllowed() || !(itemStack.func_77973_b() instanceof IModularItem)) {
            return false;
        }
        if (module instanceof IRightClickModule) {
            return moduleName.equals(MuseItemUtils.getActiveMode(itemStack));
        }
        return MuseItemUtils.isModuleOnline(MuseItemUtils.getMuseItemTag(itemStack), moduleName);
    }

    public static String getActiveMode(ItemStack itemStack) {
        return MuseItemUtils.getMuseItemTag(itemStack).func_74779_i("Mode");
    }

    public static ItemStack copyAndResize(ItemStack stack, int number) {
        ItemStack copy = stack.func_77946_l();
        copy.field_77994_a = number;
        return copy;
    }
}

