/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.tool;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IBlockBreakingModule;
import net.machinemuse.api.moduletrigger.IRightClickModule;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.machinemuse.utils.MusePlayerUtils;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class ShearsModule
extends PowerModuleBase
implements IBlockBreakingModule,
IRightClickModule {
    public static final ItemStack shears = new ItemStack((Item)Item.field_77745_be);
    private static final String SHEARING_ENERGY_CONSUMPTION = "Shearing Energy Consumption";
    private static final String SHEARING_HARVEST_SPEED = "Shearing Harvest Speed";

    public ShearsModule(List validItems) {
        super(validItems);
        this.addInstallCost(new ItemStack(Item.field_77703_o, 2));
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.solenoid, 1));
        this.addBaseProperty(SHEARING_ENERGY_CONSUMPTION, 50.0, "J");
        this.addBaseProperty(SHEARING_HARVEST_SPEED, 8.0, "x");
        this.addTradeoffProperty("Overclock", SHEARING_ENERGY_CONSUMPTION, 950.0);
        this.addTradeoffProperty("Overclock", SHEARING_HARVEST_SPEED, 22.0);
    }

    @Override
    public String getCategory() {
        return "Tool";
    }

    @Override
    public String getName() {
        return "Shears";
    }

    @Override
    public String getDescription() {
        return "Cuts through leaves, wool, and creepers alike.";
    }

    @Override
    public void onRightClick(EntityPlayer playerClicking, World world, ItemStack stack) {
        if (playerClicking.field_70170_p.field_72995_K) {
            return;
        }
        MovingObjectPosition hitMOP = MusePlayerUtils.raytraceEntities(world, playerClicking, false, 8.0);
        if (hitMOP != null && hitMOP.field_72308_g instanceof IShearable) {
            IShearable target = (IShearable)hitMOP.field_72308_g;
            Entity entity = hitMOP.field_72308_g;
            if (target.isShearable(stack, entity.field_70170_p, (int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v)) {
                ArrayList drops = target.onSheared(stack, entity.field_70170_p, (int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v, EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)stack));
                Random rand = new Random();
                for (ItemStack drop : drops) {
                    EntityItem ent = entity.func_70099_a(drop, 1.0f);
                    ent.field_70181_x += (double)(rand.nextFloat() * 0.05f);
                    ent.field_70159_w += (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f);
                    ent.field_70179_y += (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f);
                }
                ElectricItemUtils.drainPlayerEnergy(playerClicking, ModuleManager.computeModularProperty(stack, SHEARING_ENERGY_CONSUMPTION));
            }
        }
    }

    @Override
    public void onItemUse(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
    }

    @Override
    public boolean onItemUseFirst(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void onPlayerStoppedUsing(ItemStack itemStack, World world, EntityPlayer player, int par4) {
    }

    @Override
    public boolean canHarvestBlock(ItemStack stack, Block block, int meta, EntityPlayer player) {
        return (shears.func_77987_b(block) || ForgeHooks.canToolHarvestBlock((Block)block, (int)meta, (ItemStack)shears) || shears.func_77967_a(block) > 1.0f) && ElectricItemUtils.getPlayerEnergy(player) > ModuleManager.computeModularProperty(stack, SHEARING_ENERGY_CONSUMPTION);
    }

    @Override
    public boolean onBlockDestroyed(ItemStack itemstack, World world, int blockID, int x, int y, int z, EntityPlayer player) {
        IShearable target;
        if (player.field_70170_p.field_72995_K) {
            return false;
        }
        int id = player.field_70170_p.func_72798_a(x, y, z);
        if (Block.field_71973_m[id] instanceof IShearable && ElectricItemUtils.getPlayerEnergy(player) > ModuleManager.computeModularProperty(itemstack, SHEARING_ENERGY_CONSUMPTION) && (target = (IShearable)Block.field_71973_m[id]).isShearable(itemstack, player.field_70170_p, x, y, z)) {
            ArrayList drops = target.onSheared(itemstack, player.field_70170_p, x, y, z, EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)itemstack));
            Random rand = new Random();
            for (ItemStack stack : drops) {
                float f = 0.7f;
                double d = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d1 = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d2 = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                EntityItem entityitem = new EntityItem(player.field_70170_p, (double)x + d, (double)y + d1, (double)z + d2, stack);
                entityitem.field_70293_c = 10;
                player.field_70170_p.func_72838_d((Entity)entityitem);
            }
            ElectricItemUtils.drainPlayerEnergy(player, ModuleManager.computeModularProperty(itemstack, SHEARING_ENERGY_CONSUMPTION));
            player.func_71064_a(StatList.field_75934_C[id], 1);
        }
        return false;
    }

    @Override
    public void handleBreakSpeed(PlayerEvent.BreakSpeed event) {
        float defaultEffectiveness = shears.func_77967_a(event.block);
        double ourEffectiveness = ModuleManager.computeModularProperty(event.entityPlayer.func_71045_bC(), SHEARING_HARVEST_SPEED);
        event.newSpeed = (float)((double)event.newSpeed * Math.max((double)defaultEffectiveness, ourEffectiveness));
    }

    @Override
    public Icon getIcon(ItemStack item) {
        return shears.func_77954_c();
    }

    @Override
    public String getTextureFile() {
        return null;
    }
}

