/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.tool;

import java.util.List;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IBlockBreakingModule;
import net.machinemuse.api.moduletrigger.IToggleableModule;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class AquaAffinityModule
extends PowerModuleBase
implements IBlockBreakingModule,
IToggleableModule {
    public static final String MODULE_AQUA_AFFINITY = "Aqua Affinity";
    public static final String AQUA_AFFINITY_ENERGY_CONSUMPTION = "Underwater Energy Consumption";
    public static final String UNDERWATER_HARVEST_SPEED = "Underwater Harvest Speed";

    public AquaAffinityModule(List validItems) {
        super(validItems);
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.servoMotor, 1));
        this.addBaseProperty(AQUA_AFFINITY_ENERGY_CONSUMPTION, 0.0, "J");
        this.addBaseProperty(UNDERWATER_HARVEST_SPEED, 0.2, "%");
        this.addTradeoffProperty("Power", AQUA_AFFINITY_ENERGY_CONSUMPTION, 100.0);
        this.addTradeoffProperty("Power", UNDERWATER_HARVEST_SPEED, 0.8);
    }

    @Override
    public String getCategory() {
        return "Special";
    }

    @Override
    public String getName() {
        return MODULE_AQUA_AFFINITY;
    }

    @Override
    public String getDescription() {
        return "Reduces the speed penalty for using your tool underwater.";
    }

    @Override
    public boolean canHarvestBlock(ItemStack stack, Block block, int meta, EntityPlayer player) {
        return false;
    }

    @Override
    public boolean onBlockDestroyed(ItemStack stack, World world, int blockID, int x, int y, int z, EntityPlayer player) {
        if (player.func_70055_a(Material.field_76244_g) || !player.field_70122_E) {
            ElectricItemUtils.drainPlayerEnergy(player, ModuleManager.computeModularProperty(stack, AQUA_AFFINITY_ENERGY_CONSUMPTION));
        }
        return true;
    }

    @Override
    public void handleBreakSpeed(PlayerEvent.BreakSpeed event) {
        EntityPlayer player = event.entityPlayer;
        ItemStack stack = player.func_71045_bC();
        if (event.newSpeed > 1.0f && (player.func_70055_a(Material.field_76244_g) || !player.field_70122_E) && ElectricItemUtils.getPlayerEnergy(player) > ModuleManager.computeModularProperty(stack, AQUA_AFFINITY_ENERGY_CONSUMPTION)) {
            event.newSpeed = (float)((double)event.newSpeed * (5.0 * ModuleManager.computeModularProperty(stack, UNDERWATER_HARVEST_SPEED)));
        }
    }

    @Override
    public String getTextureFile() {
        return "aquaaffinity";
    }
}

