/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.movement;

import java.util.List;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IPlayerTickModule;
import net.machinemuse.api.moduletrigger.IToggleableModule;
import net.machinemuse.general.sound.Musique;
import net.machinemuse.powersuits.control.PlayerInputMap;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.machinemuse.utils.MusePlayerUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class JetBootsModule
extends PowerModuleBase
implements IToggleableModule,
IPlayerTickModule {
    public static final String MODULE_JETBOOTS = "Jet Boots";
    public static final String JET_ENERGY_CONSUMPTION = "Jetboots Energy Consumption";
    public static final String JET_THRUST = "Jetboots Thrust";

    public JetBootsModule(List validItems) {
        super(validItems);
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.ionThruster, 2));
        this.addBaseProperty(JET_ENERGY_CONSUMPTION, 0.0);
        this.addBaseProperty(JET_THRUST, 0.0);
        this.addTradeoffProperty("Thrust", JET_ENERGY_CONSUMPTION, 75.0);
        this.addTradeoffProperty("Thrust", JET_THRUST, 0.08);
    }

    @Override
    public String getCategory() {
        return "Movement";
    }

    @Override
    public String getName() {
        return MODULE_JETBOOTS;
    }

    @Override
    public String getDescription() {
        return "Jet boots are not as strong as a jetpack, but they should at least be strong enough to counteract gravity.";
    }

    @Override
    public void onPlayerTickActive(EntityPlayer player, ItemStack item) {
        ItemStack chest = player.func_82169_q(1);
        if (player.func_70090_H()) {
            return;
        }
        PlayerInputMap movementInput = PlayerInputMap.getInputMapFor(player.field_71092_bJ);
        boolean jumpkey = movementInput.jumpKey;
        ItemStack helmet = player.func_82169_q(3);
        boolean hasFlightControl = MuseItemUtils.itemHasActiveModule(helmet, "Flight Control");
        double jetEnergy = ModuleManager.computeModularProperty(item, JET_ENERGY_CONSUMPTION);
        double thrust = ModuleManager.computeModularProperty(item, JET_THRUST);
        if (jetEnergy < ElectricItemUtils.getPlayerEnergy(player)) {
            thrust *= MusePlayerUtils.getWeightPenaltyRatio(MuseItemUtils.getPlayerWeight(player), 25000.0);
            if (hasFlightControl && thrust > 0.0) {
                thrust = MusePlayerUtils.thrust(player, thrust, true);
                Musique.playerSound(player, "mods.mmmPowersuits.sound.JetBoots", (float)(thrust * 12.5), 1.0f, true);
                ElectricItemUtils.drainPlayerEnergy(player, thrust * jetEnergy);
            } else if (jumpkey && player.field_70181_x < 0.5) {
                thrust = MusePlayerUtils.thrust(player, thrust, false);
                Musique.playerSound(player, "mods.mmmPowersuits.sound.JetBoots", (float)(thrust * 12.5), 1.0f, true);
                ElectricItemUtils.drainPlayerEnergy(player, thrust * jetEnergy);
            } else {
                Musique.stopPlayerSound(player, "mods.mmmPowersuits.sound.JetBoots");
            }
        } else {
            Musique.stopPlayerSound(player, "mods.mmmPowersuits.sound.JetBoots");
        }
    }

    @Override
    public void onPlayerTickInactive(EntityPlayer player, ItemStack item) {
        Musique.stopPlayerSound(player, "mods.mmmPowersuits.sound.JetBoots");
    }

    @Override
    public String getTextureFile() {
        return "jetboots";
    }
}

