/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.misc;

import java.util.List;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IPlayerTickModule;
import net.machinemuse.api.moduletrigger.IToggleableModule;
import net.machinemuse.general.sound.Musique;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class WaterElectrolyzerModule
extends PowerModuleBase
implements IPlayerTickModule,
IToggleableModule {
    public static final String WATERBREATHING_ENERGY_CONSUMPTION = "Jolt Energy";
    public static final String MODULE_WATER_ELECTROLYZER = "Water Electrolyzer";

    public WaterElectrolyzerModule(List validItems) {
        super(validItems);
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.lvcapacitor, 1));
        this.addBaseProperty(WATERBREATHING_ENERGY_CONSUMPTION, 1000.0, "J");
    }

    @Override
    public String getCategory() {
        return "Environment";
    }

    @Override
    public String getName() {
        return MODULE_WATER_ELECTROLYZER;
    }

    @Override
    public String getDescription() {
        return "When you run out of air, this module will jolt the water around you, electrolyzing a small bubble to breathe from.";
    }

    @Override
    public void onPlayerTickActive(EntityPlayer player, ItemStack item) {
        double energyConsumption;
        double energy = ElectricItemUtils.getPlayerEnergy(player);
        if (energy > (energyConsumption = ModuleManager.computeModularProperty(item, WATERBREATHING_ENERGY_CONSUMPTION)) && player.func_70086_ai() < 10) {
            Musique.playClientSound("mods.mmmPowersuits.sound.WaterElectrolyzer", 1.0f);
            ElectricItemUtils.drainPlayerEnergy(player, energyConsumption);
            player.func_70050_g(300);
        }
    }

    @Override
    public void onPlayerTickInactive(EntityPlayer player, ItemStack item) {
    }

    @Override
    public String getTextureFile() {
        return "waterelectrolyzer";
    }
}

