/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.IPowerModule;
import net.machinemuse.api.IPropertyModifier;
import net.machinemuse.powersuits.common.Config;
import net.machinemuse.powersuits.powermodule.PowerModule;
import net.machinemuse.powersuits.powermodule.PropertyModifierFlatAdditive;
import net.machinemuse.powersuits.powermodule.PropertyModifierLinearAdditive;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;

public abstract class PowerModuleBase
implements IPowerModule {
    protected List installCost;
    protected List validItems;
    protected Map propertyModifiers;
    protected static Map units = new HashMap();
    protected NBTTagCompound defaultTag;
    protected boolean isAllowed;
    protected Icon icon;

    public PowerModuleBase(String name, List validItems) {
        this.validItems = validItems;
        this.installCost = new ArrayList();
        this.propertyModifiers = new HashMap();
        this.defaultTag = new NBTTagCompound();
        this.defaultTag.func_74757_a("Active", true);
        this.isAllowed = Config.getConfig().get("Modules", name, true).getBoolean(true);
    }

    public PowerModuleBase(List validItems) {
        this.validItems = validItems;
        this.installCost = new ArrayList();
        this.propertyModifiers = new HashMap();
        this.defaultTag = new NBTTagCompound();
        this.defaultTag.func_74757_a("Active", true);
        this.isAllowed = Config.getConfig().get("Modules", this.getName(), true).getBoolean(true);
    }

    @Override
    public Icon getIcon(ItemStack item) {
        return this.icon;
    }

    @Override
    public void registerIcon(IconRegister register) {
        if (this.getTextureFile() != null) {
            this.icon = register.func_94245_a("mmmPowersuits:" + this.getTextureFile());
        }
    }

    public abstract String getTextureFile();

    @Override
    public List getInstallCost() {
        return this.installCost;
    }

    public PowerModuleBase addInstallCost(ItemStack stack) {
        this.installCost.add(stack);
        return this;
    }

    @Override
    public boolean isValidForItem(ItemStack stack, EntityPlayer player) {
        Item item = stack.func_77973_b();
        return item instanceof IModularItem && this.validItems.contains(item);
    }

    @Override
    public Map getPropertyModifiers() {
        return this.propertyModifiers;
    }

    @Override
    public double applyPropertyModifiers(NBTTagCompound itemTag, String propertyName, double propertyValue) {
        Iterable propertyModifiersIterable = (Iterable)this.propertyModifiers.get(propertyName);
        if (propertyModifiersIterable != null && itemTag.func_74764_b(this.getName())) {
            NBTTagCompound moduleTag = itemTag.func_74775_l(this.getName());
            for (IPropertyModifier modifier : propertyModifiersIterable) {
                propertyValue = modifier.applyModifier(moduleTag, propertyValue);
            }
        }
        return propertyValue;
    }

    @Override
    public NBTTagCompound getNewTag() {
        return (NBTTagCompound)this.defaultTag.func_74737_b();
    }

    @Override
    public boolean isAllowed() {
        return this.isAllowed;
    }

    public void setIsAllowed(boolean allowed) {
        this.isAllowed = allowed;
    }

    public PowerModuleBase addTradeoffProperty(String tradeoffName, String propertyName, double multiplier) {
        double propFromConfig = Config.getConfig().get("Properties", this.getName() + '.' + propertyName + '.' + tradeoffName + ".multiplier", multiplier).getDouble(multiplier);
        return this.addPropertyModifier(propertyName, new PropertyModifierLinearAdditive(tradeoffName, propFromConfig));
    }

    public PowerModuleBase addTradeoffProperty(String tradeoffName, String propertyName, double multiplier, String unit) {
        double propFromConfig = Config.getConfig().get("Properties", this.getName() + '.' + propertyName + '.' + tradeoffName + ".multiplier", multiplier).getDouble(multiplier);
        units.put(propertyName, unit);
        return this.addPropertyModifier(propertyName, new PropertyModifierLinearAdditive(tradeoffName, propFromConfig));
    }

    public PowerModuleBase addPropertyModifier(String propertyName, IPropertyModifier modifier) {
        LinkedList<IPropertyModifier> modifiers = (LinkedList<IPropertyModifier>)this.propertyModifiers.get(propertyName);
        if (modifiers == null) {
            modifiers = new LinkedList<IPropertyModifier>();
            this.propertyModifiers.put(propertyName, modifiers);
        }
        modifiers.add(modifier);
        return this;
    }

    public PowerModuleBase addSimpleTradeoff(IPowerModule module, String tradeoffName, String firstPropertyName, String firstUnits, double firstPropertyBase, double firstPropertyMultiplier, String secondPropertyName, String secondUnits, double secondPropertyBase, double secondPropertyMultiplier) {
        this.addBaseProperty(firstPropertyName, firstPropertyBase, firstUnits);
        this.addTradeoffProperty(tradeoffName, firstPropertyName, firstPropertyMultiplier);
        this.addBaseProperty(secondPropertyName, secondPropertyBase, secondUnits);
        this.addTradeoffProperty(tradeoffName, secondPropertyName, secondPropertyMultiplier);
        return this;
    }

    public PowerModuleBase addBaseProperty(String propertyName, double baseVal) {
        double propFromConfig = Config.getConfig().get("Properties", this.getName() + '.' + propertyName + ".base", baseVal).getDouble(baseVal);
        return this.addPropertyModifier(propertyName, new PropertyModifierFlatAdditive(propFromConfig));
    }

    public PowerModuleBase addBaseProperty(String propertyName, double baseVal, String unit) {
        double propFromConfig = Config.getConfig().get("Properties", this.getName() + '.' + propertyName + ".base", baseVal).getDouble(baseVal);
        units.put(propertyName, unit);
        return this.addPropertyModifier(propertyName, new PropertyModifierFlatAdditive(propFromConfig));
    }

    public boolean equals(PowerModule other) {
        return other != null && other.getName().equals(this.getName());
    }

    @Override
    public String getStitchedTexture(ItemStack item) {
        return "/gui/items.png";
    }
}

