/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.general.gui.frame;

import java.util.ArrayList;
import java.util.List;
import net.machinemuse.api.IPowerModule;
import net.machinemuse.general.geometry.MusePoint2D;
import net.machinemuse.general.geometry.MuseRect;
import net.machinemuse.general.geometry.MuseRelativeRect;
import net.machinemuse.general.gui.clickable.ClickableModule;
import net.machinemuse.utils.render.MuseRenderer;

public class ModuleSelectionSubFrame {
    protected List moduleButtons;
    protected MuseRelativeRect border;
    protected String category;

    public ModuleSelectionSubFrame(String category, MuseRelativeRect border) {
        this.category = category;
        this.border = border;
        this.moduleButtons = new ArrayList();
    }

    public ClickableModule addModule(IPowerModule module) {
        ClickableModule clickie = new ClickableModule(module, new MusePoint2D(0.0, 0.0));
        this.moduleButtons.add(clickie);
        return clickie;
    }

    public void drawPartial(int min, int max) {
        this.refreshButtonPositions();
        double top = this.border.top();
        MuseRenderer.drawString(this.category, this.border.left(), top);
        for (ClickableModule clickie : this.moduleButtons) {
            clickie.drawPartial(this.border.left(), min, this.border.right(), max);
        }
    }

    public void refreshButtonPositions() {
        int i = 0;
        int j = 0;
        for (ClickableModule clickie : this.moduleButtons) {
            if (i > 4) {
                i = 0;
                ++j;
            }
            double x = this.border.left() + 8.0 + (double)(16 * i);
            double y = this.border.top() + 16.0 + (double)(16 * j);
            clickie.move(x, y);
            ++i;
        }
        this.border.setHeight(28 + 16 * j);
    }

    public MuseRect getBorder() {
        return this.border;
    }
}

