/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.machinemuse.api.IPowerModule;
import net.machinemuse.api.moduletrigger.IBlockBreakingModule;
import net.machinemuse.api.moduletrigger.IPlayerTickModule;
import net.machinemuse.api.moduletrigger.IRightClickModule;
import net.machinemuse.api.moduletrigger.IToggleableModule;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ModuleManager {
    protected static final Map moduleMap = new HashMap();
    protected static final List moduleList = new ArrayList();
    protected static final List playerTickModules = new ArrayList();
    protected static final List rightClickModules = new ArrayList();
    protected static final List toggleableModules = new ArrayList();
    protected static final List blockBreakingModules = new ArrayList();

    public static List getAllModules() {
        return moduleList;
    }

    public static List getPlayerTickModules() {
        return playerTickModules;
    }

    public static IPowerModule getModule(String key) {
        return (IPowerModule)moduleMap.get(key);
    }

    public static void addModule(IPowerModule module) {
        moduleMap.put(module.getName(), module);
        moduleList.add(module);
        if (module instanceof IPlayerTickModule) {
            playerTickModules.add((IPlayerTickModule)module);
        }
        if (module instanceof IRightClickModule) {
            rightClickModules.add((IRightClickModule)module);
        }
        if (module instanceof IToggleableModule) {
            toggleableModules.add((IToggleableModule)module);
        }
        if (module instanceof IBlockBreakingModule) {
            blockBreakingModules.add((IBlockBreakingModule)module);
        }
    }

    public static double computeModularProperty(ItemStack stack, String propertyName) {
        double propertyValue = 0.0;
        NBTTagCompound itemTag = MuseItemUtils.getMuseItemTag(stack);
        for (IPowerModule module : moduleList) {
            if (!MuseItemUtils.itemHasActiveModule(stack, module.getName())) continue;
            propertyValue = module.applyPropertyModifiers(itemTag, propertyName, propertyValue);
        }
        return propertyValue;
    }

    public static List getRightClickModules() {
        return rightClickModules;
    }

    public static List getToggleableModules() {
        return toggleableModules;
    }

    public static List getBlockBreakingModules() {
        return blockBreakingModules;
    }
}

