/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.misc;

import java.util.Arrays;
import mods.railcraft.common.util.misc.MiscTools;
import mods.railcraft.common.util.misc.Timer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public class AdjacentTileCache {
    private Timer[] timer = new Timer[6];
    private TileEntity[] cache = new TileEntity[6];
    private final TileEntity source;

    public AdjacentTileCache(TileEntity tile) {
        this.source = tile;
        for (int i = 0; i < this.timer.length; ++i) {
            this.timer[i] = new Timer();
        }
    }

    private TileEntity searchSide(ForgeDirection side) {
        return MiscTools.getBlockTileEntityOnSide(this.source.field_70331_k, this.source.field_70329_l, this.source.field_70330_m, this.source.field_70327_n, side);
    }

    public void refresh() {
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            this.getTileOnSide(side);
        }
    }

    public void purge() {
        Arrays.fill(this.cache, null);
        for (Timer t : this.timer) {
            t.reset();
        }
        this.changed();
    }

    protected void setTile(int side, TileEntity tile) {
        if (this.cache[side] != tile) {
            this.cache[side] = tile;
            this.changed();
        }
    }

    protected void changed() {
    }

    public TileEntity getTileOnSide(ForgeDirection side) {
        int s = side.ordinal();
        if (this.cache[s] != null) {
            if (this.cache[s].func_70320_p()) {
                this.setTile(s, null);
            } else {
                return this.cache[s];
            }
        }
        if (this.timer[s].hasTriggered(this.source.field_70331_k, 32)) {
            this.setTile(s, this.searchSide(side));
        }
        return this.cache[s];
    }
}

