/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.crafting;

import java.util.ArrayList;
import java.util.List;
import mods.railcraft.api.crafting.IBlastFurnaceCraftingManager;
import mods.railcraft.api.crafting.IBlastFurnaceRecipe;
import mods.railcraft.api.crafting.RailcraftCraftingManager;
import mods.railcraft.common.items.RailcraftToolItems;
import mods.railcraft.common.util.inventory.InvTools;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class BlastFurnaceCraftingManager
implements IBlastFurnaceCraftingManager {
    private final List recipes = new ArrayList();

    public static IBlastFurnaceCraftingManager getInstance() {
        return RailcraftCraftingManager.blastFurnace;
    }

    @Override
    public List getFuels() {
        ArrayList<ItemStack> fuels = new ArrayList<ItemStack>();
        fuels.add(RailcraftToolItems.getCoalCoke());
        fuels.add(new ItemStack(Item.field_77705_m, 1, 1));
        return fuels;
    }

    @Override
    public List getRecipes() {
        return this.recipes;
    }

    @Override
    public void addRecipe(ItemStack input, boolean matchDamage, boolean matchNBT, int cookTime, ItemStack output) {
        if (input != null && output != null) {
            this.recipes.add(new BlastFurnaceRecipe(input, matchDamage, matchNBT, cookTime, output));
        }
    }

    @Override
    public IBlastFurnaceRecipe getRecipe(ItemStack input) {
        if (input == null) {
            return null;
        }
        for (BlastFurnaceRecipe r : this.recipes) {
            if (!r.matchDamage || InvTools.isWildcard(r.input) || !InvTools.isItemEqual(input, r.input, true, r.matchNBT)) continue;
            return r;
        }
        for (BlastFurnaceRecipe r : this.recipes) {
            if (!InvTools.isItemEqual(input, r.input, r.matchDamage, r.matchNBT)) continue;
            return r;
        }
        return null;
    }

    public static class BlastFurnaceRecipe
    implements IBlastFurnaceRecipe {
        private final ItemStack input;
        private final boolean matchDamage;
        private final boolean matchNBT;
        private final int cookTime;
        private final ItemStack output;

        public BlastFurnaceRecipe(ItemStack input, boolean matchDamage, boolean matchNBT, int cookTime, ItemStack output) {
            this.input = input.func_77946_l();
            this.matchDamage = matchDamage;
            this.matchNBT = matchNBT;
            this.cookTime = cookTime;
            this.output = output.func_77946_l();
        }

        @Override
        public boolean isRoomForOutput(ItemStack outputSlot) {
            return outputSlot == null || this.output == null || InvTools.isItemEqual(outputSlot, this.output) && outputSlot.field_77994_a + this.output.field_77994_a <= this.output.func_77976_d();
        }

        @Override
        public ItemStack getInput() {
            return this.input.func_77946_l();
        }

        public boolean matchDamage() {
            return this.matchDamage;
        }

        public boolean matchNBT() {
            return this.matchNBT;
        }

        @Override
        public ItemStack getOutput() {
            return this.output.func_77946_l();
        }

        @Override
        public int getOutputStackSize() {
            if (this.output == null) {
                return 0;
            }
            return this.output.field_77994_a;
        }

        @Override
        public int getCookTime() {
            return this.cookTime;
        }
    }
}

