/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.plugins.forge;

import cpw.mods.fml.common.IFuelHandler;
import mods.railcraft.common.blocks.aesthetics.cube.EnumCube;
import mods.railcraft.common.items.RailcraftToolItems;
import mods.railcraft.common.liquids.LiquidFilter;
import mods.railcraft.common.liquids.LiquidManager;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.liquids.LiquidStack;

public class FuelPlugin {
    private static IFuelHandler fuelHandler;

    public static IFuelHandler getFuelHandler() {
        if (fuelHandler == null) {
            fuelHandler = new FuelHandler();
        }
        return fuelHandler;
    }

    public static int getBurnTime(ItemStack stack) {
        try {
            Block block;
            String name;
            if (stack == null) {
                return 0;
            }
            int itemID = stack.func_77973_b().field_77779_bT;
            if (stack.func_77973_b() instanceof ItemBlock && Block.field_71973_m[itemID] != null && (name = (block = Block.field_71973_m[itemID]).func_71917_a()) != null && name.contains("blockScaffold")) {
                return 0;
            }
            LiquidStack liquid = LiquidManager.instance().getLiquidInContainer(stack);
            if (LiquidFilter.LAVA.isLiquidEqual(liquid)) {
                return liquid.amount;
            }
            if (itemID == Item.field_77705_m.field_77779_bT && stack.func_77960_j() == 0 && !InvTools.isSynthetic(stack)) {
                return 3200;
            }
            if (itemID == Item.field_77731_bo.field_77779_bT) {
                return 800;
            }
            name = stack.func_77973_b().func_77658_a();
            if (name != null && name.contains("itemScrap")) {
                return 0;
            }
            return TileEntityFurnace.func_70398_a((ItemStack)stack);
        }
        catch (Exception ex) {
            Game.logError("Error in Fuel Handler! Is some mod creating items that are not compliant with standards?", ex);
            return 0;
        }
    }

    private static class FuelHandler
    implements IFuelHandler {
        private static final int COKE_HEAT = 6400;
        private ItemStack coke = RailcraftToolItems.getCoalCoke();
        private ItemStack cokeBlock = EnumCube.COKE_BLOCK.getItem();

        private FuelHandler() {
        }

        public int getBurnTime(ItemStack fuel) {
            if (InvTools.isItemEqual(fuel, this.coke)) {
                return 6400;
            }
            if (InvTools.isItemEqual(fuel, this.cokeBlock)) {
                return 57600;
            }
            return 0;
        }
    }
}

