/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.gui.containers;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.railcraft.common.carts.EntityLocomotive;
import mods.railcraft.common.carts.EntityLocomotiveSteam;
import mods.railcraft.common.gui.containers.RailcraftContainer;
import mods.railcraft.common.gui.elements.Indicator;
import mods.railcraft.common.gui.elements.LiquidGauge;
import mods.railcraft.common.gui.slots.SlotFuel;
import mods.railcraft.common.gui.slots.SlotOutput;
import mods.railcraft.common.gui.slots.SlotStackFilter;
import mods.railcraft.common.gui.slots.SlotUntouchable;
import mods.railcraft.common.gui.slots.SlotWaterLimited;
import mods.railcraft.common.gui.tooltips.ToolTip;
import mods.railcraft.common.items.ItemTicket;
import mods.railcraft.common.liquids.TankManager;
import mods.railcraft.common.util.misc.MiscTools;
import mods.railcraft.common.util.network.PacketBuilder;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;

public class ContainerLocomotiveSteam
extends RailcraftContainer {
    private final EntityLocomotiveSteam loco;
    private final InventoryPlayer playerInv;
    private float lastBurnTime;
    private float lastItemBurnTime;
    private float lastHeat;
    private EntityLocomotive.LocoSpeed lastSpeed;
    private EntityLocomotive.LocoMode lastMode;
    private int lastLockState;
    public String owner = "[Unknown]";

    public ContainerLocomotiveSteam(InventoryPlayer playerInv, EntityLocomotiveSteam loco) {
        super((IInventory)loco);
        this.loco = loco;
        this.playerInv = playerInv;
        this.addElement(new LiquidGauge(loco.getTankManager().getTank(0), 116, 23, 176, 0, 16, 47));
        this.addElement(new LiquidGauge(loco.getTankManager().getTank(1), 17, 23, 176, 0, 16, 47));
        this.addElement(new Indicator(loco.getHeatIndicator(), 40, 25, 176, 61, 6, 43));
        this.addSlot(new SlotWaterLimited((IInventory)loco, 0, 143, 21));
        this.addSlot(new SlotOutput((IInventory)loco, 1, 143, 56));
        this.addSlot(new SlotFuel((IInventory)loco, 2, 62, 39));
        this.addSlot(new SlotFuel((IInventory)loco, 3, 89, 20));
        this.addSlot(new SlotFuel((IInventory)loco, 4, 89, 38));
        this.addSlot(new SlotFuel((IInventory)loco, 5, 89, 56));
        SlotStackFilter slotTicket = new SlotStackFilter(ItemTicket.FILTER, (IInventory)loco, 6, 116, 94);
        slotTicket.setToolTips(ToolTip.buildToolTip("gui.locomotive.tip.slot.ticket", new String[0]));
        this.addSlot(slotTicket);
        this.addSlot(new SlotUntouchable((IInventory)loco, 7, 134, 94));
        for (int i = 0; i < 3; ++i) {
            for (int k = 0; k < 9; ++k) {
                this.addSlot(new Slot((IInventory)playerInv, k + i * 9 + 9, 8 + k * 18, 123 + i * 18));
            }
        }
        for (int j = 0; j < 9; ++j) {
            this.addSlot(new Slot((IInventory)playerInv, j, 8 + j * 18, 181));
        }
    }

    public void func_75132_a(ICrafting icrafting) {
        super.func_75132_a(icrafting);
        TankManager tMan = this.loco.getTankManager();
        if (tMan != null) {
            tMan.initGuiData(this, icrafting, 0);
            tMan.initGuiData(this, icrafting, 1);
        }
        icrafting.func_71112_a((Container)this, 10, Math.round(this.loco.burnTime));
        icrafting.func_71112_a((Container)this, 11, Math.round(this.loco.currentItemBurnTime));
        icrafting.func_71112_a((Container)this, 12, Math.round(this.loco.heat));
        icrafting.func_71112_a((Container)this, 13, this.loco.getSpeed().ordinal());
        icrafting.func_71112_a((Container)this, 14, this.loco.getMode().ordinal());
        icrafting.func_71112_a((Container)this, 15, this.loco.getLockController().getCurrentState());
        icrafting.func_71112_a((Container)this, 16, MiscTools.isOwnerOrOp(this.loco.getOwner(), this.playerInv.field_70458_d.field_71092_bJ) ? 1 : 0);
        PacketBuilder.instance().sendGuiStringPacket((EntityPlayer)icrafting, this.field_75152_c, 0, this.loco.getOwner());
    }

    public void func_75142_b() {
        super.func_75142_b();
        TankManager tMan = this.loco.getTankManager();
        if (tMan != null) {
            tMan.updateGuiData(this, this.field_75149_d, 0);
            tMan.updateGuiData(this, this.field_75149_d, 1);
        }
        for (int var1 = 0; var1 < this.field_75149_d.size(); ++var1) {
            int lock;
            EntityLocomotive.LocoMode mode;
            EntityLocomotive.LocoSpeed speed;
            ICrafting var2 = (ICrafting)this.field_75149_d.get(var1);
            if (this.lastBurnTime != this.loco.burnTime) {
                var2.func_71112_a((Container)this, 10, Math.round(this.loco.burnTime));
            }
            if (this.lastItemBurnTime != this.loco.currentItemBurnTime) {
                var2.func_71112_a((Container)this, 11, Math.round(this.loco.currentItemBurnTime));
            }
            if (this.lastHeat != this.loco.heat) {
                var2.func_71112_a((Container)this, 12, Math.round(this.loco.heat));
            }
            if (this.lastSpeed != (speed = this.loco.getSpeed())) {
                var2.func_71112_a((Container)this, 13, speed.ordinal());
            }
            if (this.lastMode != (mode = this.loco.getMode())) {
                var2.func_71112_a((Container)this, 14, mode.ordinal());
            }
            if (this.lastLockState == (lock = this.loco.getLockController().getCurrentState())) continue;
            var2.func_71112_a((Container)this, 15, lock);
        }
        this.lastBurnTime = this.loco.burnTime;
        this.lastItemBurnTime = this.loco.currentItemBurnTime;
        this.lastHeat = this.loco.heat;
        this.lastSpeed = this.loco.getSpeed();
        this.lastMode = this.loco.getMode();
        this.lastLockState = this.loco.getLockController().getCurrentState();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int value) {
        TankManager tMan = this.loco.getTankManager();
        if (tMan != null) {
            tMan.processGuiUpdate(id, value);
        }
        switch (id) {
            case 10: {
                this.loco.burnTime = value;
                break;
            }
            case 11: {
                this.loco.currentItemBurnTime = value;
                break;
            }
            case 12: {
                this.loco.heat = value;
                break;
            }
            case 13: {
                this.loco.clientSpeed = EntityLocomotive.LocoSpeed.VALUES[value];
                break;
            }
            case 14: {
                this.loco.clientMode = EntityLocomotive.LocoMode.VALUES[value];
                break;
            }
            case 15: {
                this.loco.getLockController().setCurrentState(value);
                break;
            }
            case 16: {
                this.loco.clientCanLock = value == 1;
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateString(byte id, String data) {
        switch (id) {
            case 0: {
                this.owner = data;
            }
        }
    }
}

