/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import mods.railcraft.api.carts.CartTools;
import mods.railcraft.api.carts.IItemTransfer;
import mods.railcraft.api.carts.ILinkageManager;
import mods.railcraft.api.core.items.IStackFilter;
import mods.railcraft.common.carts.CartContainerBase;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public abstract class TransferCartBase
extends CartContainerBase
implements IItemTransfer {
    protected boolean passThrough = false;

    public TransferCartBase(World world) {
        super(world);
    }

    public TransferCartBase(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    @Override
    public ItemStack offerItem(Object source, ItemStack offer) {
        if (!this.passThrough && this.func_70302_i_() > 0 && (offer = this.moveItemStack(offer, (IInventory)this)) == null) {
            return null;
        }
        ILinkageManager lm = CartTools.getLinkageManager(this.field_70170_p);
        EntityMinecart linkedCart = lm.getLinkedCartA((EntityMinecart)this);
        if (linkedCart != source && linkedCart instanceof IItemTransfer) {
            offer = ((IItemTransfer)linkedCart).offerItem(this, offer);
        }
        if (offer == null) {
            return null;
        }
        linkedCart = lm.getLinkedCartB((EntityMinecart)this);
        if (linkedCart != source && linkedCart instanceof IItemTransfer) {
            offer = ((IItemTransfer)linkedCart).offerItem(this, offer);
        }
        return offer;
    }

    @Override
    public ItemStack requestItem(Object source) {
        ItemStack result = null;
        if (!this.passThrough && this.func_70302_i_() > 0 && (result = this.removeOneItem((IInventory)this)) != null) {
            return result;
        }
        ILinkageManager lm = CartTools.getLinkageManager(this.field_70170_p);
        EntityMinecart linkedCart = lm.getLinkedCartA((EntityMinecart)this);
        if (linkedCart != source && linkedCart instanceof IItemTransfer) {
            result = ((IItemTransfer)linkedCart).requestItem(this);
        }
        if (result != null) {
            return result;
        }
        linkedCart = lm.getLinkedCartB((EntityMinecart)this);
        if (linkedCart != source && linkedCart instanceof IItemTransfer) {
            result = ((IItemTransfer)linkedCart).requestItem(this);
        }
        return result;
    }

    @Override
    public ItemStack requestItem(Object source, ItemStack request) {
        ItemStack result = null;
        if (!this.passThrough && this.func_70302_i_() > 0 && (result = this.removeOneItem((IInventory)this, request)) != null) {
            return result;
        }
        ILinkageManager lm = CartTools.getLinkageManager(this.field_70170_p);
        EntityMinecart linkedCart = lm.getLinkedCartA((EntityMinecart)this);
        if (linkedCart != source && linkedCart instanceof IItemTransfer) {
            result = ((IItemTransfer)linkedCart).requestItem((Object)this, request);
        }
        if (result != null) {
            return result;
        }
        linkedCart = lm.getLinkedCartB((EntityMinecart)this);
        if (linkedCart != source && linkedCart instanceof IItemTransfer) {
            result = ((IItemTransfer)linkedCart).requestItem((Object)this, request);
        }
        return result;
    }

    @Override
    public ItemStack requestItem(Object source, IStackFilter request) {
        ItemStack result = null;
        if (!this.passThrough && this.func_70302_i_() > 0 && (result = this.removeOneItem((IInventory)this, request)) != null) {
            return result;
        }
        ILinkageManager lm = CartTools.getLinkageManager(this.field_70170_p);
        EntityMinecart linkedCart = lm.getLinkedCartA((EntityMinecart)this);
        if (linkedCart != source && linkedCart instanceof IItemTransfer) {
            result = ((IItemTransfer)linkedCart).requestItem((Object)this, request);
        }
        if (result != null) {
            return result;
        }
        linkedCart = lm.getLinkedCartB((EntityMinecart)this);
        if (linkedCart != source && linkedCart instanceof IItemTransfer) {
            result = ((IItemTransfer)linkedCart).requestItem((Object)this, request);
        }
        return result;
    }

    protected final ItemStack removeOneItem(IInventory inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack slot = inv.func_70301_a(i);
            if (slot == null) continue;
            return inv.func_70298_a(i, 1);
        }
        return null;
    }

    protected final ItemStack removeOneItem(IInventory inv, ItemStack filter) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack slot = inv.func_70301_a(i);
            if (slot == null || filter == null || !slot.func_77969_a(filter)) continue;
            return inv.func_70298_a(i, 1);
        }
        return null;
    }

    protected final ItemStack removeOneItem(IInventory inv, IStackFilter filter) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack slot = inv.func_70301_a(i);
            if (slot == null || !filter.matches(slot)) continue;
            return inv.func_70298_a(i, 1);
        }
        return null;
    }

    protected final ItemStack moveItemStack(ItemStack stack, IInventory dest) {
        if (stack == null) {
            return null;
        }
        stack = stack.func_77946_l();
        if (dest == null) {
            return stack;
        }
        boolean movedItem = false;
        do {
            int ii;
            movedItem = false;
            ItemStack destStack = null;
            for (ii = 0; ii < dest.func_70302_i_(); ++ii) {
                int maxStack;
                int room;
                destStack = dest.func_70301_a(ii);
                if (destStack == null || !destStack.func_77969_a(stack) || (room = (maxStack = Math.min(destStack.func_77976_d(), dest.func_70297_j_())) - destStack.field_77994_a) <= 0) continue;
                int move = Math.min(room, stack.field_77994_a);
                destStack.field_77994_a += move;
                stack.field_77994_a -= move;
                if (stack.field_77994_a <= 0) {
                    return null;
                }
                movedItem = true;
            }
            if (movedItem) continue;
            for (ii = 0; ii < dest.func_70302_i_(); ++ii) {
                destStack = dest.func_70301_a(ii);
                if (destStack != null) continue;
                if (stack.field_77994_a <= dest.func_70297_j_()) {
                    dest.func_70299_a(ii, stack);
                    return null;
                }
                dest.func_70299_a(ii, stack.func_77979_a(dest.func_70297_j_()));
                movedItem = true;
            }
        } while (movedItem);
        return stack;
    }
}

