/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import java.util.ArrayList;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.api.core.items.ITrackItem;
import mods.railcraft.api.tracks.RailTools;
import mods.railcraft.common.carts.CartMaintanceBase;
import mods.railcraft.common.carts.EnumCart;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.lang.RailcraftLanguage;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class EntityCartTrackRelayer
extends CartMaintanceBase {
    private static final int SLOT_STOCK = 0;
    private static final int SLOT_EXIST = 0;
    private static final int SLOT_REPLACE = 1;

    public EntityCartTrackRelayer(World world) {
        super(world);
    }

    public EntityCartTrackRelayer(World world, double d, double d1, double d2) {
        this(world);
        this.func_70107_b(d, d1 + (double)this.field_70129_M, d2);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = d;
        this.field_70167_r = d1;
        this.field_70166_s = d2;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (Game.isNotHost(this.field_70170_p)) {
            return;
        }
        this.stockItems(1, 0);
        this.replace();
    }

    private void replace() {
        int id;
        int k;
        int j;
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        if (BlockRailBase.func_72180_d_((World)this.field_70170_p, (int)i, (int)((j = MathHelper.func_76128_c((double)this.field_70163_u)) - 1), (int)(k = MathHelper.func_76128_c((double)this.field_70161_v)))) {
            --j;
        }
        if (BlockRailBase.func_72184_d((int)(id = this.field_70170_p.func_72798_a(i, j, k)))) {
            ItemStack trackExist = this.patternInv.func_70301_a(0);
            ItemStack trackStock = this.func_70301_a(0);
            if (trackExist != null && trackStock != null) {
                int meta;
                if (trackExist.func_77973_b() instanceof ITrackItem) {
                    int meta2;
                    TileEntity tile;
                    ITrackItem trackItem = (ITrackItem)trackExist.func_77973_b();
                    if (trackItem.getPlacedBlockId() == id && trackItem.isPlacedTileEntity(trackExist, tile = this.field_70170_p.func_72796_p(i, j, k)) && (meta2 = this.removeOldTrack(i, j, k, id)) != -1) {
                        this.placeNewTrack(i, j, k, 0, meta2);
                    }
                } else if (trackExist.func_77973_b() instanceof ItemBlock && trackExist.field_77993_c == id && (meta = this.removeOldTrack(i, j, k, id)) != -1) {
                    this.placeNewTrack(i, j, k, 0, meta);
                }
            }
        }
    }

    private int removeOldTrack(int x, int y, int z, int id) {
        ArrayList drops = Block.field_71973_m[id].getBlockDropped(this.field_70170_p, x, y, z, 0, 0);
        for (ItemStack stack : drops) {
            CartTools.offerOrDropItem((EntityMinecart)this, stack);
        }
        int meta = this.field_70170_p.func_72805_g(x, y, z);
        if (((BlockRailBase)Block.field_71973_m[id]).func_72183_n()) {
            meta &= 7;
        }
        this.field_70170_p.func_94575_c(x, y, z, 0);
        return meta;
    }

    private void placeNewTrack(int x, int y, int z, int slotStock, int meta) {
        ItemStack trackStock = this.func_70301_a(slotStock);
        if (trackStock != null && RailTools.placeRailAt(trackStock, this.field_70170_p, x, y, z)) {
            this.field_70170_p.func_72921_c(x, y, z, meta, 2);
            int id = this.field_70170_p.func_72798_a(x, y, z);
            Block.field_71973_m[id].func_71863_a(this.field_70170_p, x, y, z, id);
            this.field_70170_p.func_72845_h(x, y, z);
            this.func_70298_a(slotStock, 1);
            this.blink();
        }
    }

    @Override
    public boolean doInteract(EntityPlayer player) {
        if (Game.isHost(this.field_70170_p)) {
            GuiHandler.openGui(EnumGui.CART_TRACK_RELAYER, player, this.field_70170_p, (Entity)this);
        }
        return true;
    }

    public String func_70303_b() {
        return RailcraftLanguage.translate(EnumCart.TRACK_RELAYER.getTag());
    }

    @Override
    public int addItem(ItemStack stack, boolean doAdd, ForgeDirection from) {
        ItemStack trackReplace = this.patternInv.func_70301_a(1);
        ItemStack trackStock = this.func_70301_a(0);
        if (InvTools.isItemEqual(stack, trackReplace)) {
            if (trackStock == null) {
                if (doAdd) {
                    this.func_70299_a(0, stack.func_77946_l());
                }
                return stack.field_77994_a;
            }
            if (trackStock.field_77994_a + stack.field_77994_a <= trackStock.func_77976_d()) {
                if (doAdd) {
                    trackStock.field_77994_a += stack.field_77994_a;
                }
                return stack.field_77994_a;
            }
            int used = trackStock.func_77976_d() - trackStock.field_77994_a;
            if (doAdd) {
                trackStock.field_77994_a = trackStock.func_77976_d();
            }
            return used;
        }
        return 0;
    }
}

