/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.tracks;

import mods.railcraft.api.tracks.ITrackInstance;
import mods.railcraft.common.blocks.tracks.TileTrack;
import mods.railcraft.common.blocks.tracks.TrackBaseRailcraft;
import mods.railcraft.common.blocks.tracks.speedcontroller.SpeedControllerHighSpeed;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRail;
import net.minecraft.block.BlockRailBase;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TrackTools {
    public static final int TRAIN_LOCKDOWN_DELAY = 20;

    public static boolean isRailBlockAt(World world, int x, int y, int z) {
        return BlockRailBase.func_72180_d_((World)world, (int)x, (int)y, (int)z);
    }

    public static boolean isRailBlock(int blockId) {
        return BlockRailBase.func_72184_d((int)blockId);
    }

    public static int getTrackMeta(World world, EntityMinecart cart, int x, int y, int z) {
        return TrackTools.getTrackMeta(world, world.func_72798_a(x, y, z), cart, x, y, z);
    }

    public static int getTrackMeta(World world, int blockId, EntityMinecart cart, int x, int y, int z) {
        return ((BlockRailBase)Block.field_71973_m[blockId]).getBasicRailMetadata((IBlockAccess)world, cart, x, y, z);
    }

    public static ITrackInstance getTrackInstanceAt(World world, int x, int y, int z) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileTrack) {
            return ((TileTrack)tile).getTrackInstance();
        }
        return null;
    }

    public static boolean isHighSpeedTrackAt(World world, int x, int y, int z) {
        ITrackInstance track = TrackTools.getTrackInstanceAt(world, x, y, z);
        if (track instanceof TrackBaseRailcraft) {
            return ((TrackBaseRailcraft)track).speedController instanceof SpeedControllerHighSpeed;
        }
        return false;
    }

    public static boolean areTracksConnectedAlongAxis(World world, int i1, int j1, int k1, int i2, int j2, int k2) {
        block13: {
            block12: {
                if (j1 < 0 || j2 < 0) {
                    return false;
                }
                if (i1 != i2 && k1 != k2) {
                    return false;
                }
                if (i1 == i2) break block12;
                int min = 0;
                int max = 0;
                int jj = 0;
                if (i1 < i2) {
                    min = i1;
                    max = i2;
                    jj = j1;
                } else {
                    min = i2;
                    max = i1;
                    jj = j2;
                }
                for (int ii = min; ii <= max; ++ii) {
                    if (!world.func_72899_e(ii, jj, k1) || BlockRail.func_72180_d_((World)world, (int)ii, (int)jj, (int)k1)) continue;
                    if (BlockRail.func_72180_d_((World)world, (int)ii, (int)(jj - 1), (int)k1)) {
                        --jj;
                        continue;
                    }
                    if (BlockRail.func_72180_d_((World)world, (int)ii, (int)(jj + 1), (int)k1)) {
                        ++jj;
                        continue;
                    }
                    return false;
                }
                break block13;
            }
            if (k1 == k2) break block13;
            int min = 0;
            int max = 0;
            int jj = 0;
            if (k1 < k2) {
                min = k1;
                max = k2;
                jj = j1;
            } else {
                min = k2;
                max = k1;
                jj = j2;
            }
            for (int kk = min; kk <= max; ++kk) {
                if (!world.func_72899_e(i1, jj, kk) || BlockRail.func_72180_d_((World)world, (int)i1, (int)jj, (int)kk)) continue;
                if (BlockRail.func_72180_d_((World)world, (int)i1, (int)(jj - 1), (int)kk)) {
                    --jj;
                    continue;
                }
                if (BlockRail.func_72180_d_((World)world, (int)i1, (int)(jj + 1), (int)kk)) {
                    ++jj;
                    continue;
                }
                return false;
            }
        }
        return true;
    }
}

