/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.tracks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.common.blocks.signals.ISecure;
import mods.railcraft.common.blocks.tracks.TileTrack;
import mods.railcraft.common.blocks.tracks.TrackBaseRailcraft;
import mods.railcraft.common.gui.buttons.LockButtonState;
import mods.railcraft.common.gui.buttons.MultiButtonController;
import mods.railcraft.common.util.misc.MiscTools;
import mods.railcraft.common.util.network.IGuiReturnHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public abstract class TrackSecured
extends TrackBaseRailcraft
implements IGuiReturnHandler,
ISecure {
    private MultiButtonController lockController = new MultiButtonController(0, LockButtonState.VALUES);

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        this.lockController.writeToNBT(data, "lock");
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.lockController.readFromNBT(data, "lock");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte(this.lockController.getCurrentState());
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.lockController.setCurrentState(data.readByte());
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        data.writeByte(this.lockController.getCurrentState());
    }

    @Override
    public void readGuiData(DataInputStream data, EntityPlayer sender) throws IOException {
        byte lock = data.readByte();
        if (sender == null || this.canAccess(sender.field_71092_bJ)) {
            this.lockController.setCurrentState(lock);
        }
    }

    private boolean canAccess(String username) {
        return !this.isSecure() || MiscTools.isOwnerOrOp(this.getOwner(), username);
    }

    @Override
    public MultiButtonController getLockController() {
        return this.lockController;
    }

    @Override
    public boolean isSecure() {
        return this.lockController.getButtonState() == LockButtonState.LOCKED;
    }

    @Override
    public float getHardness() {
        return this.isSecure() ? -1.0f : super.getHardness();
    }

    @Override
    public String func_70303_b() {
        return ((TileTrack)this.getTile()).func_70303_b();
    }

    @Override
    public String getOwner() {
        return ((TileTrack)this.getTile()).getOwner();
    }
}

