/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.tracks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.core.IPostConnection;
import mods.railcraft.api.tracks.ITrackBlocksMovement;
import mods.railcraft.api.tracks.ITrackCustomShape;
import mods.railcraft.api.tracks.ITrackPowered;
import mods.railcraft.api.tracks.ITrackReversable;
import mods.railcraft.common.blocks.tracks.EnumTrack;
import mods.railcraft.common.blocks.tracks.TrackBaseRailcraft;
import mods.railcraft.common.util.misc.MiscTools;
import mods.railcraft.common.util.sounds.SoundHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class TrackGated
extends TrackBaseRailcraft
implements ITrackReversable,
ITrackPowered,
ITrackCustomShape,
IPostConnection,
ITrackBlocksMovement {
    protected boolean powered;
    protected boolean open;
    protected boolean reversed;

    @Override
    public EnumTrack getTrackType() {
        return EnumTrack.GATED;
    }

    @Override
    public boolean blockActivated(EntityPlayer player) {
        if (!super.blockActivated(player)) {
            this.setOpen(!this.open);
        }
        return true;
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool() {
        return AxisAlignedBB.func_72332_a().func_72299_a((double)this.tileEntity.field_70329_l, (double)this.tileEntity.field_70330_m, (double)this.tileEntity.field_70327_n, (double)(this.tileEntity.field_70329_l + 1), (double)(this.tileEntity.field_70330_m + 1), (double)(this.tileEntity.field_70327_n + 1));
    }

    @Override
    public MovingObjectPosition collisionRayTrace(Vec3 vec3d, Vec3 vec3d1) {
        return MiscTools.collisionRayTrace(vec3d, vec3d1, this.getX(), this.getY(), this.getZ());
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        int meta = this.tileEntity.func_70322_n();
        if (this.isGateOpen()) {
            return null;
        }
        if (meta == 0) {
            return AxisAlignedBB.func_72332_a().func_72299_a((double)this.tileEntity.field_70329_l, (double)this.tileEntity.field_70330_m, (double)((float)this.tileEntity.field_70327_n + 0.375f), (double)(this.tileEntity.field_70329_l + 1), (double)((float)this.tileEntity.field_70330_m + 1.5f), (double)((float)this.tileEntity.field_70327_n + 0.625f));
        }
        return AxisAlignedBB.func_72332_a().func_72299_a((double)((float)this.tileEntity.field_70329_l + 0.375f), (double)this.tileEntity.field_70330_m, (double)this.tileEntity.field_70327_n, (double)((float)this.tileEntity.field_70329_l + 0.625f), (double)((float)this.tileEntity.field_70330_m + 1.5f), (double)(this.tileEntity.field_70327_n + 1));
    }

    @Override
    public boolean canMakeSlopes() {
        return false;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean open) {
        boolean state = this.isGateOpen();
        this.open = open;
        if (state != this.isGateOpen()) {
            this.playSound();
            this.sendUpdateToClient();
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.func_74757_a("powered", this.powered);
        nbttagcompound.func_74757_a("open", this.open);
        nbttagcompound.func_74757_a("reversed", this.reversed);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.powered = nbttagcompound.func_74767_n("powered");
        this.open = nbttagcompound.func_74767_n("open");
        this.reversed = nbttagcompound.func_74767_n("reversed");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.powered);
        data.writeBoolean(this.reversed);
        data.writeBoolean(this.open);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.setPowered(data.readBoolean());
        this.setReversed(data.readBoolean());
        this.setOpen(data.readBoolean());
        this.markBlockNeedsUpdate();
    }

    @Override
    public boolean isReversed() {
        return this.reversed;
    }

    @Override
    public void setReversed(boolean reversed) {
        this.reversed = reversed;
    }

    @Override
    public boolean isPowered() {
        return this.powered;
    }

    @Override
    public void setPowered(boolean powered) {
        boolean state = this.isGateOpen();
        this.powered = powered;
        if (state != this.isGateOpen()) {
            this.playSound();
            this.sendUpdateToClient();
        }
    }

    private void playSound() {
        SoundHelper.playFX(this.getWorld(), null, 1003, this.tileEntity.field_70329_l, this.tileEntity.field_70330_m, this.tileEntity.field_70327_n, 0);
    }

    public boolean isGateOpen() {
        return this.isPowered() || this.isOpen();
    }

    @Override
    public boolean connectsAt(World world, int i, int j, int k, ForgeDirection side) {
        switch (side) {
            case UP: 
            case DOWN: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean blocksMovement() {
        return !this.isGateOpen();
    }
}

